/*
 * Decompiled with CFR 0.152.
 */
package jxbrowser.impl;

import com.teamdev.jxbrowser.chromium.AuthRequiredParams;
import com.teamdev.jxbrowser.chromium.BeforeRedirectParams;
import com.teamdev.jxbrowser.chromium.BeforeSendHeadersParams;
import com.teamdev.jxbrowser.chromium.BeforeSendProxyHeadersParams;
import com.teamdev.jxbrowser.chromium.BeforeURLRequestParams;
import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.CacheStorage;
import com.teamdev.jxbrowser.chromium.CertificatesDialogParams;
import com.teamdev.jxbrowser.chromium.CloseStatus;
import com.teamdev.jxbrowser.chromium.ColorChooserParams;
import com.teamdev.jxbrowser.chromium.ContextMenuHandler;
import com.teamdev.jxbrowser.chromium.Cookie;
import com.teamdev.jxbrowser.chromium.CookieStorage;
import com.teamdev.jxbrowser.chromium.DataReceivedParams;
import com.teamdev.jxbrowser.chromium.DefaultLoadHandler;
import com.teamdev.jxbrowser.chromium.DialogHandler;
import com.teamdev.jxbrowser.chromium.DialogParams;
import com.teamdev.jxbrowser.chromium.DownloadHandler;
import com.teamdev.jxbrowser.chromium.DownloadItem;
import com.teamdev.jxbrowser.chromium.EditorCommand;
import com.teamdev.jxbrowser.chromium.FileChooserParams;
import com.teamdev.jxbrowser.chromium.HeadersReceivedParams;
import com.teamdev.jxbrowser.chromium.JSValue;
import com.teamdev.jxbrowser.chromium.LoadHTMLParams;
import com.teamdev.jxbrowser.chromium.LoadHandler;
import com.teamdev.jxbrowser.chromium.LoadParams;
import com.teamdev.jxbrowser.chromium.NavigationEntry;
import com.teamdev.jxbrowser.chromium.NetworkDelegate;
import com.teamdev.jxbrowser.chromium.PACScriptErrorParams;
import com.teamdev.jxbrowser.chromium.PopupContainer;
import com.teamdev.jxbrowser.chromium.PopupHandler;
import com.teamdev.jxbrowser.chromium.PopupParams;
import com.teamdev.jxbrowser.chromium.PrintHandler;
import com.teamdev.jxbrowser.chromium.PrintJob;
import com.teamdev.jxbrowser.chromium.PrintStatus;
import com.teamdev.jxbrowser.chromium.PromptDialogParams;
import com.teamdev.jxbrowser.chromium.ReloadPostDataParams;
import com.teamdev.jxbrowser.chromium.RequestCompletedParams;
import com.teamdev.jxbrowser.chromium.RequestParams;
import com.teamdev.jxbrowser.chromium.ResponseStartedParams;
import com.teamdev.jxbrowser.chromium.SavePageType;
import com.teamdev.jxbrowser.chromium.SendHeadersParams;
import com.teamdev.jxbrowser.chromium.UnloadDialogParams;
import com.teamdev.jxbrowser.chromium.XPathResult;
import com.teamdev.jxbrowser.chromium.XPathResultType;
import com.teamdev.jxbrowser.chromium.dom.By;
import com.teamdev.jxbrowser.chromium.dom.DOMDocument;
import com.teamdev.jxbrowser.chromium.dom.DOMElement;
import com.teamdev.jxbrowser.chromium.dom.DOMNode;
import com.teamdev.jxbrowser.chromium.dom.DOMNodeAtPoint;
import com.teamdev.jxbrowser.chromium.dom.SearchContext;
import com.teamdev.jxbrowser.chromium.events.FinishLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.LoadAdapter;
import com.teamdev.jxbrowser.chromium.events.LoadListener;
import com.teamdev.jxbrowser.chromium.events.RenderAdapter;
import com.teamdev.jxbrowser.chromium.events.RenderEvent;
import com.teamdev.jxbrowser.chromium.events.RenderListener;
import com.teamdev.jxbrowser.chromium.events.ScriptContextListener;
import com.teamdev.jxbrowser.chromium.events.StatusListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPCException;
import com.teamdev.jxbrowser.chromium.swing.DefaultPopupHandler;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import jxbrowser.api.BrowserSearch;
import jxbrowser.api.NavigationUrlAcceptor;
import jxbrowser.impl.JxBrowserSearch;
import jxbrowser.impl.JxBrowserSearchParams;
import jxbrowser.util.CannotFindElementException;
import jxbrowser.util.JxBrowserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JxBrowser {
    private static final Logger LOG = LoggerFactory.getLogger(JxBrowser.class);
    private final Browser browser;
    private final BrowserSearch search;

    public JxBrowser(Browser browser) {
        this.browser = browser;
        this.search = new JxBrowserSearch(browser);
        browser.setDialogHandler((DialogHandler)new SilentDialogHandler());
        browser.setPopupHandler((PopupHandler)new SilentPopupHandler());
        browser.setDownloadHandler((DownloadHandler)new SilentDownloadHandler());
        browser.setPrintHandler((PrintHandler)new SilentPrintHandler());
        browser.addRenderListener((RenderListener)new LogRenderAdapter());
        browser.addDisposeListener(disposeEvent -> JxBrowserUtils.unregisterBrowser(this));
        JxBrowserUtils.registerBrowser(this);
    }

    Browser getBrowser() {
        return this.browser;
    }

    public void navigate(String url) {
        this.browser.loadURL(url);
    }

    public void navigateBlocked(String url) throws InterruptedException {
        this.invokeAndWaitReady(() -> this.navigate(url));
    }

    public void waitReady() throws InterruptedException {
        this.waitReady(0);
    }

    public void waitReady(int milliseconds) throws InterruptedException {
        JxBrowser.waitReady(this.browser, milliseconds);
    }

    private static void waitReady(Browser browser, int milliseconds) throws InterruptedException {
        int all = 0;
        while (browser.isLoading() && all <= milliseconds) {
            if (milliseconds > 0) {
                all += 25;
            }
            TimeUnit.MILLISECONDS.sleep(25L);
        }
    }

    public BrowserPreferences getPreferences() {
        return this.browser.getPreferences();
    }

    public void goBack() {
        this.browser.goBack();
    }

    public void goForward() {
        this.browser.goForward();
    }

    public void setContent(String pageContent) {
        this.browser.loadHTML(pageContent);
    }

    public void setContent(LoadHTMLParams loadHTMLParams) {
        this.browser.loadHTML(loadHTMLParams);
    }

    public void setDialogHandler(DialogHandler dialogHandler) {
        this.browser.setDialogHandler(dialogHandler);
    }

    public void setDownloadHandler(DownloadHandler downloadHandler) {
        this.browser.setDownloadHandler(downloadHandler);
    }

    public void executeCommand(EditorCommand editorCommand) {
        this.browser.executeCommand(editorCommand);
    }

    public void executeCommand(EditorCommand editorCommand, String value) {
        this.browser.executeCommand(editorCommand, value);
    }

    public void size(int width, int height) {
        this.browser.setSize(width, height);
    }

    public void stop() {
        this.browser.stop();
    }

    public void refresh() {
        this.browser.reload();
    }

    public String getCurrentLocation() {
        return this.browser.getURL();
    }

    public String getContent() {
        return this.browser.getHTML();
    }

    public boolean canGoBack() {
        return this.browser.canGoBack();
    }

    public boolean canGoForward() {
        return this.browser.canGoForward();
    }

    public void zoomIn() {
        this.browser.zoomIn();
    }

    public void zoomOut() {
        this.browser.zoomOut();
    }

    public void saveHtml(String filePath, String dirPath) {
        this.browser.saveWebPage(filePath, dirPath, SavePageType.ONLY_HTML);
    }

    public JSValue executeJavaScript(String s) {
        return this.browser.executeJavaScriptAndReturnValue(s);
    }

    public String executeScript(String s) {
        JSValue jsValue = this.executeJavaScript(s);
        return jsValue.isString() ? jsValue.getStringValue() : jsValue.toString();
    }

    public DOMDocument getDocument() {
        return this.browser.getDocument();
    }

    public DOMDocument getReadyDocument() throws InterruptedException {
        return JxBrowser.getReadyDocument(this.browser);
    }

    private static DOMDocument getReadyDocument(Browser browser) throws InterruptedException {
        int attempts = 600;
        DOMDocument document;
        while ((document = browser.getDocument()).getDocumentElement() == null) {
            if (attempts-- < 0) {
                throw new RuntimeException(new TimeoutException());
            }
            Thread.sleep(100L);
        }
        return document;
    }

    public synchronized void dispose() {
        try {
            if (!this.browser.isDisposed()) {
                this.browser.stop();
                this.browser.dispose();
            }
        }
        catch (IPCException e) {
            LOG.error("", (Throwable)e);
        }
    }

    public CookieStorage getCookieStorage() {
        return this.browser.getCookieStorage();
    }

    public CacheStorage getCacheStorage() {
        return this.browser.getCacheStorage();
    }

    public BrowserSearch getSearch() {
        return this.search;
    }

    public void findPrevious(JxBrowserSearchParams jxBrowserSearchParams) {
        this.search.findPrevious(jxBrowserSearchParams);
    }

    public void findNext(JxBrowserSearchParams jxBrowserSearchParams) {
        this.search.findNext(jxBrowserSearchParams);
    }

    public void addNavigationUrlAcceptor(NavigationUrlAcceptor navigationUrlAcceptor) {
        this.browser.setLoadHandler((LoadHandler)new UrlAcceptorLoadHandler(navigationUrlAcceptor));
    }

    public void setPopupHandler(PopupHandler popupHandler) {
        this.browser.setPopupHandler(popupHandler);
    }

    public void addNavigationListener(LoadListener loadListener) {
        this.browser.addLoadListener(loadListener);
    }

    public void addStatusListener(StatusListener statusListener) {
        this.browser.addStatusListener(statusListener);
    }

    public void addScriptContextListener(ScriptContextListener scriptContextListener) {
        this.browser.addScriptContextListener(scriptContextListener);
    }

    public void addZoomLevelWhenContentLoaded(double level) {
        this.addNavigationListener((LoadListener)new ZoomLoadAdapter(this.browser, level));
    }

    public void setContextMenuHandler(ContextMenuHandler contextMenuHandler) {
        this.browser.setContextMenuHandler(contextMenuHandler);
    }

    public boolean isNavigationFinished() {
        return !this.browser.isLoading();
    }

    public boolean isDisposed() {
        return this.browser.isDisposed();
    }

    public boolean isLoading() {
        return this.browser.isLoading();
    }

    public NavigationEntry getCurrentNavigationEntry() {
        return this.browser.getCurrentNavigationEntry();
    }

    public DOMNodeAtPoint getNodeAtPoint(int x, int y) {
        return this.browser.getNodeAtPoint(x, y);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JxBrowser)) {
            return false;
        }
        JxBrowser jxBrowser = (JxBrowser)o;
        return this.browser.equals(jxBrowser.browser);
    }

    public int hashCode() {
        return this.browser.hashCode();
    }

    public DOMElement byId(String id) throws CannotFindElementException, InterruptedException {
        return JxBrowser.byId(() -> {
            DOMDocument document = this.browser.getDocument();
            return document != null ? document.getDocumentElement() : null;
        }, id);
    }

    public static DOMElement byId(Supplier<SearchContext> searchContextSupplier, String id) throws CannotFindElementException, InterruptedException {
        try {
            return JxBrowser.wait(searchContextSupplier, searchContext -> searchContext.findElement(By.id((String)id)));
        }
        catch (CannotFindElementException e) {
            throw new CannotFindElementException("Id = " + id, e);
        }
    }

    public List<DOMElement> byTag(String tagName) throws CannotFindElementException, InterruptedException {
        return JxBrowser.byTag(() -> {
            DOMDocument document = this.browser.getDocument();
            return document.getDocumentElement();
        }, tagName);
    }

    public static List<DOMElement> byTag(Supplier<SearchContext> searchContextSupplier, String tagName) throws CannotFindElementException, InterruptedException {
        try {
            return JxBrowser.wait(searchContextSupplier, document -> document.findElements(By.tagName((String)tagName)));
        }
        catch (CannotFindElementException e) {
            throw new CannotFindElementException("Tag name = " + tagName, e);
        }
    }

    public List<DOMElement> byClass(String className) throws CannotFindElementException, InterruptedException {
        return JxBrowser.byClass(() -> {
            DOMDocument document = this.browser.getDocument();
            return document != null ? document.getDocumentElement() : null;
        }, className);
    }

    public static List<DOMElement> byClass(Supplier<SearchContext> searchContextSupplier, String className) throws CannotFindElementException, InterruptedException {
        try {
            return JxBrowser.wait(searchContextSupplier, searchContext -> searchContext.findElements(By.className((String)className)));
        }
        catch (CannotFindElementException e) {
            throw new CannotFindElementException("Class name = " + className, e);
        }
    }

    public DOMNode byText(String text) throws CannotFindElementException, InterruptedException {
        return JxBrowser.byText(() -> {
            DOMDocument document = this.browser.getDocument();
            return document != null ? document.getDocumentElement() : null;
        }, text);
    }

    public static DOMNode byText(Supplier<SearchContext> searchContextSupplier, String text) throws CannotFindElementException, InterruptedException {
        try {
            return JxBrowser.wait(searchContextSupplier, searchContext -> {
                XPathResult evaluate = searchContext.evaluate("//*[contains(text(), '" + text + "')]", XPathResultType.FIRST_ORDERED_NODE_TYPE);
                return evaluate.getSingleNode();
            });
        }
        catch (CannotFindElementException e) {
            throw new CannotFindElementException("Text = " + text, e);
        }
    }

    public List<DOMElement> findElements(By by) throws CannotFindElementException, InterruptedException {
        return JxBrowser.findElements(() -> {
            DOMDocument document = this.browser.getDocument();
            return document != null ? document.getDocumentElement() : null;
        }, by);
    }

    public static List<DOMElement> findElements(Supplier<SearchContext> searchContextSupplier, By by) throws CannotFindElementException, InterruptedException {
        try {
            return JxBrowser.wait(searchContextSupplier, searchContext -> searchContext.findElements(by));
        }
        catch (CannotFindElementException e) {
            throw new CannotFindElementException(by.getType() + " " + by.getValue(), e);
        }
    }

    public DOMElement findElement(By by) throws CannotFindElementException, InterruptedException {
        return JxBrowser.findElement(() -> {
            DOMDocument document = this.browser.getDocument();
            return document != null ? document.getDocumentElement() : null;
        }, by);
    }

    public static DOMElement findElement(Supplier<SearchContext> searchContextSupplier, By by) throws CannotFindElementException, InterruptedException {
        try {
            return JxBrowser.wait(searchContextSupplier, searchContext -> searchContext.findElement(by));
        }
        catch (CannotFindElementException e) {
            throw new CannotFindElementException(by.getType() + " " + by.getValue(), e);
        }
    }

    private static <T, S extends SearchContext> T wait(Supplier<S> searchContextSupplier, Function<S, T> callback) throws CannotFindElementException, InterruptedException {
        return JxBrowser.wait(searchContextSupplier, callback, 30);
    }

    private static <T, S extends SearchContext> T wait(Supplier<S> searchContextSupplier, Function<S, T> callback, int maxCalls) throws CannotFindElementException, InterruptedException {
        T result;
        int currentCall = 0;
        do {
            if (++currentCall > maxCalls) {
                throw new CannotFindElementException();
            }
            SearchContext s = (SearchContext)searchContextSupplier.get();
            result = s != null ? (T)callback.apply(s) : null;
            Thread.sleep(1000L);
        } while (result == null || result instanceof Collection && ((Collection)result).isEmpty());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeAndWaitReady(Runnable runnable) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        LoadAdapter listener = new LoadAdapter(){

            public void onFinishLoadingFrame(FinishLoadingEvent event) {
                if (event.isMainFrame()) {
                    latch.countDown();
                }
            }
        };
        this.browser.addLoadListener((LoadListener)listener);
        try {
            runnable.run();
            if (!latch.await(45L, TimeUnit.SECONDS)) {
                throw new RuntimeException(new TimeoutException());
            }
        }
        finally {
            this.browser.removeLoadListener((LoadListener)listener);
        }
    }

    private static class ZoomLoadAdapter
    extends LoadAdapter {
        private final Browser browser;
        private final double level;

        private ZoomLoadAdapter(Browser browser, double level) {
            this.browser = browser;
            this.level = level;
        }

        public void onFinishLoadingFrame(FinishLoadingEvent finishLoadingEvent) {
            if (Double.compare(this.level, 0.5) <= 0) {
                this.browser.setZoomLevel(-3.2);
                return;
            }
            if (Double.compare(this.level, 0.75) <= 0) {
                this.browser.setZoomLevel(-1.2);
                return;
            }
            if (Double.compare(this.level, 1.0) <= 0) {
                return;
            }
            if (Double.compare(this.level, 1.25) <= 0) {
                this.browser.setZoomLevel(1.3);
                return;
            }
            if (Double.compare(this.level, 1.5) <= 0) {
                this.browser.setZoomLevel(2.5);
                return;
            }
            if (Double.compare(this.level, 1.75) <= 0) {
                this.browser.setZoomLevel(3.0);
                return;
            }
            if (Double.compare(this.level, 2.0) <= 0) {
                this.browser.setZoomLevel(4.0);
                return;
            }
            if (Double.compare(this.level, 2.25) <= 0) {
                this.browser.setZoomLevel(4.5);
                return;
            }
            if (Double.compare(this.level, 2.5) <= 0) {
                this.browser.setZoomLevel(5.25);
                return;
            }
            if (Double.compare(this.level, 2.75) <= 0) {
                this.browser.setZoomLevel(5.5);
                return;
            }
            if (Double.compare(this.level, 3.0) <= 0) {
                this.browser.setZoomLevel(6.25);
                return;
            }
            if (Double.compare(this.level, 3.25) <= 0) {
                this.browser.setZoomLevel(6.75);
                return;
            }
            if (Double.compare(this.level, 3.5) <= 0) {
                this.browser.setZoomLevel(7.25);
                return;
            }
            if (Double.compare(this.level, 3.75) <= 0) {
                this.browser.setZoomLevel(7.4);
                return;
            }
            if (Double.compare(this.level, 4.0) <= 0) {
                this.browser.setZoomLevel(7.75);
                return;
            }
            this.browser.setZoomLevel(this.level * 2.0);
        }
    }

    private static class LogRenderAdapter
    extends RenderAdapter {
        private LogRenderAdapter() {
        }

        public void onRenderGone(RenderEvent renderEvent) {
            if (renderEvent != null) {
                LOG.error("Renderer gone. Error code {}. Termination status {}.", (Object)renderEvent.getErrorCode(), (Object)renderEvent.getTerminationStatus());
            }
        }
    }

    private static class UrlAcceptorLoadHandler
    extends DefaultLoadHandler {
        private final NavigationUrlAcceptor navigationUrlAcceptor;

        public UrlAcceptorLoadHandler(NavigationUrlAcceptor navigationUrlAcceptor) {
            this.navigationUrlAcceptor = navigationUrlAcceptor;
        }

        public boolean onLoad(LoadParams loadParams) {
            return !this.navigationUrlAcceptor.acceptURL(loadParams.getURL());
        }
    }

    public static class SilentNetworkDelegate
    implements NetworkDelegate {
        public void onBeforeURLRequest(BeforeURLRequestParams beforeURLRequestParams) {
        }

        public void onBeforeRedirect(BeforeRedirectParams beforeRedirectParams) {
        }

        public void onBeforeSendHeaders(BeforeSendHeadersParams beforeSendHeadersParams) {
        }

        public void onSendHeaders(SendHeadersParams sendHeadersParams) {
        }

        public void onHeadersReceived(HeadersReceivedParams headersReceivedParams) {
        }

        public void onResponseStarted(ResponseStartedParams responseStartedParams) {
        }

        public void onDataReceived(DataReceivedParams dataReceivedParams) {
        }

        public void onCompleted(RequestCompletedParams requestCompletedParams) {
        }

        public void onDestroyed(RequestParams requestParams) {
        }

        public boolean onAuthRequired(AuthRequiredParams authRequiredParams) {
            return false;
        }

        public boolean onCanSetCookies(String s, List<Cookie> list) {
            return true;
        }

        public boolean onCanGetCookies(String s, List<Cookie> list) {
            return true;
        }

        public void onBeforeSendProxyHeaders(BeforeSendProxyHeadersParams beforeSendProxyHeadersParams) {
        }

        public void onPACScriptError(PACScriptErrorParams pacScriptErrorParams) {
        }
    }

    public static class SilentDialogHandler
    implements DialogHandler {
        public void onAlert(DialogParams dialogParams) {
        }

        public CloseStatus onConfirmation(DialogParams dialogParams) {
            return null;
        }

        public CloseStatus onPrompt(PromptDialogParams promptDialogParams) {
            return null;
        }

        public CloseStatus onFileChooser(FileChooserParams fileChooserParams) {
            return null;
        }

        public CloseStatus onBeforeUnload(UnloadDialogParams unloadDialogParams) {
            return null;
        }

        public CloseStatus onSelectCertificate(CertificatesDialogParams certificatesDialogParams) {
            return null;
        }

        public CloseStatus onReloadPostData(ReloadPostDataParams reloadPostDataParams) {
            return null;
        }

        public CloseStatus onColorChooser(ColorChooserParams colorChooserParams) {
            return null;
        }
    }

    public static class SilentPrintHandler
    implements PrintHandler {
        public PrintStatus onPrint(PrintJob printJob) {
            return PrintStatus.CANCEL;
        }
    }

    public static class SilentDownloadHandler
    implements DownloadHandler {
        public boolean allowDownload(DownloadItem downloadItem) {
            return false;
        }
    }

    public static class SilentPopupHandler
    extends DefaultPopupHandler {
        public PopupContainer handlePopup(PopupParams popupParams) {
            return (browser1, rectangle) -> {};
        }
    }
}

