/*
 * Decompiled with CFR 0.152.
 */
package jxbrowser.impl;

import com.teamdev.jxbrowser.chromium.InputEventsHandler;
import com.teamdev.jxbrowser.chromium.swing.BrowserView;
import com.teamdev.jxbrowser.chromium.swing.internal.LightWeightWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import jxbrowser.impl.JxBrowser;

public class JxBrowserView
extends JComponent {
    private BrowserView browserView;
    private JxBrowser browser;

    public JxBrowserView(JxBrowser browser) {
        this.browser = browser;
        this.setLayout(new BorderLayout());
        this.browserView = new BrowserView(browser.getBrowser());
        this.browserView.addMouseWheelListener(e -> {
            if (e.getModifiers() == 2) {
                if (e.getPreciseWheelRotation() < 0.0) {
                    browser.zoomIn();
                } else {
                    browser.zoomOut();
                }
            }
        });
        this.add((Component)this.browserView);
    }

    public JxBrowser getBrowser() {
        return this.browser;
    }

    public BufferedImage getScreenShot(int width, int height) {
        BufferedImage bufferedImage = new BufferedImage(width, height, 6);
        Graphics2D graphics = (Graphics2D)bufferedImage.getGraphics();
        LightWeightWidget lightWeightWidget = (LightWeightWidget)this.browserView.getComponent(0);
        graphics.drawImage(lightWeightWidget.getImage(), 0, 0, null);
        return bufferedImage;
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.browserView.addMouseListener(mouseListener);
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        this.browserView.addKeyListener(listener);
    }

    @Override
    public void addComponentListener(ComponentListener componentListener) {
        this.browserView.addComponentListener(componentListener);
    }

    public void setKeyEventsHandler(InputEventsHandler<KeyEvent> inputEventsHandler) {
        this.browserView.setKeyEventsHandler(inputEventsHandler);
    }
}

