/*
 * Decompiled with CFR 0.152.
 */
package jxbrowser.util;

import com.teamdev.jxbrowser.chromium.AuthRequiredParams;
import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.BrowserContext;
import com.teamdev.jxbrowser.chromium.BrowserContextParams;
import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.BrowserType;
import com.teamdev.jxbrowser.chromium.CustomProxyConfig;
import com.teamdev.jxbrowser.chromium.DirectProxyConfig;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.NetworkDelegate;
import com.teamdev.jxbrowser.chromium.internal.ChromiumBuild;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPC;
import java.io.File;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import jxbrowser.impl.JxBrowser;
import jxbrowser.impl.JxBrowserCreationCallback;
import jxbrowser.util.BrowserNotInitializedException;
import jxbrowser.util.ProxyConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JxBrowserUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JxBrowserUtils.class);
    private static final Object BROWSER_CONTEXT_SYNC = new Object();
    private static final Set<JxBrowser> browsers = new HashSet<JxBrowser>();
    private static volatile BrowserContext browserContext = null;
    private static String dataDirPath = null;
    private static boolean tryAgain = true;
    private static ProxyConfig currentProxyConfig;

    public static void createBrowser(JxBrowserCreationCallback callBack) {
        BrowserCreator creator = new BrowserCreator(callBack);
        creator.start();
    }

    public static JxBrowser createBrowser() {
        try {
            return BrowserCreator.create();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerBrowser(JxBrowser browser) {
        Set<JxBrowser> set = browsers;
        synchronized (set) {
            boolean added = browsers.add(browser);
            assert (added) : "Browser already added";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterBrowser(JxBrowser browser) {
        Set<JxBrowser> set = browsers;
        synchronized (set) {
            boolean removed = browsers.remove(browser);
            assert (removed) : "Browser already removed";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutDownAll() {
        Set<JxBrowser> set = browsers;
        synchronized (set) {
            new HashSet<JxBrowser>(browsers).stream().filter(Objects::nonNull).forEach(JxBrowser::dispose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initialize(File applicationDir, ProxyConfig proxyConfig) {
        Object object = BROWSER_CONTEXT_SYNC;
        synchronized (object) {
            assert (browserContext == null) : "Already initialized";
            currentProxyConfig = proxyConfig;
            BrowserPreferences.setChromiumSwitches((String[])new String[]{"--automation-reinitialize-on-channel-error", "--no-default-browser-check", "--disable-web-security", "--no-experiments", "--allow-cross-origin-auth-prompt", "--allow-file-access-from-files", "--disable-gpu", "--ignore-certificate-errors"});
            String browserPath = applicationDir.getAbsolutePath() + File.separator + "jxbrowser-chromium-" + ChromiumBuild.version();
            System.setProperty("jxbrowser.chromium.dir", browserPath);
            System.setProperty("jxbrowser.ipc.external", "true");
            dataDirPath = browserPath + File.separator + "data";
            IPC.getDefault().start();
            browserContext = JxBrowserUtils.createBrowserContext(dataDirPath, proxyConfig);
            LOG.info("Browser dir {}", (Object)browserPath);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateProxyConfiguration(ProxyConfig proxyConfig) {
        Object object = BROWSER_CONTEXT_SYNC;
        synchronized (object) {
            if (currentProxyConfig == null || !currentProxyConfig.equals(proxyConfig)) {
                currentProxyConfig = proxyConfig;
                browserContext = JxBrowserUtils.createBrowserContext(dataDirPath, proxyConfig);
            }
        }
    }

    private static BrowserContext createBrowserContext(String dataDirPath, ProxyConfig proxyConfig) {
        BrowserContextParams browserContextParams = new BrowserContextParams(dataDirPath);
        JxBrowserUtils.initProxyConfig(browserContextParams, proxyConfig);
        BrowserContext browserContext = new BrowserContext(browserContextParams);
        JxBrowserUtils.initProxyAuthConfig(browserContext, proxyConfig);
        return browserContext;
    }

    private static void initProxyConfig(BrowserContextParams browserContextParams, ProxyConfig proxyConfig) {
        if (proxyConfig.isUseProxy()) {
            browserContextParams.setProxyConfig(new CustomProxyConfig(JxBrowserUtils.buildProxiesStr(proxyConfig.getProxyHost(), proxyConfig.getProxyPort()), "<local>"));
        } else {
            browserContextParams.setProxyConfig(new DirectProxyConfig());
        }
    }

    private static void initProxyAuthConfig(BrowserContext browserContext, final ProxyConfig proxyConfig) {
        if (proxyConfig.isUseProxyAuth()) {
            browserContext.getNetworkService().setNetworkDelegate((NetworkDelegate)new JxBrowser.SilentNetworkDelegate(){

                @Override
                public boolean onAuthRequired(AuthRequiredParams params) {
                    if (params.isProxy()) {
                        params.setUsername(proxyConfig.getUserName());
                        params.setPassword(proxyConfig.getPassword());
                        return false;
                    }
                    return true;
                }
            });
        } else {
            browserContext.getNetworkService().setNetworkDelegate((NetworkDelegate)new JxBrowser.SilentNetworkDelegate());
        }
    }

    private static String buildProxiesStr(String proxyHost, int proxyPort) {
        String proxy = proxyHost + ":" + proxyPort;
        return "http=" + proxy + ";" + "https=" + proxy + ";" + "ftp=" + proxy + ";" + "socks=" + proxy;
    }

    static {
        String logLevelProperty = System.getProperty("browserLogLevel");
        Level logLevel = logLevelProperty != null ? Level.parse(logLevelProperty) : Level.WARNING;
        LoggerProvider.getBrowserLogger().setLevel(logLevel);
        LoggerProvider.getIPCLogger().setLevel(logLevel);
        LoggerProvider.getChromiumProcessLogger().setLevel(logLevel);
    }

    private static class BrowserCreator
    extends Thread {
        private JxBrowserCreationCallback callBack;

        BrowserCreator(JxBrowserCreationCallback callBack) {
            this.callBack = callBack;
        }

        @Override
        public void run() {
            block6: {
                try {
                    JxBrowser jxBrowser = BrowserCreator.create();
                    if (this.callBack != null) {
                        this.callBack.browserCreated(jxBrowser);
                    }
                }
                finally {
                    Throwable e;
                    LOG.error("", e);
                    if (this.callBack == null) break block6;
                    try {
                        this.callBack.browserCreationFailed(e);
                    }
                    catch (Exception e1) {
                        LOG.error("", e);
                    }
                }
            }
        }

        private static JxBrowser create() throws Throwable {
            Object object = BROWSER_CONTEXT_SYNC;
            synchronized (object) {
                if (browserContext == null) {
                    throw new BrowserNotInitializedException();
                }
                try {
                    Browser browser = new Browser(BrowserType.LIGHTWEIGHT, browserContext);
                    browser.setPreferences(BrowserCreator.createBrowserPreferences());
                    return new JxBrowser(browser);
                }
                catch (Throwable e) {
                    if (tryAgain) {
                        tryAgain = false;
                        return BrowserCreator.create();
                    }
                    throw e;
                }
            }
        }

        private static BrowserPreferences createBrowserPreferences() {
            BrowserPreferences browserPreferences = new BrowserPreferences();
            browserPreferences.setDefaultEncoding("UTF-8");
            browserPreferences.setJavaScriptEnabled(true);
            browserPreferences.setJavaScriptCanOpenWindowsAutomatically(true);
            browserPreferences.setLoadsImagesAutomatically(true);
            browserPreferences.setImagesEnabled(true);
            browserPreferences.setPluginsEnabled(true);
            browserPreferences.setLocalStorageEnabled(true);
            browserPreferences.setDatabasesEnabled(true);
            browserPreferences.setWebAudioEnabled(true);
            browserPreferences.setApplicationCacheEnabled(true);
            browserPreferences.setAllowDisplayingInsecureContent(true);
            browserPreferences.setUnifiedTextcheckerEnabled(true);
            return browserPreferences;
        }
    }
}

