/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.socialmedia.io.messagefinder.youtube;

import com.agilemind.commons.util.StringUtil;
import com.agilemind.socialmedia.io.data.enums.MessageType;
import com.agilemind.socialmedia.io.data.enums.ReplyStatus;
import com.agilemind.socialmedia.io.data.enums.ServiceType;
import com.agilemind.socialmedia.io.data.enums.StreamType;
import com.agilemind.socialmedia.io.data.reach.ReachType;
import com.agilemind.socialmedia.io.data.reach.metric.YoutubeRMetric;
import com.agilemind.socialmedia.io.messagefinder.MessageResult;
import com.google.api.client.util.ArrayMap;
import com.google.api.services.youtube.model.Channel;
import com.google.api.services.youtube.model.ChannelSnippet;
import com.google.api.services.youtube.model.Comment;
import com.google.api.services.youtube.model.CommentSnippet;
import com.google.api.services.youtube.model.CommentThread;
import com.google.api.services.youtube.model.CommentThreadReplies;
import com.google.api.services.youtube.model.CommentThreadSnippet;
import com.google.api.services.youtube.model.ThumbnailDetails;
import com.google.api.services.youtube.model.Video;
import com.google.api.services.youtube.model.VideoContentDetails;
import com.google.api.services.youtube.model.VideoSnippet;
import com.google.api.services.youtube.model.VideoStatistics;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class YoutubeParser {
    public static int b;
    private static final String[] a;

    public static MessageResult parseVideo(Video video, Channel channel, StreamType streamType) throws IOException {
        return YoutubeParser.parseVideo(video, channel, streamType, null);
    }

    public static MessageResult parseVideo(Video video, Channel channel, StreamType streamType, String string) throws IOException {
        int n2 = b;
        String string2 = video.getId();
        String string3 = YoutubeParser.a(string2);
        VideoSnippet videoSnippet = video.getSnippet();
        MessageResult messageResult = new MessageResult(string3, new Date(videoSnippet.getPublishedAt().getValue()));
        messageResult.setFirstMessageOfContainer(true);
        messageResult.setText(StringUtil.getStringOrEmpty((String)videoSnippet.getDescription()));
        messageResult.setContainerText(StringUtil.getStringOrEmpty((String)videoSnippet.getTitle()));
        messageResult.setId(string2);
        messageResult.setContainerUrl(string3);
        ChannelSnippet channelSnippet = channel.getSnippet();
        messageResult.setAuthor(channelSnippet.getTitle());
        messageResult.setAvatarUrl(channelSnippet.getThumbnails().getDefault().getUrl());
        messageResult.setAccountId(videoSnippet.getChannelId());
        messageResult.setRecipientAccountId(string);
        VideoContentDetails videoContentDetails = video.getContentDetails();
        String string4 = videoContentDetails.getDuration();
        messageResult.putAdditionalParameter(a[7], String.valueOf(YoutubeParser.b(string4.substring(2))));
        ThumbnailDetails thumbnailDetails = videoSnippet.getThumbnails();
        messageResult.putAdditionalParameter(a[5], thumbnailDetails.getDefault().getUrl());
        messageResult.putAdditionalParameter(a[6], string2);
        messageResult.putAdditionalParameter(a[3], ReachType.YT_VIDEO.getKey());
        messageResult.setReplyStatus(ReplyStatus.OPEN);
        messageResult.setServiceType(ServiceType.YOU_TUBE);
        messageResult.setMessageType(MessageType.YOUTUBE_VIDEO);
        messageResult.setStreamType(streamType);
        VideoStatistics videoStatistics = video.getStatistics();
        if (videoStatistics != null) {
            BigInteger bigInteger = videoStatistics.getViewCount();
            if (bigInteger != null) {
                messageResult.putAdditionalParameter(a[4], String.valueOf(bigInteger));
            }
            BigInteger bigInteger2 = videoStatistics.getLikeCount();
            if (bigInteger2 != null) {
                messageResult.putAdditionalParameter(YoutubeRMetric.LIKES.getKey(), String.valueOf(bigInteger2));
            }
            BigInteger bigInteger3 = videoStatistics.getDislikeCount();
            if (bigInteger3 != null) {
                messageResult.putAdditionalParameter(YoutubeRMetric.DISLIKES.getKey(), String.valueOf(bigInteger3));
            }
            BigInteger bigInteger4 = videoStatistics.getCommentCount();
            if (bigInteger4 != null) {
                messageResult.putAdditionalParameter(YoutubeRMetric.COMMENTS.getKey(), String.valueOf(bigInteger4));
            }
        }
        if (n2 != 0) {
            int n3 = MessageResult.y;
            MessageResult.y = ++n3;
        }
        return messageResult;
    }

    public static List<MessageResult> parseCommentThread(CommentThread commentThread, StreamType streamType) {
        int n2 = b;
        ArrayList<MessageResult> arrayList = new ArrayList<MessageResult>();
        CommentThreadSnippet commentThreadSnippet = commentThread.getSnippet();
        String string = commentThreadSnippet.getVideoId();
        MessageResult messageResult = YoutubeParser.parseComment(commentThreadSnippet.getTopLevelComment(), string, streamType);
        if (messageResult != null) {
            arrayList.add(messageResult);
        }
        CommentThreadReplies commentThreadReplies = commentThread.getReplies();
        if (commentThreadReplies == null) {
            return arrayList;
        }
        for (Comment comment : commentThreadReplies.getComments()) {
            MessageResult messageResult2 = YoutubeParser.parseComment(comment, string, streamType);
            if (messageResult2 != null) {
                arrayList.add(messageResult2);
            }
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    public static MessageResult parseComment(Comment comment, String string, StreamType streamType) {
        return YoutubeParser.parseComment(comment, null, string, streamType);
    }

    public static MessageResult parseComment(Comment comment, String string, String string2, StreamType streamType) {
        Object object;
        String string3;
        MessageResult messageResult;
        CommentSnippet commentSnippet;
        block10: {
            commentSnippet = comment.getSnippet();
            String string4 = comment.getId();
            String string5 = YoutubeParser.a(string2, string4);
            messageResult = new MessageResult(string5, new Date(commentSnippet.getPublishedAt().getValue()));
            messageResult.setId(string4);
            messageResult.setContainerUrl(YoutubeParser.a(string2));
            String string6 = commentSnippet.getTextOriginal();
            if (string6 == null) {
                string6 = commentSnippet.getTextDisplay();
            }
            messageResult.setText(StringUtil.getStringOrEmpty((String)string6));
            messageResult.setContainerText(StringUtil.getStringOrEmpty((String)string6));
            string3 = string;
            if (string3 == null) {
                object = (ArrayMap)commentSnippet.getAuthorChannelId();
                if (object == null || object.isEmpty()) break block10;
                string3 = (String)object.get((Object)0);
            }
        }
        if (string3 == null) {
            return null;
        }
        messageResult.setAccountId(string3);
        messageResult.setAvatarUrl(commentSnippet.getAuthorProfileImageUrl());
        messageResult.setAuthor(commentSnippet.getAuthorDisplayName());
        messageResult.putAdditionalParameter(a[2], string2);
        object = commentSnippet.getParentId();
        if (object != null) {
            messageResult.putAdditionalParameter(a[1], (String)object);
        }
        messageResult.setReplyStatus(ReplyStatus.OPEN);
        messageResult.setServiceType(ServiceType.YOU_TUBE);
        messageResult.setMessageType(MessageType.YOUTUBE_COMMENT);
        messageResult.setStreamType(streamType);
        return messageResult;
    }

    private static String a(String string) {
        return a[0] + string;
    }

    private static String a(String string, String string2) {
        return YoutubeParser.a(string) + "_" + string2;
    }

    private static int b(String string) throws IllegalArgumentException {
        int n2;
        block23: {
            block22: {
                if (string.length() != 0 && !string.contains("-")) break block22;
                throw new IllegalArgumentException();
            }
            if (string.endsWith("H") || string.endsWith("M")) break block23;
            if (string.endsWith("S")) break block23;
            throw new IllegalArgumentException();
        }
        int n3 = 0;
        int n4 = string.indexOf("H");
        if (n3 == n4) {
            throw new IllegalArgumentException();
        }
        int n5 = 0;
        if (n4 != -1) {
            n2 = Integer.parseInt(string.substring(0, n4));
            n5 += n2 * 3600;
            n3 = n4 + 1;
        }
        n4 = string.indexOf("M");
        if (n3 == n4) {
            throw new IllegalArgumentException();
        }
        if (n4 != -1) {
            n2 = Integer.parseInt(string.substring(n3, n4));
            n5 += n2 * 60;
            n3 = n4 + 1;
        }
        n4 = string.indexOf("S");
        if (n3 == n4) {
            throw new IllegalArgumentException();
        }
        if (n4 != -1) {
            n2 = Math.round(Integer.parseInt(string.substring(n3, n4)) * 100) / 100;
            n5 += n2;
        }
        return n5;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "3A\u001ekwa\u001aEls,\u001b\u0013tq/@\b~*8Z\u00074s:A\ts;-\b";
        int n3 = -1;
        block15: while (true) {
            char[] cArray;
            block20: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block19: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block19;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block20;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 91;
                                break;
                            }
                            case 1: {
                                n9 = 53;
                                break;
                            }
                            case 2: {
                                n9 = 106;
                                break;
                            }
                            case 3: {
                                n9 = 27;
                                break;
                            }
                            default: {
                                n9 = 4;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u000bt8^J\u000fj#_";
                    n3 = 0;
                    continue block15;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "-\\\u000e~k\u0012Q";
                    n3 = 1;
                    continue block15;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\tp+XL\u0004a3KA";
                    n3 = 2;
                    continue block15;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\r|/L[\u0018z?UP";
                    n3 = 3;
                    continue block15;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "/]\u001fvf5T\u0003w";
                    n3 = 4;
                    continue block15;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "-\\\u000e~k\u0012Q";
                    n3 = 5;
                    continue block15;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u001f`8ZP\u0012z$";
                    n3 = 6;
                    continue block15;
                }
                case 6: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        a = stringArray3;
    }
}

