/*
 * Decompiled with CFR 0.152.
 */
package com.belprime.di.pr.client.impl;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

class ConnectionManager {
    private static final String API_KEY_HEADER = "X-Api-Key";
    private final URL serverAddress;
    private final String apiKey;
    private final int connectTimeout;
    private final int readTimeout;

    ConnectionManager(URL serverAddress, String apiKey, int connectTimeout, int readTimeout) {
        this.serverAddress = serverAddress;
        this.apiKey = apiKey;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public HttpURLConnection getConnection(String endPoint) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(this.serverAddress, endPoint).openConnection();
        connection.setUseCaches(false);
        connection.setRequestMethod("POST");
        connection.setConnectTimeout(this.connectTimeout);
        connection.setReadTimeout(this.readTimeout);
        if (this.apiKey != null) {
            connection.setRequestProperty(API_KEY_HEADER, this.apiKey);
        }
        return connection;
    }
}

