/*
 * Decompiled with CFR 0.152.
 */
package com.belprime.di.pr.client.impl;

import com.belprime.di.pr.client.api.DomainRanksResponse;
import com.belprime.di.pr.client.api.InternationalizedUrl;
import com.belprime.di.pr.client.api.InvalidUrlException;
import com.belprime.di.pr.client.api.Rank;
import com.belprime.di.pr.client.impl.DomainRankService;
import com.belprime.di.pr.client.impl.DomainRankSettings;
import com.belprime.di.pr.client.impl.VersionMismatchException;
import com.belprime.pr.server.api.domainrank.DomainRanksRequest;
import com.belprime.pr.server.api.domainrank.GenerationSettings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import prclient.hidden.com.belprime.di.common.format.UrlNormalizer;
import prclient.hidden.com.belprime.di.domainrank.pldindex.DRPldExtractor;
import prclient.hidden.com.belprime.url.pld.PldExtractor;
import prclient.hidden.com.belprime.url.pld.PublicSuffixesDictionaryLoader;

class DomainRankDelegate {
    private static final int MAX_ATTEMPTS = 2;
    private final DomainRankService service;
    private volatile DomainRankSettings settings;

    DomainRankDelegate(DomainRankService service) {
        this.service = Objects.requireNonNull(service);
    }

    public DomainRanksResponse findRanks(com.belprime.di.pr.client.api.DomainRanksRequest request) throws IOException, InvalidUrlException {
        for (int i = 0; i < 2; ++i) {
            DomainRankSettings settings = this.getSettings();
            List<String> domains = this.getPlds(settings.getPldExtractor(), request.getUrls());
            try {
                List<Rank> ranks = this.retrieveRanks(domains, settings.getGeneration());
                return new DomainRanksResponse(Collections.unmodifiableList(ranks));
            }
            catch (VersionMismatchException e) {
                this.settings = null;
                continue;
            }
        }
        throw new IOException("Failed to retrieve page ranks after performing 2 attempts");
    }

    public boolean isValid(InternationalizedUrl url) throws IOException {
        return this.getPld(this.getSettings().getPldExtractor(), url) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DomainRankSettings getSettings() throws IOException {
        DomainRankSettings result = this.settings;
        if (result == null) {
            DomainRankDelegate domainRankDelegate = this;
            synchronized (domainRankDelegate) {
                result = this.settings;
                if (result == null) {
                    GenerationSettings generationSettings = this.service.retrieveSettings();
                    PldExtractor pldExtractor = this.createPldExtractor(generationSettings.getPublicSuffixList());
                    this.settings = result = new DomainRankSettings(generationSettings.getGenerationId(), pldExtractor);
                }
            }
        }
        return result;
    }

    private PldExtractor createPldExtractor(byte[] publicSuffixList) throws IOException {
        PublicSuffixesDictionaryLoader loader = new PublicSuffixesDictionaryLoader(new ByteArrayInputStream(publicSuffixList));
        return new DRPldExtractor(loader.load().getAllDomains());
    }

    private List<Rank> retrieveRanks(List<String> domains, int generation) throws IOException {
        ArrayList<String> uniqueDomains = new ArrayList<String>(new HashSet<String>(domains));
        byte[][] domainIds = (byte[][])uniqueDomains.stream().map(domain -> domain.getBytes(StandardCharsets.UTF_8)).toArray(x$0 -> new byte[x$0][]);
        DomainRanksRequest request = new DomainRanksRequest();
        request.setDomainIds(domainIds);
        byte[] ranks = this.service.retrieveRanks(request, generation).getRanks();
        Map<String, Rank> rankMap = this.arrangeCorresponding(uniqueDomains, ranks);
        return domains.stream().map(rankMap::get).collect(Collectors.toList());
    }

    private Map<String, Rank> arrangeCorresponding(List<String> domains, byte[] ranks) {
        assert (domains.size() == ranks.length);
        HashMap<String, Rank> result = new HashMap<String, Rank>();
        for (int i = 0; i < ranks.length; ++i) {
            result.put(domains.get(i), new Rank(ranks[i]));
        }
        return result;
    }

    private List<String> getPlds(PldExtractor pldExtractor, List<InternationalizedUrl> urls) throws InvalidUrlException {
        ArrayList<String> plds = new ArrayList<String>(urls.size());
        for (InternationalizedUrl raw : urls) {
            String domain = this.getPld(pldExtractor, raw);
            if (domain == null) {
                throw new InvalidUrlException("Failed to extract domain from url " + raw.getUrl() + " using charset " + raw.getCharset(), raw.getUrl());
            }
            plds.add(UrlNormalizer.reverseDomain(domain));
        }
        return plds;
    }

    private String getPld(PldExtractor pldExtractor, InternationalizedUrl raw) {
        String normalized = UrlNormalizer.normalize(raw.getUrl(), raw.getCharset().name());
        return normalized == null ? null : pldExtractor.getPld(UrlNormalizer.getDomain(normalized));
    }
}

