/*
 * Decompiled with CFR 0.152.
 */
package com.belprime.di.pr.client.impl;

import com.belprime.di.pr.client.impl.ConnectionManager;
import com.belprime.di.pr.client.impl.ResponseErrorHandler;
import com.belprime.pr.server.api.domainrank.DomainRanksRequest;
import com.belprime.pr.server.api.domainrank.DomainRanksResponse;
import com.belprime.pr.server.api.domainrank.GenerationSettings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

class DomainRankService {
    private static final String GENERATION_PARAMETER_NAME = "generation";
    private final ConnectionManager connectionManager;
    private final String protocolVersion;

    DomainRankService(ConnectionManager connectionManager, String protocolVersion) {
        this.connectionManager = Objects.requireNonNull(connectionManager);
        this.protocolVersion = Objects.requireNonNull(protocolVersion);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GenerationSettings retrieveSettings() throws IOException {
        HttpURLConnection connection = this.connectionManager.getConnection(this.getSettingsEndpoint());
        connection.connect();
        try (ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(connection.getInputStream()));){
            GenerationSettings generationSettings = (GenerationSettings)in.readObject();
            return generationSettings;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        catch (IOException e) {
            ResponseErrorHandler.handle(e, connection);
            throw new AssertionError();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DomainRanksResponse retrieveRanks(DomainRanksRequest request, int generation) throws IOException {
        Throwable throwable;
        HttpURLConnection connection = this.connectionManager.getConnection(this.getSearchEndpoint(generation));
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        connection.connect();
        try {
            throwable = null;
            try (ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(connection.getOutputStream()));){
                out.writeObject(request);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            ResponseErrorHandler.handle(e, connection);
        }
        try {
            throwable = null;
            try (ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(connection.getInputStream()));){
                DomainRanksResponse domainRanksResponse = (DomainRanksResponse)in.readObject();
                return domainRanksResponse;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        catch (IOException e) {
            ResponseErrorHandler.handle(e, connection);
            throw new AssertionError();
        }
    }

    private String getSettingsEndpoint() {
        return "dr/" + this.protocolVersion + "/settings";
    }

    private String getSearchEndpoint(int generation) {
        return "dr/" + this.protocolVersion + "/find?" + GENERATION_PARAMETER_NAME + "=" + generation;
    }
}

