/*
 * Decompiled with CFR 0.152.
 */
package com.belprime.di.pr.client.impl;

import com.belprime.di.pr.client.api.DomainRanksRequest;
import com.belprime.di.pr.client.api.DomainRanksResponse;
import com.belprime.di.pr.client.api.InternationalizedUrl;
import com.belprime.di.pr.client.api.InvalidUrlException;
import com.belprime.di.pr.client.api.PRClient;
import com.belprime.di.pr.client.api.RanksRequest;
import com.belprime.di.pr.client.api.RanksResponse;
import com.belprime.di.pr.client.impl.ConnectionManager;
import com.belprime.di.pr.client.impl.DomainRankDelegate;
import com.belprime.di.pr.client.impl.DomainRankService;
import com.belprime.di.pr.client.impl.PageRankDelegate;
import com.belprime.di.pr.client.impl.PageRankService;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public class PRClientImpl
implements PRClient {
    private static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    private static final int DEFAULT_READ_TIMEOUT = 20000;
    private static final String DOMAIN_RANK_PROTOCOL_VERSION_PROPERTY = "domainRank.protocol.version";
    private final PageRankDelegate pageRankDelegate;
    private final DomainRankDelegate domainRankDelegate;

    public PRClientImpl(String serverAddress) {
        this(serverAddress, null);
    }

    public PRClientImpl(String serverAddress, String apiKey) {
        this(serverAddress, apiKey, 10000, 20000);
    }

    public PRClientImpl(String serverAddress, String apiKey, int connectTimeout, int readTimeout) {
        Properties appProperties = this.readAppProperties();
        ConnectionManager connectionManager = new ConnectionManager(this.getURL(serverAddress), apiKey, connectTimeout, readTimeout);
        this.pageRankDelegate = new PageRankDelegate(new PageRankService(connectionManager));
        this.domainRankDelegate = new DomainRankDelegate(new DomainRankService(connectionManager, appProperties.getProperty(DOMAIN_RANK_PROTOCOL_VERSION_PROPERTY)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties readAppProperties() {
        try (InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream("app.properties"), StandardCharsets.UTF_8);){
            Properties properties = new Properties();
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load app.properties", e);
        }
    }

    private URL getURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public RanksResponse findRanks(RanksRequest request) throws IOException, InvalidUrlException {
        return this.pageRankDelegate.findRanks(request);
    }

    @Override
    public boolean isValidForPageRank(InternationalizedUrl url) throws IOException {
        return this.pageRankDelegate.isValid(url);
    }

    @Override
    public DomainRanksResponse findRanks(DomainRanksRequest request) throws IOException, InvalidUrlException {
        return this.domainRankDelegate.findRanks(request);
    }

    @Override
    public boolean isValidForDomainRank(InternationalizedUrl url) throws IOException {
        return this.domainRankDelegate.isValid(url);
    }
}

