/*
 * Decompiled with CFR 0.152.
 */
package com.belprime.di.pr.client.impl;

import com.belprime.di.pr.client.api.InternationalizedUrl;
import com.belprime.di.pr.client.api.InvalidUrlException;
import com.belprime.di.pr.client.api.Rank;
import com.belprime.di.pr.client.api.RanksRequest;
import com.belprime.di.pr.client.api.RanksResponse;
import com.belprime.di.pr.client.impl.PageRankService;
import com.belprime.di.pr.client.impl.PageRankSettings;
import com.belprime.di.pr.client.impl.VersionMismatchException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import prclient.hidden.com.belprime.di.common.format.DomainAndFullUrlHasher;
import prclient.hidden.com.belprime.di.common.format.UrlNormalizer;

class PageRankDelegate {
    private static final int MAX_ATTEMPTS = 2;
    private final PageRankService service;
    private volatile PageRankSettings settings;

    PageRankDelegate(PageRankService service) {
        this.service = Objects.requireNonNull(service);
    }

    public RanksResponse findRanks(RanksRequest request) throws IOException, InvalidUrlException {
        List<String> normalizedUrls = this.normalize(request.getUrls());
        for (int i = 0; i < 2; ++i) {
            try {
                List<Rank> ranks = this.retrieveRanks(normalizedUrls);
                return new RanksResponse(Collections.unmodifiableList(ranks));
            }
            catch (VersionMismatchException e) {
                this.settings = null;
                continue;
            }
        }
        throw new IOException("Failed to retrieve page ranks after performing 2 attempts");
    }

    public boolean isValid(InternationalizedUrl url) throws IOException {
        return this.getNormalized(url) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PageRankSettings getSettings() throws IOException {
        PageRankSettings result = this.settings;
        if (result == null) {
            PageRankDelegate pageRankDelegate = this;
            synchronized (pageRankDelegate) {
                result = this.settings;
                if (result == null) {
                    this.settings = result = this.service.retrieveSettings();
                }
            }
        }
        return result;
    }

    private List<String> normalize(List<InternationalizedUrl> urls) throws InvalidUrlException {
        ArrayList<String> result = new ArrayList<String>(urls.size());
        for (InternationalizedUrl raw : urls) {
            String normalizedUrl = this.getNormalized(raw);
            if (normalizedUrl == null) {
                throw new InvalidUrlException("Failed to normalize url " + raw.getUrl() + " using charset " + raw.getCharset(), raw.getUrl());
            }
            result.add(normalizedUrl);
        }
        return result;
    }

    private String getNormalized(InternationalizedUrl raw) {
        String normalizedUrl = UrlNormalizer.normalizeAndTransform(raw.getUrl(), raw.getCharset().name());
        if (normalizedUrl != null) {
            normalizedUrl = UrlNormalizer.normalizePageId(normalizedUrl);
        }
        return normalizedUrl;
    }

    private List<Rank> retrieveRanks(List<String> normalizedUrls) throws IOException {
        PageRankSettings settings = this.getSettings();
        DomainAndFullUrlHasher hasher = new DomainAndFullUrlHasher(settings.getTotalHashLength(), settings.getDomainPartBytes());
        List<byte[]> ids = this.resolveIds(normalizedUrls, hasher);
        int[] pageRanks = this.service.retrieveRanks(ids, hasher.hashSize(), settings.getVersion());
        return Arrays.stream(pageRanks).mapToObj(Rank::new).collect(Collectors.toList());
    }

    private List<byte[]> resolveIds(List<String> urls, DomainAndFullUrlHasher hasher) {
        return urls.stream().map(hasher::hash).collect(Collectors.toList());
    }
}

