/*
 * Decompiled with CFR 0.152.
 */
package com.belprime.di.pr.client.impl;

import com.belprime.di.pr.client.impl.ConnectionManager;
import com.belprime.di.pr.client.impl.PageRankSettings;
import com.belprime.di.pr.client.impl.ResponseErrorHandler;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

class PageRankService {
    private static final String SEARCH_ENDPOINT = "pr/find";
    private static final String SETTINGS_ENDPOINT = "pr/settings";
    private static final String VERSION_PARAMETER_NAME = "version";
    private static final String TOTAL_HASH_LENGTH_PARAMETER_NAME = "totalHashLength";
    private static final String DOMAIN_PART_BYTES_PARAMETER_NAME = "domainPartBytes";
    private final ConnectionManager connectionManager;

    PageRankService(ConnectionManager connectionManager) {
        this.connectionManager = Objects.requireNonNull(connectionManager);
    }

    public PageRankSettings retrieveSettings() throws IOException {
        HttpURLConnection connection = this.connectionManager.getConnection(SETTINGS_ENDPOINT);
        connection.connect();
        Properties properties = new Properties();
        try (InputStreamReader reader = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);){
            properties.load(reader);
        }
        catch (IOException e) {
            ResponseErrorHandler.handle(e, connection);
        }
        return new PageRankSettings(Integer.parseInt(properties.getProperty(VERSION_PARAMETER_NAME)), Integer.parseInt(properties.getProperty(TOTAL_HASH_LENGTH_PARAMETER_NAME)), Integer.parseInt(properties.getProperty(DOMAIN_PART_BYTES_PARAMETER_NAME)));
    }

    public int[] retrieveRanks(List<byte[]> hashes, int hashSize, int version) throws IOException {
        HttpURLConnection connection = this.connectionManager.getConnection(this.getSearchEndpoint(version));
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        connection.setFixedLengthStreamingMode((long)hashes.size() * (long)hashSize);
        connection.connect();
        this.writeHashes(connection, hashes);
        int[] result = new int[hashes.size()];
        this.readIntRanks(connection, result);
        return result;
    }

    private void writeHashes(HttpURLConnection connection, List<byte[]> hashes) throws IOException {
        try (OutputStream out = connection.getOutputStream();){
            for (byte[] hash : hashes) {
                out.write(hash);
            }
            out.flush();
        }
        catch (IOException e) {
            ResponseErrorHandler.handle(e, connection);
        }
    }

    private void readIntRanks(HttpURLConnection connection, int[] target) throws IOException {
        try (DataInputStream in = new DataInputStream(connection.getInputStream());){
            for (int i = 0; i < target.length; ++i) {
                target[i] = in.readShort();
            }
        }
        catch (IOException e) {
            ResponseErrorHandler.handle(e, connection);
        }
    }

    private String getSearchEndpoint(int version) throws MalformedURLException {
        return "pr/find?version=" + version;
    }
}

