/*
 * Decompiled with CFR 0.152.
 */
package com.belprime.di.pr.client.impl;

import com.belprime.di.pr.client.api.InvalidApiKeyException;
import com.belprime.di.pr.client.api.RateLimitExceededException;
import com.belprime.di.pr.client.impl.VersionMismatchException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;

class ResponseErrorHandler {
    private static final String VERSION_MISMATCH_MESSAGE = "versionMismatch";

    public static void handle(IOException e, HttpURLConnection connection) throws IOException {
        String errorMessage = ResponseErrorHandler.getErrorMessage(connection);
        int responseCode = connection.getResponseCode();
        if (responseCode == 401) {
            throw new InvalidApiKeyException(e);
        }
        if (responseCode == 429) {
            throw new RateLimitExceededException(e);
        }
        if (responseCode == 400 && VERSION_MISMATCH_MESSAGE.equals(errorMessage)) {
            throw new VersionMismatchException(e);
        }
        throw e;
    }

    private static String getErrorMessage(HttpURLConnection connection) {
        InputStream errorStream = connection.getErrorStream();
        if (errorStream == null) {
            return null;
        }
        try (Scanner scanner = new Scanner(errorStream, StandardCharsets.UTF_8.name()).useDelimiter("\\A");){
            String string = scanner.hasNext() ? scanner.next() : null;
            return string;
        }
    }

    private ResponseErrorHandler() {
    }
}

