/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.publicSuffixList;

import de.malkusch.whoisServerList.publicSuffixList.index.Index;
import de.malkusch.whoisServerList.publicSuffixList.rule.Rule;
import de.malkusch.whoisServerList.publicSuffixList.util.DomainUtil;
import de.malkusch.whoisServerList.publicSuffixList.util.PunycodeAutoDecoder;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import prclient.hidden.org.apache.commons.lang3.StringUtils;

@Immutable
public final class PublicSuffixList {
    private final URL url;
    private final Charset charset;
    private final Index index;

    PublicSuffixList(Index index, URL url, Charset charset) {
        this.index = index;
        this.url = url;
        this.charset = charset;
    }

    public String getRegistrableDomain(String domain) {
        String suffix;
        if (StringUtils.isEmpty(domain)) {
            return null;
        }
        if (domain.charAt(0) == '.') {
            return null;
        }
        PunycodeAutoDecoder punycode = new PunycodeAutoDecoder();
        String decodedDomain = punycode.decode(domain);
        if (StringUtils.equals(decodedDomain, suffix = this.getPublicSuffix(decodedDomain))) {
            return null;
        }
        String[] suffixLabels = DomainUtil.splitLabels(suffix);
        if (suffixLabels == null) {
            return null;
        }
        String[] labels = DomainUtil.splitLabels(decodedDomain);
        int offset = labels.length - suffixLabels.length - 1;
        String registrableDomain = DomainUtil.joinLabels(Arrays.copyOfRange(labels, offset, labels.length));
        return punycode.recode(registrableDomain);
    }

    public boolean isRegistrable(String domain) {
        if (domain == null) {
            throw new IllegalArgumentException("The domain must not be null");
        }
        return domain.equals(this.getRegistrableDomain(domain));
    }

    public String getPublicSuffix(String domain) {
        if (StringUtils.isEmpty(domain)) {
            return null;
        }
        PunycodeAutoDecoder punycode = new PunycodeAutoDecoder();
        String decodedDomain = punycode.recode(domain);
        Rule rule = this.index.findRule(decodedDomain);
        if (rule == null) {
            return null;
        }
        return punycode.decode(rule.match(decodedDomain));
    }

    public boolean isPublicSuffix(String domain) {
        if (domain == null) {
            throw new IllegalArgumentException("The domain must not be null");
        }
        return domain.equals(this.getPublicSuffix(domain));
    }

    public Charset getCharset() {
        return this.charset;
    }

    public URL getURL() {
        return this.url;
    }

    public List<Rule> getRules() {
        return this.index.getRules();
    }
}

