/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.publicSuffixList;

import de.malkusch.whoisServerList.publicSuffixList.PublicSuffixList;
import de.malkusch.whoisServerList.publicSuffixList.index.Index;
import de.malkusch.whoisServerList.publicSuffixList.index.IndexFactory;
import de.malkusch.whoisServerList.publicSuffixList.parser.Parser;
import de.malkusch.whoisServerList.publicSuffixList.rule.Rule;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PublicSuffixListFactory {
    public static final String PROPERTY_URL = "psl.url";
    public static final String PROPERTY_CHARSET = "psl.charset";
    public static final String PROPERTY_LIST_FILE = "psl.file";
    @Deprecated
    public static final String PROPERTY_INDEX = "psl.index";
    public static final String PROPERTY_INDEX_FACTORY = "psl.indexFactory";
    public static final String PROPERTY_FILE = "/psl.properties";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties getDefaults() {
        try (InputStream stream = this.getClass().getResourceAsStream(PROPERTY_FILE);){
            Properties properties = new Properties();
            properties.load(stream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PublicSuffixList build(Properties properties) throws IOException, ClassNotFoundException {
        String propertyFile = properties.getProperty(PROPERTY_LIST_FILE);
        try (InputStream listStream = this.getClass().getResourceAsStream(propertyFile);){
            PublicSuffixList publicSuffixList = this.build(listStream, properties);
            return publicSuffixList;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public PublicSuffixList build(InputStream list) throws IOException {
        try {
            return this.build(list, this.getDefaults());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PublicSuffixList download() throws IOException {
        URL url;
        Properties properties = this.getDefaults();
        try {
            url = new URL(properties.getProperty(PROPERTY_URL));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        try (InputStream listStream = url.openStream();){
            PublicSuffixList publicSuffixList = this.build(listStream, properties);
            return publicSuffixList;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private PublicSuffixList build(InputStream list, Properties properties) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        URL url = new URL(properties.getProperty(PROPERTY_URL));
        Charset charset = Charset.forName(properties.getProperty(PROPERTY_CHARSET));
        IndexFactory indexFactory = this.loadIndexFactory(properties.getProperty(PROPERTY_INDEX_FACTORY));
        return this.build(list, url, charset, indexFactory);
    }

    private IndexFactory loadIndexFactory(String indexFactoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> indexFactoryClass = Class.forName(indexFactoryClassName);
        return (IndexFactory)indexFactoryClass.newInstance();
    }

    public PublicSuffixList build() {
        try {
            return this.build(this.getDefaults());
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private PublicSuffixList build(InputStream list, URL url, Charset charset, IndexFactory indexFactory) throws IOException {
        Parser parser = new Parser();
        List<Rule> rules = parser.parse(list, charset);
        rules.add(Rule.DEFAULT);
        Index index = indexFactory.build(rules);
        return new PublicSuffixList(index, url, charset);
    }
}

