/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.publicSuffixList.index.tree;

import de.malkusch.whoisServerList.publicSuffixList.index.tree.TreeIndex;
import de.malkusch.whoisServerList.publicSuffixList.rule.Rule;
import de.malkusch.whoisServerList.publicSuffixList.util.DomainUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

abstract class Node<T extends Node<T>> {
    private final String label;
    private final Map<String, T> children;

    Node(String label) {
        this(label, new HashMap());
    }

    Node(String label, Map<String, T> children) {
        this.label = TreeIndex.getCanonicalLabel(label);
        this.children = children;
    }

    T getChild(String childLabel) {
        return (T)((Node)this.children.get(TreeIndex.getCanonicalLabel(childLabel)));
    }

    Collection<T> getChildren() {
        return this.children.values();
    }

    String getLabel() {
        return this.label;
    }

    void addChild(T node) {
        Node.addChild(node, this.children);
    }

    static <T extends Node<T>> void addChild(T child, Map<String, T> children) {
        children.put(child.getLabel(), child);
    }

    abstract Rule getRule();

    T getWildcard() {
        return (T)((Node)this.children.get("*"));
    }

    Deque<String> convertDomain(String domain) {
        String[] labels = DomainUtil.splitLabels(domain);
        return new LinkedList<String>(Arrays.asList(labels));
    }

    public String toString() {
        return this.label;
    }
}

