/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.publicSuffixList.index.tree;

import de.malkusch.whoisServerList.publicSuffixList.index.Index;
import de.malkusch.whoisServerList.publicSuffixList.index.tree.ImmutableNode;
import de.malkusch.whoisServerList.publicSuffixList.rule.Rule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import prclient.hidden.org.apache.commons.lang3.StringUtils;

@Immutable
final class TreeIndex
extends Index {
    private final ImmutableNode root;

    TreeIndex(ImmutableNode root) {
        this.root = root;
    }

    static String getCanonicalLabel(String label) {
        return StringUtils.lowerCase(label);
    }

    @Override
    protected Collection<Rule> findRules(String domain) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (ImmutableNode node : this.root.findNodes(TreeIndex.getCanonicalLabel(domain))) {
            Rule rule = node.getRule();
            if (rule == null) continue;
            rules.add(rule);
        }
        return rules;
    }

    @Override
    public List<Rule> getRules() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (ImmutableNode node : this.root.getDescendants()) {
            Rule rule = node.getRule();
            if (rule == null) continue;
            rules.add(rule);
        }
        return rules;
    }
}

