/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.publicSuffixList.rule;

import de.malkusch.whoisServerList.publicSuffixList.rule.RuleMatcher;
import de.malkusch.whoisServerList.publicSuffixList.util.DomainUtil;
import java.util.Arrays;
import javax.annotation.concurrent.Immutable;
import prclient.hidden.org.apache.commons.lang3.builder.EqualsBuilder;
import prclient.hidden.org.apache.commons.lang3.builder.HashCodeBuilder;

@Immutable
public final class Rule {
    public static final char EXCEPTION_TOKEN = '!';
    public static final String WILDCARD = "*";
    public static final Rule DEFAULT = new Rule("*");
    private final RuleMatcher matcher;
    private final boolean exceptionRule;

    public Rule(String pattern) {
        this(pattern, false);
    }

    public Rule(String pattern, boolean exceptionRule) {
        this.matcher = new RuleMatcher(pattern);
        this.exceptionRule = exceptionRule;
    }

    public int getLabelCount() {
        return DomainUtil.splitLabels(this.matcher.getPattern()).length;
    }

    public String getPattern() {
        return this.matcher.getPattern();
    }

    public String toString() {
        String pattern = this.matcher.toString();
        return this.isExceptionRule() ? '!' + pattern : pattern;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, obj, new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, new String[0]);
    }

    public boolean isExceptionRule() {
        return this.exceptionRule;
    }

    public String match(String domain) {
        if (domain == null) {
            return null;
        }
        String match = this.matcher.match(domain);
        if (match == null) {
            return null;
        }
        if (!this.isExceptionRule()) {
            return match;
        }
        String[] labels = DomainUtil.splitLabels(match);
        String[] reducedLabels = Arrays.copyOfRange(labels, 1, labels.length);
        return DomainUtil.joinLabels(reducedLabels);
    }
}

