/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.publicSuffixList.rule;

import de.malkusch.whoisServerList.publicSuffixList.rule.LabelMatcher;
import de.malkusch.whoisServerList.publicSuffixList.util.DomainUtil;
import javax.annotation.concurrent.Immutable;
import prclient.hidden.org.apache.commons.lang3.ArrayUtils;
import prclient.hidden.org.apache.commons.lang3.builder.EqualsBuilder;
import prclient.hidden.org.apache.commons.lang3.builder.HashCodeBuilder;

@Immutable
final class RuleMatcher {
    private final String[] reversedLabels;

    RuleMatcher(String[] labels) {
        this.reversedLabels = (String[])labels.clone();
        ArrayUtils.reverse(this.reversedLabels);
    }

    RuleMatcher(String pattern) {
        this(DomainUtil.splitLabels(pattern));
    }

    String match(String domain) {
        if (domain == null) {
            return null;
        }
        Object[] reversedDomainLabels = DomainUtil.splitLabels(domain);
        ArrayUtils.reverse(reversedDomainLabels);
        if (reversedDomainLabels.length < this.reversedLabels.length) {
            return null;
        }
        Object[] reversedMatchedLabels = new String[this.reversedLabels.length];
        for (int i = 0; i < this.reversedLabels.length; ++i) {
            if (i > reversedDomainLabels.length) {
                return null;
            }
            String matchLabel = this.reversedLabels[i];
            LabelMatcher matcher = new LabelMatcher(matchLabel);
            Object domainLabel = reversedDomainLabels[i];
            if (!matcher.isMatch((String)domainLabel)) {
                return null;
            }
            reversedMatchedLabels[i] = domainLabel;
        }
        ArrayUtils.reverse(reversedMatchedLabels);
        return DomainUtil.joinLabels((String[])reversedMatchedLabels);
    }

    String getPattern() {
        Object[] labels = (String[])this.reversedLabels.clone();
        ArrayUtils.reverse(labels);
        return DomainUtil.joinLabels((String[])labels);
    }

    public String toString() {
        return this.getPattern();
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, obj, new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, new String[0]);
    }
}

