/*
 * Decompiled with CFR 0.152.
 */
package prclient.hidden.com.belprime.blex.utils;

public class Url {
    String scheme;
    String location;
    int port;
    String path;
    String parameters;
    String query;
    String fragment;

    public Url() {
    }

    public Url(Url url) {
        this.scheme = url.scheme;
        this.location = url.location;
        this.location = url.location;
        this.port = url.port;
        this.parameters = url.parameters;
        this.query = url.query;
        this.fragment = url.fragment;
    }

    public Url(String scheme, String location, int port, String path, String parameters, String query, String fragment) {
        this.scheme = scheme;
        this.location = location;
        this.port = port;
        this.path = path;
        this.parameters = parameters;
        this.query = query;
        this.fragment = fragment;
    }

    public Url getUrlWithNewScheme(String scheme) {
        return new Url(scheme, this.location, this.port, this.path, this.parameters, this.query, this.fragment);
    }

    public Url getUrlWithNewLocation(String location) {
        return new Url(this.scheme, location, this.port, this.path, this.parameters, this.query, this.fragment);
    }

    public Url getUrlWithNewPort(int port) {
        return new Url(this.scheme, this.location, port, this.path, this.parameters, this.query, this.fragment);
    }

    public Url getUrlWithNewPath(String path) {
        return new Url(this.scheme, this.location, this.port, path, this.parameters, this.query, this.fragment);
    }

    public Url getUrlWithNewParameters(String parameters) {
        return new Url(this.scheme, this.location, this.port, this.path, parameters, this.query, this.fragment);
    }

    public Url getUrlWithNewQuery(String query) {
        return new Url(this.scheme, this.location, this.port, this.path, this.parameters, query, this.fragment);
    }

    public Url getUrlWithNewFragment(String fragment) {
        return new Url(this.scheme, this.location, this.port, this.path, this.parameters, this.query, fragment);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPath() {
        return this.path;
    }

    public int getPort() {
        return this.port;
    }

    public String getParameters() {
        return this.parameters;
    }

    public String getQuery() {
        return this.query;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.scheme != null) {
            sb.append(this.scheme);
            sb.append(':');
        }
        if (this.location != null) {
            sb.append("//");
            sb.append(this.location);
        }
        if (this.port != 0) {
            sb.append(':');
            sb.append(this.port);
        }
        if (this.path != null) {
            sb.append(this.path);
        } else if (this.location != null || this.port != 0) {
            sb.append('/');
        }
        if (this.parameters != null) {
            sb.append(';');
            sb.append(this.parameters);
        }
        if (this.query != null) {
            sb.append('?');
            sb.append(this.query);
        }
        if (this.fragment != null) {
            sb.append('#');
            sb.append(this.fragment);
        }
        return sb.toString();
    }
}

