/*
 * Decompiled with CFR 0.152.
 */
package prclient.hidden.com.belprime.blex.utils;

import prclient.hidden.com.belprime.blex.utils.Url;

public class UrlParser {
    public static Url resolveUrl(String baseUrl, String relativeUrl) {
        if (baseUrl == null) {
            throw new IllegalArgumentException("Base URL must not be null");
        }
        if (relativeUrl == null) {
            throw new IllegalArgumentException("Relative URL must not be null");
        }
        return UrlParser.resolveUrl(UrlParser.parseUrl(baseUrl.trim()), relativeUrl.trim());
    }

    public static Url parseUrl(String spec) {
        int semicolonIndex;
        int questionMarkIndex;
        int locationEndIndex;
        int locationStartIndex;
        String scheme;
        int colonIndex;
        Url url = new Url();
        int startIndex = 0;
        int endIndex = spec.length();
        int crosshatchIndex = UrlParser.indexOf(spec, '#', startIndex, endIndex);
        if (crosshatchIndex >= 0) {
            url.fragment = spec.substring(crosshatchIndex + 1, endIndex);
            endIndex = crosshatchIndex;
        }
        if ((colonIndex = UrlParser.indexOf(spec, ':', startIndex, endIndex)) > 0 && UrlParser.isValidScheme(scheme = spec.substring(startIndex, colonIndex))) {
            url.scheme = scheme.toLowerCase();
            startIndex = colonIndex + 1;
        }
        if (spec.startsWith("//", startIndex)) {
            locationStartIndex = startIndex + 2;
            locationEndIndex = UrlParser.indexOf(spec, '/', locationStartIndex, endIndex);
            if (locationEndIndex >= 0) {
                startIndex = locationEndIndex;
            }
        } else {
            locationStartIndex = -1;
            locationEndIndex = -1;
        }
        if ((questionMarkIndex = UrlParser.indexOf(spec, '?', startIndex, endIndex)) >= 0) {
            if (locationStartIndex >= 0 && locationEndIndex < 0) {
                locationEndIndex = questionMarkIndex;
                startIndex = questionMarkIndex;
            }
            url.query = spec.substring(questionMarkIndex + 1, endIndex);
            endIndex = questionMarkIndex;
        }
        if ((semicolonIndex = UrlParser.indexOf(spec, ';', startIndex, endIndex)) >= 0) {
            if (locationStartIndex >= 0 && locationEndIndex < 0) {
                locationEndIndex = semicolonIndex;
                startIndex = semicolonIndex;
            }
            url.parameters = spec.substring(semicolonIndex + 1, endIndex);
            endIndex = semicolonIndex;
        }
        if (locationStartIndex >= 0 && locationEndIndex < 0) {
            locationEndIndex = endIndex;
        } else if (startIndex < endIndex) {
            url.path = spec.substring(startIndex, endIndex);
        }
        if (locationStartIndex >= 0 && locationEndIndex >= 0) {
            url.location = spec.substring(locationStartIndex, locationEndIndex);
        }
        return url;
    }

    private static int indexOf(String str, char ch, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            if (str.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    private static boolean isValidScheme(String scheme) {
        int length = scheme.length();
        if (length < 1) {
            return false;
        }
        char c = scheme.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            c = scheme.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '+' || c == '-') continue;
            return false;
        }
        return true;
    }

    public static Url resolveUrl(Url baseUrl, String relativeUrl) {
        int slashIndex;
        String pathSegment;
        int pathSegmentIndex;
        Url url = UrlParser.parseUrl(relativeUrl);
        if (baseUrl == null) {
            return url;
        }
        if (relativeUrl.length() == 0) {
            return new Url(baseUrl);
        }
        if (url.scheme != null) {
            return url;
        }
        url.scheme = baseUrl.scheme;
        if (url.location != null) {
            return url;
        }
        url.location = baseUrl.location;
        if (url.path != null && url.path.length() > 0 && '/' == url.path.charAt(0)) {
            url.path = UrlParser.removeLeadingSlashPoints(url.path);
            return url;
        }
        if (url.path == null) {
            url.path = baseUrl.path;
            if (url.parameters != null) {
                return url;
            }
            url.parameters = baseUrl.parameters;
            if (url.query != null) {
                return url;
            }
            url.query = baseUrl.query;
            return url;
        }
        String basePath = baseUrl.path;
        String path = "";
        if (basePath != null) {
            int lastSlashIndex = basePath.lastIndexOf(47);
            if (lastSlashIndex >= 0) {
                path = basePath.substring(0, lastSlashIndex + 1);
            }
        } else {
            path = "/";
        }
        path = path.concat(url.path);
        while ((pathSegmentIndex = path.indexOf("/./")) >= 0) {
            path = path.substring(0, pathSegmentIndex + 1).concat(path.substring(pathSegmentIndex + 3));
        }
        if (path.endsWith("/.")) {
            path = path.substring(0, path.length() - 1);
        }
        while ((pathSegmentIndex = path.indexOf("/../")) > 0) {
            pathSegment = path.substring(0, pathSegmentIndex);
            slashIndex = pathSegment.lastIndexOf(47);
            if (slashIndex >= 0) {
                if ("..".equals(pathSegment.substring(slashIndex))) continue;
                path = path.substring(0, slashIndex + 1).concat(path.substring(pathSegmentIndex + 4));
                continue;
            }
            path = path.substring(pathSegmentIndex + 4);
        }
        if (path.endsWith("/..") && (slashIndex = (pathSegment = path.substring(0, path.length() - 3)).lastIndexOf(47)) >= 0) {
            path = path.substring(0, slashIndex + 1);
        }
        url.path = path = UrlParser.removeLeadingSlashPoints(path);
        return url;
    }

    private static String removeLeadingSlashPoints(String path) {
        while (path.startsWith("/..")) {
            path = path.substring(3);
        }
        return path;
    }
}

