/*
 * Decompiled with CFR 0.152.
 */
package prclient.hidden.com.belprime.blex.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.regex.Pattern;
import prclient.hidden.com.belprime.blex.utils.BitSetURLCodec;
import prclient.hidden.com.belprime.blex.utils.Url;
import prclient.hidden.com.belprime.blex.utils.UrlParser;
import prclient.hidden.gnu.inet.encoding.IDNA;
import prclient.hidden.gnu.inet.encoding.IDNAException;
import prclient.hidden.org.apache.commons.lang.StringUtils;
import prclient.hidden.org.apache.commons.lang.Validate;

public class UrlUtils {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    public static final char SLASH_SMBL = '/';
    public static final char BW_SLASH_SMBL = '\\';
    private static final char COLON_SMBL = ':';
    private static final String COLON_DOUBLE_SLASH = "://";
    private static final String SCHEME_HTTP = "http://";
    private static final String SCHEME_HTTPS = "https://";
    private static final char ANCHOR = '#';
    private static final char PARAM = '?';
    private static final String SUBDOMAIN_PATTERN = "(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})";
    private static final String DOMAIN_REGEX = "(?=.{1,255}(?:/|$))(?:(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})\\.(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})(?:\\.(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63}))*)";
    private static final String DOMAIN_PATTERN_WITH_PORT = "(?=.{1,255}(?:/|$))(?:(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})\\.(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})(?:\\.(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63}))*)(:\\d{1,5})?";
    private static final Pattern DOMAIN_PATTERN = Pattern.compile("(?=.{1,255}(?:/|$))(?:(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})\\.(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})(?:\\.(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63}))*)(:\\d{1,5})?");
    private static final String URL_REGEX = "^(?:http|https)://(?:(?=.{1,255}(?:/|$))(?:(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})\\.(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})(?:\\.(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63}))*)(:\\d{1,5})?)/\\p{ASCII}*";
    private static final Pattern URL_PATTERN = Pattern.compile("^(?:http|https)://(?:(?=.{1,255}(?:/|$))(?:(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})\\.(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})(?:\\.(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63}))*)(:\\d{1,5})?)/\\p{ASCII}*");
    public static final String UTF_8 = "UTF-8";
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final BitSetURLCodec BIT_SET_URL_CODEC = new BitSetURLCodec();

    public static String getDomain(String url) {
        String domain;
        if (StringUtils.isBlank(url)) {
            return null;
        }
        int protocolIndex = UrlUtils.getProtocolIndex(url);
        int endIndex = url.indexOf(47, protocolIndex);
        if (endIndex == -1) {
            endIndex = url.indexOf(63, protocolIndex);
        }
        if (endIndex == -1) {
            endIndex = url.indexOf(35, protocolIndex);
        }
        if (endIndex == -1) {
            endIndex = url.indexOf(92, protocolIndex);
        }
        if ((endIndex = (domain = endIndex > 0 ? url.substring(protocolIndex, endIndex) : url.substring(protocolIndex)).indexOf(58)) != -1) {
            domain = domain.substring(0, endIndex);
        }
        return domain;
    }

    private static int getProtocolIndex(String url) {
        int protocolIndex = url.indexOf(COLON_DOUBLE_SLASH);
        protocolIndex = protocolIndex == -1 ? 0 : (protocolIndex += 3);
        return protocolIndex;
    }

    public static String getBaseDomain(String url) {
        String domain = UrlUtils.getDomain(url);
        if (domain == null) {
            return null;
        }
        String[] parts = StringUtils.split(domain, '.');
        if (parts.length <= 2) {
            return domain;
        }
        if (UrlUtils.isMultiTld(parts)) {
            return parts.length == 3 ? domain : domain.substring(domain.length() - parts[parts.length - 3].length() - parts[parts.length - 2].length() - parts[parts.length - 1].length() - 2);
        }
        return domain.substring(domain.length() - parts[parts.length - 2].length() - parts[parts.length - 1].length() - 1);
    }

    private static boolean isMultiTld(String[] parts) {
        String main = parts[parts.length - 2];
        return "co".equals(main) || "prclient.hidden.com".equals(main) || "info".equals(main) || "gc".equals(main) || "net".equals(main) || "prclient.hidden.org".equals(main) || "edu".equals(main);
    }

    public static String getTld(String domain) {
        String[] parts = StringUtils.split(domain, '.');
        if (parts.length < 2) {
            return null;
        }
        if (parts.length == 2) {
            return parts[1];
        }
        if (UrlUtils.isMultiTld(parts)) {
            return parts[parts.length - 2] + "." + parts[parts.length - 1];
        }
        return parts[parts.length - 1];
    }

    public static String removeAnchor(String url) {
        if (StringUtils.isEmpty(url)) {
            return url;
        }
        int anchorIndex = url.indexOf(35);
        return anchorIndex != -1 ? url.substring(0, anchorIndex) : url;
    }

    public static URL createURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Wrong url: " + url);
        }
    }

    public static boolean isDomainURL(String domainUrl, String url) {
        return UrlUtils.isDomainURL(UrlUtils.createURL(domainUrl), UrlUtils.createURL(url));
    }

    public static boolean isDomainURL(URL domainUrl, URL pageUrl) {
        boolean isDomainsByHost = UrlUtils.removeWWW(domainUrl.getHost()).equalsIgnoreCase(UrlUtils.removeWWW(pageUrl.getHost()));
        boolean isDomainsByProtocol = domainUrl.getProtocol().equals(pageUrl.getProtocol());
        if (domainUrl.getProtocol().contains(HTTP) && pageUrl.getProtocol().contains(HTTP)) {
            isDomainsByProtocol = true;
        }
        return isDomainsByHost && isDomainsByProtocol;
    }

    public static String removeWWW(String host) {
        String www;
        if (host == null) {
            return null;
        }
        if (host.length() > 4 && (www = host.substring(0, 4)).equalsIgnoreCase("www.")) {
            host = host.substring(4);
        }
        return host;
    }

    public static String domainToSiteUrl(String domain) {
        Validate.notNull(domain);
        if (UrlUtils.isOnlySchema(domain)) {
            return domain.toLowerCase();
        }
        String result = UrlUtils.addMissingSchema(domain.trim());
        result = UrlUtils.addMissingSlashAfterDomain(result);
        return UrlUtils.domainToLowerCase(result);
    }

    private static boolean isOnlySchema(String url) {
        int length = url.length();
        if (length != SCHEME_HTTP.length() && length != SCHEME_HTTPS.length()) {
            return false;
        }
        String urlToLower = url.toLowerCase();
        return SCHEME_HTTP.equals(urlToLower) || SCHEME_HTTPS.equals(urlToLower);
    }

    private static String addMissingSchema(String url) {
        String urlToLower = url.toLowerCase();
        if (urlToLower.indexOf(SCHEME_HTTP) != 0 && urlToLower.indexOf(SCHEME_HTTPS) != 0) {
            return SCHEME_HTTP + url;
        }
        return url;
    }

    public static String addMissingSlashAfterDomain(String url) {
        if (url.length() == 0 || UrlUtils.isOnlySchema(url)) {
            return url;
        }
        int slashIndex = url.length();
        int anchorIndex = url.indexOf(35);
        int paramIndex = url.indexOf(63);
        if (anchorIndex != -1 && paramIndex != -1) {
            slashIndex = paramIndex < anchorIndex ? paramIndex : anchorIndex;
        } else if (paramIndex != -1) {
            slashIndex = paramIndex;
        } else if (anchorIndex != -1) {
            slashIndex = anchorIndex;
        }
        String schema = UrlUtils.getSchema(url);
        if (schema == null) {
            return url;
        }
        int firstSlashIndex = url.indexOf(47, schema.length());
        if (firstSlashIndex != -1 && firstSlashIndex <= slashIndex) {
            return url;
        }
        return url.substring(0, slashIndex) + '/' + url.substring(slashIndex);
    }

    public static String domainToLowerCase(String url) {
        String schema = UrlUtils.getSchema(url);
        if (schema == null) {
            return url;
        }
        int slashIndex = url.indexOf(47, schema.length());
        if (slashIndex > -1) {
            return url.substring(0, slashIndex).toLowerCase() + url.substring(slashIndex);
        }
        return url.toLowerCase();
    }

    public static String getSchema(String url) {
        if (StringUtils.startsWith(url, HTTPS)) {
            return SCHEME_HTTPS;
        }
        if (StringUtils.startsWith(url, HTTP)) {
            return SCHEME_HTTP;
        }
        return null;
    }

    public static String getDomainUrl(String url) {
        if (StringUtils.isBlank(url)) {
            return null;
        }
        int protocolIndex = UrlUtils.getProtocolIndex(url);
        int endIndex = url.indexOf(47, protocolIndex);
        if (endIndex == -1) {
            endIndex = url.indexOf(63);
        }
        if (endIndex == -1) {
            endIndex = url.indexOf(35);
        }
        if (endIndex == -1) {
            endIndex = url.indexOf(92);
        }
        return endIndex == -1 ? "" : url.substring(0, endIndex);
    }

    public static String toWWW(String domain) {
        Validate.notEmpty(domain);
        if (domain.startsWith("www.")) {
            return domain;
        }
        return String.format("www.%s", domain);
    }

    public static String getPath(String url) {
        int anchorIndex;
        String pathAndQuery = UrlUtils.getPathAndQuery(url);
        int paramIndex = pathAndQuery.indexOf(63);
        if (paramIndex >= 0) {
            pathAndQuery = pathAndQuery.substring(0, paramIndex);
        }
        if ((anchorIndex = pathAndQuery.indexOf(35)) >= 0) {
            pathAndQuery = pathAndQuery.substring(0, anchorIndex);
        }
        return pathAndQuery;
    }

    public static String getFolder(String url) {
        String pathAndQuery = UrlUtils.getPathAndQuery(url);
        int folderEnd = pathAndQuery.lastIndexOf(47);
        if (folderEnd >= 0) {
            pathAndQuery = pathAndQuery.substring(0, folderEnd);
        }
        return pathAndQuery;
    }

    public static String removeParam(String url, String param) {
        int index = -1;
        boolean found = false;
        while ((index = url.indexOf(param, index)) != -1) {
            if (url.charAt(index - 1) != '&' && url.charAt(index - 1) != '?' || url.charAt(index + param.length()) != '=') continue;
            found = true;
            break;
        }
        if (!found) {
            return url;
        }
        int paramEnd = url.indexOf(38, index);
        if (paramEnd == -1) {
            --index;
            paramEnd = url.indexOf(35);
        } else {
            ++paramEnd;
        }
        if (paramEnd == -1) {
            paramEnd = url.length();
        }
        return url.substring(0, index) + url.substring(paramEnd);
    }

    public static String getPathAndQuery(String url) {
        int protocolIndex = UrlUtils.getProtocolIndex(url);
        int index = url.indexOf(47, protocolIndex);
        if (index == -1) {
            index = url.indexOf(35, protocolIndex);
        }
        if (index == -1) {
            index = url.indexOf(63, protocolIndex);
        }
        if (index == -1) {
            index = url.indexOf(92, protocolIndex);
        }
        if (index == -1) {
            return "";
        }
        return url.substring(index);
    }

    public static boolean isUrlExtensionValid(String link, Collection<String> allowedExtensions) {
        String path = UrlUtils.getPath(link);
        if (path.indexOf(46) == -1) {
            return true;
        }
        if (allowedExtensions.isEmpty()) {
            return true;
        }
        for (String ext : allowedExtensions) {
            if (!path.contains("." + ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUrlValid(String url) {
        return URL_PATTERN.matcher(url).matches();
    }

    public static String domainToIDN(String domain) {
        if (UrlUtils.isAllASCII(domain)) {
            return domain;
        }
        return UrlUtils.toASCII(domain);
    }

    private static String toASCII(String domain) {
        try {
            return IDNA.toASCII(domain);
        }
        catch (IDNAException e) {
            throw new IllegalArgumentException("Invalid domain", e);
        }
    }

    public static String domainToUnicode(String domain) {
        if (UrlUtils.isAllASCII(domain)) {
            return IDNA.toUnicode(domain);
        }
        return domain;
    }

    public static String urlToIDN(String url) {
        String idnUrl = url;
        String domain = UrlUtils.getDomain(url);
        if (!UrlUtils.isAllASCII(domain)) {
            String asciiDomain = UrlUtils.toASCII(domain);
            idnUrl = StringUtils.replaceOnce(url, domain, asciiDomain);
        }
        String path = UrlUtils.getPathAndQuery(idnUrl);
        String encodedPath = UrlUtils.encodeUrl(path);
        return StringUtils.replaceOnce(idnUrl, path, encodedPath);
    }

    public static String urlToIDN(String url, String charset) {
        String idnUrl = url;
        String domain = UrlUtils.getDomain(url);
        if (!UrlUtils.isAllASCII(domain)) {
            String asciiDomain = UrlUtils.toASCII(domain);
            idnUrl = StringUtils.replaceOnce(url, domain, asciiDomain);
        }
        String path = UrlUtils.getPathAndQuery(idnUrl);
        String encodedPath = UrlUtils.encodeUrl(path, charset);
        return StringUtils.replaceOnce(idnUrl, path, encodedPath);
    }

    public static String urlToUnicode(String url) {
        String domain = UrlUtils.getDomain(url);
        if (UrlUtils.isAllASCII(domain)) {
            url = StringUtils.replaceOnce(url, domain, IDNA.toUnicode(domain));
        }
        return UrlUtils.decodeUrl(url, UTF_8);
    }

    public static String removeRepeatingSlashes(String url) {
        if (url == null) {
            return url;
        }
        int length = url.length();
        char[] chars = new char[length];
        int n = 0;
        for (int i = 0; i < length; ++i) {
            char c = url.charAt(i);
            while (i + 1 < length && (c == '/' && url.charAt(i + 1) == '/' || c == '\\' && url.charAt(i + 1) == '\\') && (i == 0 || url.charAt(i - 1) != ':')) {
                ++i;
            }
            chars[n++] = c;
        }
        return n == chars.length ? url : new String(chars, 0, n);
    }

    static String encodeUrl(String url) {
        return BIT_SET_URL_CODEC.encodeUrl(url);
    }

    static String encodeUrl(String url, String charset) {
        return BIT_SET_URL_CODEC.encodeUrl(url, charset);
    }

    public static String decodeUrlUTF8(String s) {
        return UrlUtils.decodeUrl(s, UTF8_CHARSET);
    }

    public static String decodeUrl(String s, String enc) {
        Charset charset = Charset.forName(enc);
        if (charset == null) {
            throw new RuntimeException("Encoding '" + enc + "' not valid");
        }
        return UrlUtils.decodeUrl(s, charset);
    }

    public static String decodeUrl(String s, Charset charset) {
        int percentIndex = s.indexOf(37);
        if (percentIndex == -1) {
            return s;
        }
        int numChars = s.length();
        StringBuilder sb = new StringBuilder(numChars > 500 ? numChars / 2 : numChars);
        byte[] bytes = null;
        int i = 0;
        block3: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '%': {
                    if (bytes == null) {
                        bytes = new byte[(numChars - i) / 3];
                    }
                    int pos = 0;
                    while (i + 2 < numChars && c == '%') {
                        byte val;
                        if ((val = UrlUtils.fromHex(s, ++i)) != 0) {
                            bytes[pos++] = val;
                        }
                        if ((i += 2) >= numChars) continue;
                        c = s.charAt(i);
                    }
                    if (i < numChars && c == '%') {
                        throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                    }
                    sb.append(new String(bytes, 0, pos, charset));
                    continue block3;
                }
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    static byte fromHex(String s, int i) {
        return (byte)(UrlUtils.fromHex(s.charAt(i)) << 4 | UrlUtils.fromHex(s.charAt(i + 1)));
    }

    static byte fromHex(char ch) {
        if (ch >= '0' && ch <= '9') {
            return (byte)(ch - 48);
        }
        if (ch >= 'A' && ch <= 'F') {
            return (byte)(ch - 65 + 10);
        }
        if (ch >= 'a' && ch <= 'f') {
            return (byte)(ch - 97 + 10);
        }
        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern");
    }

    public static boolean isAllASCII(String input) {
        boolean isASCII = true;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c <= '\u007f') continue;
            isASCII = false;
            break;
        }
        return isASCII;
    }

    @Deprecated
    public static boolean isDomainValid(String domain) {
        return (domain = UrlUtils.getDomain(domain)) != null && UrlUtils.isUrlValid(String.format("http://%s/", UrlUtils.domainToIDN(domain)));
    }

    public static Url resolveAndValidateUrl(Url baseUrl, String href) {
        if (StringUtils.isNotBlank(href)) {
            href = UrlUtils.removeRepeatingSlashes(href);
            Url url = UrlParser.resolveUrl(baseUrl, href = StringUtils.replace(href, "&amp;", "&"));
            if (url.getLocation() == null) {
                return null;
            }
            if (UrlUtils.isValidScheme((url = url.getUrlWithNewLocation(url.getLocation().toLowerCase())).getScheme()) && UrlUtils.isValidDomain(url.getLocation())) {
                try {
                    String domain = UrlUtils.domainToUnicode(url.getLocation());
                    url = url.getUrlWithNewLocation(domain);
                    return url;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static boolean isValidScheme(String scheme) {
        if (scheme == null) {
            return false;
        }
        int length = scheme.length();
        if (length != HTTP.length() && length != HTTPS.length()) {
            return false;
        }
        String urlToLower = scheme.toLowerCase();
        return HTTP.equals(urlToLower) || HTTPS.equals(urlToLower);
    }

    public static boolean isValidDomain(String domain) {
        return domain != null && DOMAIN_PATTERN.matcher(UrlUtils.domainToIDN(domain)).matches();
    }

    public static String revertDomain(String domainName) {
        String[] parts = StringUtils.split(domainName, '.');
        StringBuilder sb = new StringBuilder();
        for (int i = parts.length - 1; i >= 0; --i) {
            sb.append(parts[i]);
            if (i <= 0) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    public static boolean isWww(String domainName) {
        return domainName.startsWith("www.");
    }

    public static boolean isHttps(String schema) {
        return schema.startsWith(HTTPS);
    }

    public static boolean isConvertedIP(String domain) {
        if (domain == null) {
            return false;
        }
        if (StringUtils.startsWith(domain, "0x") || StringUtils.contains(domain, ".0x")) {
            return true;
        }
        String[] parts = StringUtils.split(domain, '.');
        boolean leadingZeros = true;
        for (String p : parts) {
            leadingZeros &= StringUtils.startsWith(p, "0");
        }
        return leadingZeros;
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] getDomainAsIP(String domain) {
        if (domain == null) {
            return null;
        }
        parts = StringUtils.split(domain, '.');
        if (parts == null || parts.length != 4) {
            return null;
        }
        arr = new byte[4];
        matched = true;
        i = 0;
        for (String part : parts) {
            matched = part.length() > 0 && part.length() <= 3;
            if (!(matched &= matched != false && UrlUtils.isByteValue(part) != false)) ** GOTO lbl-1000
            v0 = i;
            i = (byte)(i + 1);
            if (UrlUtils.parseByte(part, arr, v0)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!(matched &= v1)) break;
        }
        return (byte[])(matched != false ? arr : null);
    }

    private static boolean parseByte(String part, byte[] arr, byte i) {
        try {
            int val = Integer.parseInt(part);
            if (val >= 0 && val <= 255) {
                arr[i] = (byte)val;
                return true;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return false;
    }

    private static boolean isByteValue(String part) {
        for (int i = 0; i < part.length(); ++i) {
            if (part.charAt(i) >= '0' && part.charAt(i) <= '9') continue;
            return false;
        }
        return true;
    }

    public static String ipArrAsStr(byte[] ipArr) {
        if (ipArr == null || ipArr.length != 4) {
            return null;
        }
        return String.valueOf(ipArr[0] & 0xFF) + "." + (ipArr[1] & 0xFF) + "." + (ipArr[2] & 0xFF) + "." + (ipArr[3] & 0xFF);
    }

    public static boolean isInternalIP(byte[] ipArr) {
        if (ipArr == null) {
            return false;
        }
        return ipArr[0] == 10 || ipArr[0] == 127 || ipArr[0] == -84 && ipArr[1] >= 16 && ipArr[1] <= 31 || ipArr[0] == -64 && ipArr[1] == -88;
    }

    public static boolean isDomainAsInternalIP(String domain) {
        return UrlUtils.isInternalIP(UrlUtils.getDomainAsIP(domain));
    }

    public static boolean isUrlAsInternalIP(String url) {
        return UrlUtils.isInternalIP(UrlUtils.getDomainAsIP(UrlUtils.getDomain(url)));
    }
}

