/*
 * Decompiled with CFR 0.152.
 */
package prclient.hidden.com.belprime.di.common.format;

import java.nio.charset.StandardCharsets;
import prclient.hidden.com.belprime.di.common.format.UrlNormalizer;
import prclient.hidden.com.google.common.hash.Hashing;
import prclient.hidden.com.google.common.primitives.Longs;
import prclient.hidden.org.apache.commons.lang.StringUtils;
import prclient.hidden.org.apache.commons.lang.Validate;

public class DomainAndFullUrlHasher {
    private final int totalHashLength;
    private final int domainPartBytes;

    public DomainAndFullUrlHasher(int totalHashLength, int domainPartBytes) {
        Validate.isTrue(totalHashLength > 0, "totalHashLength must be greater than zero");
        Validate.isTrue(domainPartBytes > 0, "totalHashLength must be greater than zero");
        Validate.isTrue(totalHashLength > domainPartBytes, "totalHashLength must be greater than domainPartBytes");
        this.domainPartBytes = domainPartBytes;
        this.totalHashLength = totalHashLength;
    }

    public byte[] hash(String url) {
        if (url == null || StringUtils.isBlank(url)) {
            return this.cloneZero();
        }
        String domain = UrlNormalizer.getDomain(url);
        byte[] domainHash = Hashing.murmur3_128().hashBytes(domain.getBytes(StandardCharsets.US_ASCII)).asBytes();
        byte[] urlHash = Hashing.murmur3_128().hashBytes(url.getBytes(StandardCharsets.US_ASCII)).asBytes();
        byte[] result = new byte[this.totalHashLength];
        System.arraycopy(domainHash, 0, result, 0, this.domainPartBytes);
        System.arraycopy(urlHash, 0, result, this.domainPartBytes, this.totalHashLength - this.domainPartBytes);
        return result;
    }

    public static long getLongHash(String url) {
        byte[] urlHash = Hashing.murmur3_128().hashBytes(url.getBytes(StandardCharsets.US_ASCII)).asBytes();
        return Longs.fromByteArray(urlHash);
    }

    public static long getLong(byte[] hash, int offset) {
        return Longs.fromBytes(hash[offset], hash[offset + 1], hash[offset + 2], hash[offset + 3], hash[offset + 4], hash[offset + 5], hash[offset + 6], hash[offset + 7]);
    }

    private byte[] cloneZero() {
        return new byte[this.totalHashLength];
    }

    public int hashSize() {
        return this.totalHashLength;
    }

    public int domainPartSize() {
        return this.domainPartBytes;
    }

    public int urlPartSize() {
        return this.totalHashLength - this.domainPartBytes;
    }
}

