/*
 * Decompiled with CFR 0.152.
 */
package prclient.hidden.com.belprime.di.common.format;

import java.lang.reflect.Field;
import java.nio.CharBuffer;
import sun.misc.SharedSecrets;
import sun.misc.Unsafe;

public class ExtStringUtils {
    public static boolean startsWith(char[] chars0, int offset0, int length0, char[] chars1, int offset1, int length1) {
        if (length0 < length1) {
            return false;
        }
        if (length1 == 0) {
            return true;
        }
        int maxOffset1 = offset1 + length1;
        while (offset1 < maxOffset1) {
            if (chars0[offset0] != chars1[offset1]) {
                return false;
            }
            ++offset0;
            ++offset1;
        }
        return true;
    }

    public static void reverseByDelimiterInPlace(char[] chars, int offset, int length, char c) {
        ExtStringUtils.reverseByDelimiterInPlace0(chars, offset, offset + length - 1, c);
    }

    public static String reverseByDelimiter(String str, char c) {
        char[] chars = str.toCharArray();
        ExtStringUtils.reverseByDelimiterInPlace(chars, 0, chars.length, c);
        return ExtStringUtils.hook(chars);
    }

    public static void reverseInPlace(char[] chars, int offset, int length) {
        ExtStringUtils.reverseInPlace0(chars, offset, offset + length - 1);
    }

    public static char[] hook(String s) {
        return UnsafeString.getChars(s);
    }

    public static String hook(char[] c) {
        return SharedSecrets.getJavaLangAccess().newStringUnsafe(c);
    }

    public static CharSequence charSequence(final char[] chars, final int offset, final int length) {
        return new CharSequence(){

            @Override
            public int length() {
                return length;
            }

            @Override
            public char charAt(int index) {
                return chars[index + offset];
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return ExtStringUtils.charSequence(chars, offset + start, end - start);
            }

            @Override
            public String toString() {
                return new String(chars, offset, length);
            }
        };
    }

    private static void reverseByDelimiterInPlace0(char[] chars, int startIncluding, int endIncluding, char c) {
        ExtStringUtils.reverseInPlace0(chars, startIncluding, endIncluding);
        int startToken = startIncluding;
        while (startIncluding <= endIncluding) {
            if (chars[startIncluding] == c) {
                ExtStringUtils.reverseInPlace0(chars, startToken, startIncluding - 1);
                startToken = startIncluding + 1;
            }
            ++startIncluding;
        }
        ExtStringUtils.reverseInPlace0(chars, startToken, startIncluding - 1);
    }

    private static void reverseInPlace0(char[] chars, int startIncluding, int endIncluding) {
        while (startIncluding < endIncluding) {
            char c = chars[endIncluding];
            chars[endIncluding] = chars[startIncluding];
            chars[startIncluding] = c;
            ++startIncluding;
            --endIncluding;
        }
    }

    private static class UnsafeString {
        private static final Unsafe unsafe;
        private static final long valueOffset;
        private static final long offsetOffset;
        private static final long countOffset;

        private UnsafeString() {
        }

        public static String buildUnsafe(char[] chars) {
            String mutable = new String();
            unsafe.putObject(mutable, valueOffset, chars);
            if (countOffset != -1L) {
                unsafe.putInt(mutable, countOffset, chars.length);
            }
            return mutable;
        }

        public static String buildUnsafe(char[] chars, int offset, int length) {
            String mutable = new String();
            unsafe.putObject(mutable, valueOffset, chars);
            if (countOffset != -1L) {
                unsafe.putInt(mutable, countOffset, length);
                unsafe.putIntVolatile(mutable, offsetOffset, offset);
            }
            return mutable;
        }

        public static char[] getChars(String s) {
            return (char[])unsafe.getObject(s, valueOffset);
        }

        public static int getOffset(String s) {
            if (offsetOffset == -1L) {
                return 0;
            }
            return unsafe.getInt(s, offsetOffset);
        }

        public static CharBuffer getStringAsCharBuffer(String s) {
            return CharBuffer.wrap(UnsafeString.getChars(s));
        }

        static {
            try {
                Field declaredField;
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                unsafe = (Unsafe)field.get(null);
                valueOffset = unsafe.objectFieldOffset(String.class.getDeclaredField("value"));
                try {
                    declaredField = String.class.getDeclaredField("count");
                }
                catch (NoSuchFieldException e) {
                    declaredField = null;
                }
                countOffset = declaredField != null ? unsafe.objectFieldOffset(declaredField) : -1L;
                declaredField = null;
                try {
                    declaredField = String.class.getDeclaredField("offset");
                }
                catch (NoSuchFieldException e) {
                    declaredField = null;
                }
                offsetOffset = declaredField != null ? unsafe.objectFieldOffset(declaredField) : -1L;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

