/*
 * Decompiled with CFR 0.152.
 */
package prclient.hidden.com.belprime.di.common.format;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import prclient.hidden.com.belprime.blex.utils.UrlUtils;
import prclient.hidden.com.belprime.di.common.format.ExtStringUtils;
import prclient.hidden.org.apache.commons.lang.StringUtils;
import prclient.hidden.org.apache.commons.lang.Validate;

public class UrlNormalizer {
    private static final Logger LOG = Logger.getLogger(UrlNormalizer.class.getName());
    public static final char SIGN_HTTPS = 's';
    public static final char SIGN_HTTP = 'h';
    public static final char SIGN_WWW = 'w';
    public static final String WWW_SUFFIX = ".www";
    public static final char URL_META_INFO_SEPARATOR = '\t';
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final String HTTP = "http://";
    public static final String HTTPS = "https://";
    public static final String DEFAULT_PORT_HTTP = "80";
    public static final String DEFAULT_PORT_HTTPS = "443";

    private UrlNormalizer() {
    }

    public static String normalizeAndTransform(String url, String charset) {
        return UrlNormalizer.normalizeAndTransform(url, charset, true);
    }

    public static String normalizeAndTransform(String url, String charset, boolean validateUrl) {
        String result = UrlNormalizer.normalize(url, charset, validateUrl);
        if (result != null) {
            result = UrlNormalizer.transformLink(result);
        }
        return result;
    }

    public static String normalizeAndTransform(String url) {
        return UrlNormalizer.normalizeAndTransform(url, DEFAULT_CHARSET.name());
    }

    public static String normalize(String url, String charset) {
        return UrlNormalizer.normalize(url, charset, true);
    }

    public static String normalize(String url, String charset, boolean validateUrl) {
        String string = charset = charset == null ? DEFAULT_CHARSET.name() : charset;
        if (StringUtils.isBlank(url)) {
            return null;
        }
        String normalized = UrlNormalizer.urlToAscii(url, charset);
        if (normalized != null) {
            normalized = UrlUtils.addMissingSlashAfterDomain(normalized);
        }
        if (normalized == null || normalized.length() > 2063 || validateUrl && !UrlUtils.isUrlValid(normalized)) {
            return null;
        }
        return normalized;
    }

    public static String normalize(String url) {
        return UrlNormalizer.normalize(url, DEFAULT_CHARSET.name());
    }

    public static String removeReverseDomainWWW(String reverseDomain) {
        return reverseDomain.endsWith(WWW_SUFFIX) ? reverseDomain.substring(0, reverseDomain.length() - WWW_SUFFIX.length()) : reverseDomain;
    }

    public static String woSchemaAndWWW(String pageId) {
        String domain;
        String normalizedDomain = domain = prclient.hidden.com.belprime.util.UrlUtils.getDomain(pageId);
        if (domain.endsWith(WWW_SUFFIX)) {
            normalizedDomain = domain.substring(0, domain.length() - WWW_SUFFIX.length());
        }
        return normalizedDomain + pageId.substring(domain.length(), pageId.length() - 1);
    }

    public static String getDomainWoReverseWWW(String url) {
        return UrlNormalizer.removeReverseDomainWWW(prclient.hidden.com.belprime.util.UrlUtils.getDomain(url));
    }

    @Deprecated
    public static String transformLink(String link) {
        String domain = prclient.hidden.com.belprime.util.UrlUtils.getDomain(link);
        String url = prclient.hidden.com.belprime.util.UrlUtils.removeSchema(link);
        url = prclient.hidden.com.belprime.util.UrlUtils.removeAnchor(url);
        String pathAndQuery = prclient.hidden.com.belprime.util.UrlUtils.getPathAndQuery(url);
        domain = UrlNormalizer.removeDefaultPortsFromDomain(UrlUtils.getSchema(link), domain);
        String reversedDomain = UrlNormalizer.reverseDomain(domain);
        return reversedDomain + (pathAndQuery.startsWith("/") ? "" : "/") + pathAndQuery + (UrlUtils.isHttps(link) ? (char)'s' : 'h');
    }

    public static String transformLinkV2(String link) {
        String domainWithWWW = prclient.hidden.com.belprime.util.UrlUtils.getDomain(link);
        String domain = prclient.hidden.com.belprime.util.UrlUtils.removeWWW(domainWithWWW);
        boolean hasWWW = !domain.equals(domainWithWWW);
        String url = prclient.hidden.com.belprime.util.UrlUtils.removeSchema(link);
        url = prclient.hidden.com.belprime.util.UrlUtils.removeAnchor(url);
        String pathAndQuery = prclient.hidden.com.belprime.util.UrlUtils.getPathAndQuery(url);
        domain = UrlNormalizer.removeDefaultPortsFromDomain(UrlUtils.getSchema(link), domain);
        String reversedDomain = UrlNormalizer.reverseDomain(domain);
        return reversedDomain + (pathAndQuery.startsWith("/") ? "" : "/") + pathAndQuery + '\t' + (UrlUtils.isHttps(link) ? (char)'s' : 'h') + (hasWWW ? Character.valueOf('w') : "");
    }

    public static String getUrlWoMetaInfo(String url) {
        return url.substring(0, UrlNormalizer.getUrlPrefixLength(url));
    }

    public static int getUrlPrefixLength(String url) {
        char lastChar = url.charAt(url.length() - 1);
        return url.length() - (lastChar == 'w' ? 3 : 2);
    }

    public static String removeDefaultPortsFromDomain(String schema, String domain) {
        String defaultPort;
        if (StringUtils.isBlank(schema) || StringUtils.isBlank(domain)) {
            return domain;
        }
        switch (schema) {
            case "http://": {
                defaultPort = DEFAULT_PORT_HTTP;
                break;
            }
            case "https://": {
                defaultPort = DEFAULT_PORT_HTTPS;
                break;
            }
            default: {
                return domain;
            }
        }
        int colonIdx = domain.indexOf(58);
        if (colonIdx == -1 || colonIdx == domain.length() - 1) {
            return domain;
        }
        String port = domain.substring(colonIdx + 1);
        if (defaultPort.equals(port)) {
            return domain.substring(0, colonIdx);
        }
        return domain;
    }

    public static boolean isDomainAnIPv4(String domain) {
        if (StringUtils.isBlank(domain)) {
            return false;
        }
        String[] parts = domain.split("\\.");
        if (parts.length != 4) {
            return false;
        }
        for (String part : parts) {
            try {
                int i = Integer.parseInt(part);
                if (i >= 0 && i <= 255) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public static String reverseDomain(String domain) {
        return ExtStringUtils.reverseByDelimiter(domain, '.');
    }

    public static String tldForReversed(String pageId) {
        int idx = pageId.indexOf(46);
        if (idx > 0) {
            return pageId.substring(0, idx);
        }
        return "";
    }

    public static String tldForDirect(String pageId) {
        String domain = prclient.hidden.com.belprime.util.UrlUtils.getDomain(pageId);
        boolean endsWithDot = domain.charAt(domain.length() - 1) == '.';
        int idx = domain.lastIndexOf(46, domain.length() - (endsWithDot ? 2 : 1));
        if (idx > 0) {
            return domain.substring(idx + 1, domain.length() - (endsWithDot ? 1 : 0));
        }
        return "";
    }

    private static String urlToAscii(String unAnchoredUrl, String charset) {
        try {
            return UrlUtils.urlToIDN(unAnchoredUrl, charset);
        }
        catch (RuntimeException e) {
            LOG.log(Level.SEVERE, e, () -> String.format("Invalid url=%s, charset=%s", unAnchoredUrl, charset));
            return null;
        }
    }

    public static String getSchemaForPageId(String pageId) {
        Validate.notEmpty(pageId);
        char lastOne = pageId.charAt(pageId.length() - 1);
        switch (lastOne) {
            case 'h': {
                return HTTP;
            }
            case 's': {
                return HTTPS;
            }
        }
        throw new IllegalArgumentException("Illegal page id with unknown protocol: " + pageId);
    }

    public static String removeDefaultPortsFromPageId(String pageId) {
        String defaultPort;
        String schema;
        switch (schema = UrlNormalizer.getSchemaForPageId(pageId)) {
            case "http://": {
                defaultPort = DEFAULT_PORT_HTTP;
                break;
            }
            case "https://": {
                defaultPort = DEFAULT_PORT_HTTPS;
                break;
            }
            default: {
                return pageId;
            }
        }
        String tld = UrlNormalizer.tldForReversed(pageId);
        if (StringUtils.isBlank(tld)) {
            return pageId;
        }
        int colonIdx = tld.indexOf(58);
        if (colonIdx == -1 || colonIdx == tld.length() - 1) {
            return pageId;
        }
        String port = tld.substring(colonIdx + 1);
        if (defaultPort.equals(port)) {
            String newTld = tld.substring(0, colonIdx);
            return newTld + pageId.substring(pageId.indexOf(tld) + tld.length());
        }
        return pageId;
    }

    public static String normalizePageId(String neighborId) {
        return UrlNormalizer.woSchemaAndWWW(UrlNormalizer.removeDefaultPortsFromPageId(neighborId));
    }

    public static String getDomain(String url) {
        if (url.startsWith(HTTP) || url.startsWith(HTTPS)) {
            return UrlUtils.getDomain(url);
        }
        int domainDelimiter = UrlNormalizer.getDomainDelimiterPosition(url);
        return domainDelimiter < 0 ? url : url.substring(0, domainDelimiter);
    }

    private static int getDomainDelimiterPosition(String url) {
        for (int i = 0; i < url.length(); ++i) {
            char c = url.charAt(i);
            if (c != '/' && c != '?' && c != '#' && c != '\\') continue;
            return i;
        }
        return -1;
    }
}

