/*
 * Decompiled with CFR 0.152.
 */
package prclient.hidden.com.belprime.url.pld;

import de.malkusch.whoisServerList.publicSuffixList.PublicSuffixList;
import de.malkusch.whoisServerList.publicSuffixList.PublicSuffixListFactory;
import de.malkusch.whoisServerList.publicSuffixList.util.PunycodeAutoDecoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;

public class PldExtractor {
    private static final Locale AZERBAIJAN = new Locale("az", "AZ");
    private static final Locale LITHUANIA = new Locale("lt", "LT");
    private static final Locale TURKEY = new Locale("tr", "TR");
    private final PublicSuffixList suffixList;

    public PldExtractor(List<String> publicSuffixes) {
        PublicSuffixListFactory factory = new PublicSuffixListFactory();
        try {
            this.suffixList = factory.build(new ByteArrayInputStream(this.getBytes(publicSuffixes)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] getBytes(List<String> lines) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (String line : lines) {
            try {
                out.write(line.getBytes(StandardCharsets.UTF_8));
                out.write(10);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return out.toByteArray();
    }

    public String getPld(String domain) {
        String result = this.suffixList.getRegistrableDomain(domain);
        if (result != null && (result = result.toLowerCase(this.getLocale(domain))).endsWith(".local")) {
            result = null;
        }
        return result;
    }

    public String getPublicSuffix(String domain) {
        PunycodeAutoDecoder punycode = new PunycodeAutoDecoder();
        String decodedDomain = punycode.decode(domain);
        String suffix = this.suffixList.getPublicSuffix(decodedDomain);
        String result = punycode.recode(suffix);
        if (result != null && (result = result.toLowerCase(this.getLocale(domain))).equals("local")) {
            result = null;
        }
        return result;
    }

    private Locale getLocale(String domain) {
        if (domain.endsWith(".tr")) {
            return TURKEY;
        }
        if (domain.endsWith(".az")) {
            return AZERBAIJAN;
        }
        if (domain.endsWith(".lt")) {
            return LITHUANIA;
        }
        return Locale.ROOT;
    }
}

