/*
 * Decompiled with CFR 0.152.
 */
package prclient.hidden.com.belprime.url.pld;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import prclient.hidden.com.belprime.url.pld.PublicSuffixesDictionary;

public class PublicSuffixesDictionaryLoader {
    private final InputStream in;

    public PublicSuffixesDictionaryLoader(InputStream in) {
        this.in = Objects.requireNonNull(in);
    }

    public PublicSuffixesDictionary load() throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.in, StandardCharsets.UTF_8));
        ArrayList<String> domains = new ArrayList<String>();
        int privateDomainsStart = -1;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || line.startsWith("//")) {
                if (!line.startsWith("// ===END ICANN DOMAINS===")) continue;
                privateDomainsStart = domains.size();
                continue;
            }
            domains.add(line);
        }
        return new PublicSuffixesDictionary(Collections.unmodifiableList(domains), Collections.unmodifiableList(domains.subList(0, privateDomainsStart)), Collections.unmodifiableList(domains.subList(privateDomainsStart, domains.size())));
    }
}

