/*
 * Decompiled with CFR 0.152.
 */
package prclient.hidden.com.belprime.util;

import java.io.UnsupportedEncodingException;
import java.net.IDN;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import prclient.hidden.org.apache.commons.collections.CollectionUtils;
import prclient.hidden.org.apache.commons.lang.StringUtils;

public class UrlUtils {
    public static final int MAX_URL_LENGTH = 2083;
    private static final String PREFIX_WWW = "www.";
    private static final Charset ENCODER_CHARSET = StandardCharsets.US_ASCII;
    private static final String SUBDOMAIN_PATTERN = "(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})";
    private static final String DOMAIN_PATTERN = "(?=.{1,255}(?:/|$))(?:(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})\\.(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})(?:\\.(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63}))*)";
    private static final String DOMAIN_PATTERN_WITH_PORT = "(?=.{1,255}(?:/|$))(?:(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})\\.(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})(?:\\.(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63}))*)(:\\d{1,5})?";
    public static final String URL_REGEX = "(?:http|https)://(?:(?=.{1,255}(?:/|$))(?:(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})\\.(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})(?:\\.(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63}))*)(:\\d{1,5})?)/";
    private static final String EXACT_MATCH_URL_REGEX = "^(?:http|https)://(?:(?=.{1,255}(?:/|$))(?:(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})\\.(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})(?:\\.(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63}))*)(:\\d{1,5})?)/\\p{ASCII}*";
    private static final Pattern URL_PATTERN = Pattern.compile("^(?:http|https)://(?:(?=.{1,255}(?:/|$))(?:(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})\\.(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63})(?:\\.(?:[^/\\(\\)<>\\.,;:\"\\[\\]\\s`~!#\\$%\\^&\\*\\+=\\{\\}\\|\\?@&&[\\p{ASCII}]]{1,63}))*)(:\\d{1,5})?)/\\p{ASCII}*");
    private static final char[] URL_SYMBOLS = new char[]{'%', '/', '+', ':', '?', '&', '=', '#', '$', ',', '@'};
    private static final int caseDiff = 32;
    public static final String ANCHOR = "#";
    public static final String SLASH = "/";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String COLON = ":";
    private static final String COLON_DOUBLE_SLASH = "://";
    public static final String SCHEME_HTTP = "http://";
    public static final String SCHEME_HTTPS = "https://";
    private static final String PARAM = "?";
    public static final String HTTP_DEFAULT_PORT = "80";
    public static final String HTTPS_DEFAULT_PORT = "443";
    public static final String ACE_PREFIX = "xn--";
    public static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;
    public static final String EMPTY_STRING = "";

    public static String getTopLevelDomain(String domain) {
        String tld = domain.substring(domain.lastIndexOf(".") + 1);
        return StringUtils.isNumeric(tld) ? null : tld;
    }

    public static String removeWWW(String host) {
        String www;
        if (host.length() > 4 && (www = host.substring(0, 4)).equalsIgnoreCase(PREFIX_WWW) && host.indexOf(46, 4) != -1) {
            host = host.substring(4);
        }
        return host;
    }

    public static String getAnchorFromUrl(String url) {
        if (!UrlUtils.isAnchorUrl(url)) {
            return null;
        }
        int anchorIndex = url.indexOf(ANCHOR);
        return url.substring(anchorIndex + 1, url.length());
    }

    public static String addAnchorToUrl(String url, String anchor) {
        return StringUtils.isEmpty(anchor) ? url : url + ANCHOR + anchor;
    }

    public static String removeSchema(String url) {
        return !url.contains(COLON_DOUBLE_SLASH) ? url : url.substring(url.indexOf(COLON_DOUBLE_SLASH) + 3);
    }

    public static String addPathToUrl(String sourceUrl, String pathToAdd) {
        if (sourceUrl.endsWith(SLASH) && pathToAdd.startsWith(SLASH)) {
            return UrlUtils.removeLastSlash(sourceUrl) + pathToAdd;
        }
        return sourceUrl.endsWith(SLASH) || pathToAdd.startsWith(SLASH) ? sourceUrl + pathToAdd : sourceUrl + SLASH + pathToAdd;
    }

    public static String getDomain(String url) {
        if (StringUtils.isBlank(url)) {
            return null;
        }
        int startIndex = url.indexOf(COLON_DOUBLE_SLASH);
        startIndex = startIndex == -1 ? 0 : (startIndex += 3);
        int endIndex = url.indexOf(SLASH, startIndex);
        return endIndex > 0 ? url.substring(startIndex, endIndex) : url.substring(startIndex);
    }

    public static String getDomainUrl(String url) {
        if (StringUtils.isBlank(url)) {
            return null;
        }
        int startIndex = url.indexOf(COLON_DOUBLE_SLASH);
        startIndex = startIndex == -1 ? 0 : (startIndex += 3);
        int endIndex = url.indexOf(SLASH, startIndex);
        return endIndex == -1 ? url : url.substring(0, endIndex);
    }

    public static String getFolder(String url) {
        String path = UrlUtils.createURL(url).getPath();
        return StringUtils.isEmpty(path) ? SLASH : path.substring(0, path.lastIndexOf(SLASH) + 1);
    }

    public static String getPage(String url) {
        String path = UrlUtils.createURL(url).getFile();
        return path.substring(path.lastIndexOf(SLASH) + 1);
    }

    public static URL createURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Wrong url: " + url);
        }
    }

    public static boolean isDomainURL(String domainUrl, String url) {
        return UrlUtils.isDomainURL(UrlUtils.createURL(domainUrl), UrlUtils.createURL(url));
    }

    public static boolean isDomainURL(URL domainUrl, URL pageUrl) {
        boolean isDomainsByHost = UrlUtils.removeWWW(domainUrl.getHost()).equalsIgnoreCase(UrlUtils.removeWWW(pageUrl.getHost()));
        boolean isDomainsByProtocol = domainUrl.getProtocol().equals(pageUrl.getProtocol());
        if (domainUrl.getProtocol().contains(HTTP) && pageUrl.getProtocol().contains(HTTP)) {
            isDomainsByProtocol = true;
        }
        return isDomainsByHost && isDomainsByProtocol;
    }

    public static String getPath(String url) {
        int anchorIndex;
        String pathAndQuery = UrlUtils.getPathAndQuery(url);
        int paramIndex = pathAndQuery.indexOf(63);
        if (paramIndex >= 0) {
            pathAndQuery = pathAndQuery.substring(0, paramIndex);
        }
        if ((anchorIndex = pathAndQuery.indexOf(35)) >= 0) {
            pathAndQuery = pathAndQuery.substring(0, anchorIndex);
        }
        return pathAndQuery;
    }

    public static String getPathAndQuery(String url) {
        String hostPort = url.toLowerCase().indexOf(SCHEME_HTTP) == 0 ? url.substring(SCHEME_HTTP.length()) : (url.toLowerCase().indexOf(SCHEME_HTTPS) == 0 ? url.substring(SCHEME_HTTPS.length()) : url);
        int hostPortIndex = hostPort.indexOf(SLASH);
        if (hostPortIndex != -1) {
            hostPort = hostPort.substring(0, hostPortIndex);
        }
        return url.substring(url.indexOf(hostPort) + hostPort.length());
    }

    public static String removePortFromDomain(String url) {
        String[] strings = url.split(":\\d+", 2);
        String result = EMPTY_STRING;
        for (String string : strings) {
            result = result + string;
        }
        return result;
    }

    public static boolean isUrlValid(String url) {
        return StringUtils.isNotBlank(url) && url.length() <= 2083 && URL_PATTERN.matcher(url).matches();
    }

    public static boolean isASCIIOnlyUrlDomain(String url) {
        return ENCODER_CHARSET.newEncoder().canEncode(UrlUtils.getDomain(url));
    }

    public static String getASCIIConvertedUrlDomain(String url) {
        String domain = UrlUtils.getDomain(url);
        return url.replaceFirst(domain, IDN.toASCII(domain));
    }

    public static URL getASCIIConvertedUrlDomain(URL url) {
        return UrlUtils.createURL(UrlUtils.getASCIIConvertedUrlDomain(url.toExternalForm()));
    }

    public static String getUnicodeConvertedUrlDomain(String url) {
        String domain = UrlUtils.getDomain(url);
        return url.replaceFirst(domain, IDN.toUnicode(domain));
    }

    public static boolean isDomainEqual(String url1, String url2) {
        return UrlUtils.removePortFromDomain(UrlUtils.removeWWW(UrlUtils.getDomain(url1))).equals(UrlUtils.removePortFromDomain(UrlUtils.removeWWW(UrlUtils.getDomain(url2))));
    }

    public static String cutPathAndQuery(String url) {
        int startIndex = url.indexOf(COLON_DOUBLE_SLASH);
        int stopIndex = url.indexOf(SLASH, startIndex >= 0 ? startIndex + 3 : 0);
        return stopIndex < 0 ? url : url.substring(0, stopIndex + 1);
    }

    public static String normalizeUrl(String url) {
        int slashIndex = url.indexOf(SLASH, url.indexOf(COLON_DOUBLE_SLASH) + 3);
        if (slashIndex == -1) {
            return url.toLowerCase();
        }
        return url.substring(0, slashIndex).toLowerCase() + url.substring(slashIndex);
    }

    public static String removeBrakes(String str) {
        return UrlUtils.isEmpty(str) ? EMPTY_STRING : str.replace('\t', ' ').replace('\n', ' ').replace('\r', ' ');
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static String trimHTML(String str) {
        return str != null ? UrlUtils.replace(UrlUtils.removeBrakes(str), "  ", " ").trim() : EMPTY_STRING;
    }

    public static String replace(String string, String from, String to) {
        StringBuilder buffer = new StringBuilder(string);
        UrlUtils.replace(buffer, from, to);
        return buffer.toString();
    }

    public static void replace(StringBuilder buffer, String from, String to) {
        int index = 0;
        while ((index = buffer.indexOf(from, index)) != -1) {
            buffer = buffer.replace(index, index + from.length(), to);
            index = index - from.length() + to.length() + 1;
        }
    }

    static int indexOf(CharSequence source, int sourceOffset, int sourceCount, CharSequence target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target.charAt(targetOffset);
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source.charAt(i) != first) {
                while (++i <= max && source.charAt(i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source.charAt(j) == target.charAt(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public static int indexOf(CharSequence string, CharSequence substring, int fromIndex, int toIndex) {
        return UrlUtils.indexOf(string, 0, toIndex, substring, 0, substring.length(), fromIndex);
    }

    public static String removeLastSlash(String pageUrl) {
        String processed = pageUrl.trim();
        if (processed.endsWith(SLASH)) {
            processed = StringUtils.chop(processed);
        }
        return processed;
    }

    public static String removeSchemaAndWww(String url) {
        return (url = url.replaceFirst("^(\\s*https?://)", EMPTY_STRING)).toLowerCase().startsWith(PREFIX_WWW) ? url.substring(PREFIX_WWW.length()) : url;
    }

    public static boolean isSiteUrlEqual(String url1, String url2) {
        return UrlUtils.removeSchemaAndWww(UrlUtils.removeLastSlash(url1)).equals(UrlUtils.removeSchemaAndWww(UrlUtils.removeLastSlash(url2)));
    }

    public static String encodeUrl(String url) {
        String encodedUrl = url;
        if (!UrlUtils.isASCIIOnlyUrlDomain(url)) {
            encodedUrl = UrlUtils.getASCIIConvertedUrlDomain(url);
        }
        String path = UrlUtils.getPathAndQuery(encodedUrl);
        return encodedUrl.replaceFirst(Pattern.quote(path), Matcher.quoteReplacement(UrlUtils.encodeToHex(path)));
    }

    public static String encodeToHex(String path) {
        if (path == null) {
            return path;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (UrlUtils.containsUrlChar(c)) {
                builder.append(c);
                continue;
            }
            if (c == ' ') {
                for (byte b : " ".getBytes(UTF8_CHARSET)) {
                    builder.append('%');
                    char ch = Character.forDigit(b >> 4 & 0xF, 16);
                    if (Character.isLetter(ch)) {
                        ch = (char)(ch - 32);
                    }
                    builder.append(ch);
                    ch = Character.forDigit(b & 0xF, 16);
                    if (Character.isLetter(ch)) {
                        ch = (char)(ch - 32);
                    }
                    builder.append(ch);
                }
                continue;
            }
            try {
                builder.append(URLEncoder.encode(String.valueOf(c), UTF8_CHARSET.name()));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return builder.toString();
    }

    private static boolean containsUrlChar(char c) {
        for (char sb : URL_SYMBOLS) {
            if (c != sb) continue;
            return true;
        }
        return false;
    }

    public static String removeAnchor(String url) {
        if (StringUtils.isEmpty(url)) {
            return url;
        }
        int anchorIndex = url.indexOf(ANCHOR);
        return anchorIndex != -1 ? url.substring(0, anchorIndex) : url;
    }

    public static String removeParams(String url) {
        if (StringUtils.isEmpty(url)) {
            return url;
        }
        int paramsIndex = url.indexOf(PARAM);
        return paramsIndex != -1 ? url.substring(0, paramsIndex) : url;
    }

    public static boolean isAnchorUrl(String url) {
        return !StringUtils.isEmpty(url) && url.contains(ANCHOR);
    }

    public static boolean isLinkBroken(Integer httpResponseCode) {
        return httpResponseCode == null || httpResponseCode >= 400 && httpResponseCode < 600 || httpResponseCode < 1;
    }

    public static long hashCode(String url) {
        if (StringUtils.isEmpty(url)) {
            return 0L;
        }
        int p = 37;
        long hash = 1L;
        for (int i = 0; i < url.length(); ++i) {
            hash = 37L * hash + (long)url.charAt(i);
        }
        return hash;
    }

    public static long[] hashCodes(Collection<String> urls) {
        if (CollectionUtils.isEmpty(urls)) {
            return null;
        }
        long[] result = new long[urls.size()];
        int i = 0;
        for (String url : urls) {
            result[i++] = UrlUtils.hashCode(url);
        }
        return result;
    }

    public static String fixUrl(String url) {
        if (UrlUtils.isEmpty(url)) {
            return url;
        }
        if (UrlUtils.isOnlySchema(url)) {
            return url.toLowerCase();
        }
        String result = UrlUtils.addMissingSchema(url.trim());
        result = UrlUtils.addMissingSlashAfterDomain(result);
        result = UrlUtils.domainToLowerCase(result);
        result = UrlUtils.replaceDots(result);
        return UrlUtils.removeDefaultPorts(result);
    }

    private static String replaceDots(String input) {
        int p = 0;
        int q = 0;
        StringBuilder out = new StringBuilder();
        while (p < input.length()) {
            q = UrlUtils.searchDots(input, p);
            out.append(input.substring(p, q));
            p = q + 1;
            if (p >= input.length()) continue;
            out.append('.');
        }
        return out.toString();
    }

    private static int searchDots(String s, int start) {
        char c;
        int i;
        for (i = start; i < s.length() && (c = s.charAt(i)) != '.' && c != '\u3002' && c != '\uff0e' && c != '\uff61'; ++i) {
        }
        return i;
    }

    private static boolean isOnlySchema(String url) {
        String urlToLower = url.toLowerCase();
        return SCHEME_HTTP.equals(urlToLower) || SCHEME_HTTPS.equals(urlToLower);
    }

    private static String addMissingSchema(String url) {
        String urlToLower = url.toLowerCase();
        if (urlToLower.indexOf(SCHEME_HTTP) != 0 && urlToLower.indexOf(SCHEME_HTTPS) != 0) {
            return SCHEME_HTTP + url;
        }
        return url;
    }

    private static String addMissingSlashAfterDomain(String url) {
        if (url.length() == 0 || UrlUtils.isOnlySchema(url)) {
            return url;
        }
        int slashIndex = url.length();
        int anchorIndex = url.indexOf(ANCHOR);
        int paramIndex = url.indexOf(PARAM);
        if (anchorIndex != -1 && paramIndex != -1) {
            slashIndex = paramIndex < anchorIndex ? paramIndex : anchorIndex;
        } else if (paramIndex != -1) {
            slashIndex = paramIndex;
        } else if (anchorIndex != -1) {
            slashIndex = anchorIndex;
        }
        int firstSlashIndex = url.indexOf(SLASH, UrlUtils.getSchema(url).length());
        if (firstSlashIndex != -1 && firstSlashIndex <= slashIndex) {
            return url;
        }
        return url.substring(0, slashIndex) + SLASH + url.substring(slashIndex);
    }

    private static String domainToLowerCase(String url) {
        int slashIndex = url.indexOf(SLASH, UrlUtils.getSchema(url).length());
        if (slashIndex > -1) {
            return url.substring(0, slashIndex).toLowerCase() + url.substring(slashIndex);
        }
        return url.toLowerCase();
    }

    private static String getSchema(String url) {
        String urlToLower = url.toLowerCase();
        if (urlToLower.startsWith(SCHEME_HTTP)) {
            return SCHEME_HTTP;
        }
        if (urlToLower.startsWith(SCHEME_HTTPS)) {
            return SCHEME_HTTPS;
        }
        throw new IllegalArgumentException(String.format("Url %s doesn`t contains schema", url));
    }

    public static String removeDefaultPorts(String url) {
        if (UrlUtils.isEmpty(url)) {
            return url;
        }
        String lowerUrl = url.toLowerCase();
        String scheme = lowerUrl.startsWith(SCHEME_HTTP) ? SCHEME_HTTP : (lowerUrl.startsWith(SCHEME_HTTPS) ? SCHEME_HTTPS : EMPTY_STRING);
        String tempUrl = url.substring(scheme.length());
        if (!tempUrl.contains(COLON)) {
            return url;
        }
        int domainEndIndex = tempUrl.length();
        int anchorIndex = tempUrl.indexOf(ANCHOR);
        int paramIndex = tempUrl.indexOf(PARAM);
        if (anchorIndex != -1 && paramIndex != -1) {
            domainEndIndex = paramIndex < anchorIndex ? paramIndex : anchorIndex;
        } else if (paramIndex != -1) {
            domainEndIndex = paramIndex;
        } else if (anchorIndex != -1) {
            domainEndIndex = anchorIndex;
        }
        int firstSlashIndex = tempUrl.indexOf(SLASH);
        if (firstSlashIndex != -1 && firstSlashIndex <= domainEndIndex) {
            domainEndIndex = firstSlashIndex;
        }
        if (!(tempUrl = tempUrl.substring(0, domainEndIndex)).contains(COLON)) {
            return url;
        }
        int colonIndex = tempUrl.indexOf(COLON);
        String port = tempUrl.substring(colonIndex + 1);
        if (scheme.equals(SCHEME_HTTP) && port.equals(HTTP_DEFAULT_PORT) || scheme.equals(SCHEME_HTTPS) && port.equals(HTTPS_DEFAULT_PORT)) {
            url = url.replaceFirst(COLON + port, EMPTY_STRING);
        }
        return url;
    }

    public static boolean isDynamicUrl(String url) {
        if (url == null || url.isEmpty()) {
            return false;
        }
        String[] urlParts = url.split(ANCHOR, 2);
        String clippedUrl = urlParts[0];
        Pattern pattern = Pattern.compile("\\?");
        Matcher matcher = pattern.matcher(clippedUrl);
        return matcher.find();
    }

    public static String decodeUrlUTF8(String url) {
        return UrlUtils.decodeUrl(url, UTF8_CHARSET.name());
    }

    public static String decodeUrl(String url, String enc) {
        String decodedUrl = UrlUtils.getUnicodeConvertedUrlDomain(url);
        String path = UrlUtils.getPathAndQuery(decodedUrl);
        decodedUrl = decodedUrl.replaceFirst(Pattern.quote(path), Matcher.quoteReplacement(UrlUtils.decodeUrlPath(path, enc)));
        return decodedUrl;
    }

    public static String decodeUrlPathUTF8(String s) {
        return UrlUtils.decodeUrlPath(s, UTF8_CHARSET);
    }

    public static String decodeUrlPath(String s, String enc) {
        Charset charset = Charset.forName(enc);
        return UrlUtils.decodeUrlPath(s, charset);
    }

    public static String decodeUrlPath(String s, Charset charset) {
        int percentIndex = s.indexOf(37);
        if (percentIndex == -1) {
            return s;
        }
        int numChars = s.length();
        StringBuilder sb = new StringBuilder(numChars > 500 ? numChars / 2 : numChars);
        byte[] bytes = null;
        int i = 0;
        block3: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '%': {
                    if (bytes == null) {
                        bytes = new byte[(numChars - i) / 3];
                    }
                    int pos = 0;
                    while (i + 2 < numChars && c == '%') {
                        byte val;
                        if ((val = UrlUtils.fromHex(s, ++i)) != 0) {
                            bytes[pos++] = val;
                        }
                        if ((i += 2) >= numChars) continue;
                        c = s.charAt(i);
                    }
                    if (i < numChars && c == '%') {
                        throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                    }
                    sb.append(new String(bytes, 0, pos, charset));
                    continue block3;
                }
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    static byte fromHex(String s, int i) {
        return (byte)(UrlUtils.fromHex(s.charAt(i)) << 4 | UrlUtils.fromHex(s.charAt(i + 1)));
    }

    static byte fromHex(char ch) {
        if (ch >= '0' && ch <= '9') {
            return (byte)(ch - 48);
        }
        if (ch >= 'A' && ch <= 'F') {
            return (byte)(ch - 65 + 10);
        }
        if (ch >= 'a' && ch <= 'f') {
            return (byte)(ch - 97 + 10);
        }
        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern");
    }

    public static boolean isAllASCII(String input) {
        boolean isASCII = true;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c <= '\u007f') continue;
            isASCII = false;
            break;
        }
        return isASCII;
    }
}

