/*
 * Decompiled with CFR 0.152.
 */
package prclient.hidden.gnu.inet.encoding;

import prclient.hidden.gnu.inet.encoding.PunycodeException;

public class Punycode {
    static final int TMIN = 1;
    static final int TMAX = 26;
    static final int BASE = 36;
    static final int INITIAL_N = 128;
    static final int INITIAL_BIAS = 72;
    static final int DAMP = 700;
    static final int SKEW = 38;
    static final char DELIMITER = '-';

    public static String encode(String string) throws PunycodeException {
        int n;
        int n2;
        int n3 = 128;
        int n4 = 0;
        int n5 = 72;
        StringBuilder stringBuilder = new StringBuilder();
        int n6 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            n = string.charAt(n2);
            if (!Punycode.isBasic((char)n)) continue;
            stringBuilder.append((char)n);
            ++n6;
        }
        if (n6 > 0) {
            stringBuilder.append('-');
        }
        n2 = n6;
        while (n2 < string.length()) {
            int n7;
            int n8;
            n = Integer.MAX_VALUE;
            for (n8 = 0; n8 < string.length(); ++n8) {
                n7 = string.charAt(n8);
                if (n7 < n3 || n7 >= n) continue;
                n = n7;
            }
            if (n - n3 > (Integer.MAX_VALUE - n4) / (n2 + 1)) {
                throw new PunycodeException(PunycodeException.OVERFLOW);
            }
            n4 += (n - n3) * (n2 + 1);
            n3 = n;
            for (n8 = 0; n8 < string.length(); ++n8) {
                int n9;
                n7 = string.charAt(n8);
                if (n7 < n3 && 0 == ++n4) {
                    throw new PunycodeException(PunycodeException.OVERFLOW);
                }
                if (n7 != n3) continue;
                int n10 = n4;
                int n11 = 36;
                while (n10 >= (n9 = n11 <= n5 ? 1 : (n11 >= n5 + 26 ? 26 : n11 - n5))) {
                    stringBuilder.append((char)Punycode.digit2codepoint(n9 + (n10 - n9) % (36 - n9)));
                    n10 = (n10 - n9) / (36 - n9);
                    n11 += 36;
                }
                stringBuilder.append((char)Punycode.digit2codepoint(n10));
                n5 = Punycode.adapt(n4, n2 + 1, n2 == n6);
                n4 = 0;
                ++n2;
            }
            ++n4;
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static String decode(String string) throws PunycodeException {
        int n;
        int n2;
        int n3 = 128;
        int n4 = 0;
        int n5 = 72;
        StringBuilder stringBuilder = new StringBuilder();
        int n6 = string.lastIndexOf(45);
        if (n6 > 0) {
            for (n2 = 0; n2 < n6; ++n2) {
                n = string.charAt(n2);
                if (!Punycode.isBasic((char)n)) {
                    throw new PunycodeException(PunycodeException.BAD_INPUT);
                }
                stringBuilder.append((char)n);
            }
            ++n6;
        } else {
            n6 = 0;
        }
        while (n6 < string.length()) {
            n2 = n4;
            n = 1;
            int n7 = 36;
            while (true) {
                char c;
                int n8;
                if (n6 == string.length()) {
                    throw new PunycodeException(PunycodeException.BAD_INPUT);
                }
                if ((n8 = Punycode.codepoint2digit(c = string.charAt(n6++))) > (Integer.MAX_VALUE - n4) / n) {
                    throw new PunycodeException(PunycodeException.OVERFLOW);
                }
                n4 += n8 * n;
                int n9 = n7 <= n5 ? 1 : (n7 >= n5 + 26 ? 26 : n7 - n5);
                if (n8 < n9) break;
                n *= 36 - n9;
                n7 += 36;
            }
            n5 = Punycode.adapt(n4 - n2, stringBuilder.length() + 1, n2 == 0);
            if (n4 / (stringBuilder.length() + 1) > Integer.MAX_VALUE - n3) {
                throw new PunycodeException(PunycodeException.OVERFLOW);
            }
            n3 += n4 / (stringBuilder.length() + 1);
            stringBuilder.insert(n4 %= stringBuilder.length() + 1, (char)n3);
            ++n4;
        }
        return stringBuilder.toString();
    }

    public static final int adapt(int n, int n2, boolean bl) {
        n = bl ? (n /= 700) : (n /= 2);
        n += n / n2;
        int n3 = 0;
        while (n > 455) {
            n /= 35;
            n3 += 36;
        }
        return n3 + 36 * n / (n + 38);
    }

    public static final boolean isBasic(char c) {
        return c < '\u0080';
    }

    public static final int digit2codepoint(int n) throws PunycodeException {
        if (n < 26) {
            return n + 97;
        }
        if (n < 36) {
            return n - 26 + 48;
        }
        throw new PunycodeException(PunycodeException.BAD_INPUT);
    }

    public static final int codepoint2digit(int n) throws PunycodeException {
        if (n - 48 < 10) {
            return n - 48 + 26;
        }
        if (n - 97 < 26) {
            return n - 97;
        }
        throw new PunycodeException(PunycodeException.BAD_INPUT);
    }
}

