/*
 * Decompiled with CFR 0.152.
 */
package prclient.hidden.gnu.inet.encoding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public final class RangeSet {
    private static final RangeContainsComparator CONTAINS_COMPARATOR = new RangeContainsComparator();
    private final Range[] ranges;
    private final Range mostSignificantGap;

    private RangeSet(List<Range> list) {
        this.ranges = list.toArray(new Range[list.size()]);
        this.mostSignificantGap = RangeSet.findMostSignificantGap(this.ranges);
    }

    private static Range findMostSignificantGap(Range[] rangeArray) {
        if (rangeArray.length == 0) {
            return new Range(0, Integer.MAX_VALUE);
        }
        int n = Arrays.binarySearch(rangeArray, new Range(97), CONTAINS_COMPARATOR);
        if (n >= 0) {
            return null;
        }
        int n2 = -(n + 1);
        if (n2 == 0) {
            return new Range(0, rangeArray[0].first - 1);
        }
        if (n2 == rangeArray.length) {
            return new Range(rangeArray[rangeArray.length - 1].last + 1, Integer.MAX_VALUE);
        }
        return new Range(rangeArray[n2 - 1].last + 1, rangeArray[n2].first - 1);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean contains(int n) {
        if (this.mostSignificantGap != null && this.mostSignificantGap.contains(n)) {
            return false;
        }
        Range range = new Range(n);
        int n2 = Arrays.binarySearch(this.ranges, range, CONTAINS_COMPARATOR);
        return n2 >= 0;
    }

    public boolean containsAnyCodePoint(CharSequence charSequence) {
        Range range = RangeSet.createTextRange(charSequence);
        return this.containsAnyCodePoint(charSequence, range);
    }

    public boolean containsAnyCodePoint(CharSequence charSequence, Range range) {
        int n;
        int n2 = charSequence.length();
        if (n2 == 0) {
            return false;
        }
        if (this.mostSignificantGap != null && this.mostSignificantGap.contains(range.first) && this.mostSignificantGap.contains(range.last)) {
            return false;
        }
        int n3 = Arrays.binarySearch(this.ranges, new Range(range.last), CONTAINS_COMPARATOR);
        int n4 = n3 >= 0 ? n3 + 1 : -(n3 + 1);
        int n5 = Arrays.binarySearch(this.ranges, 0, n4, new Range(range.first), CONTAINS_COMPARATOR);
        if (n5 == n3) {
            return n5 >= 0;
        }
        if (n5 >= 0 || n3 >= 0) {
            return true;
        }
        int n6 = -n5 + 1;
        int n7 = -n3 + 1;
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = Character.codePointAt(charSequence, i);
            int n8 = Arrays.binarySearch(this.ranges, n6, n7, new Range(n), CONTAINS_COMPARATOR);
            if (n8 <= 0) continue;
            return true;
        }
        return false;
    }

    public static Range createTextRange(CharSequence charSequence) {
        int n;
        int n2 = charSequence.length();
        if (n2 == 0) {
            return new Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = Character.codePointAt(charSequence, i);
            n3 = Math.min(n3, n);
            n4 = Math.max(n4, n);
        }
        return new Range(n3, n4);
    }

    public String toString() {
        return "RangeSet{ranges=" + Arrays.asList(this.ranges) + ", mostSignificantGap=" + this.mostSignificantGap + '}';
    }

    public static final class Builder {
        private final List<Range> ranges = new ArrayList<Range>();

        public Builder addRange(Range range) {
            this.ranges.add(range);
            return this;
        }

        public Builder addRanges(Collection<Range> collection) {
            collection.addAll(collection);
            return this;
        }

        public Builder addRanges(char[][] cArray) {
            for (char[] cArray2 : cArray) {
                if (cArray2.length == 1) {
                    this.ranges.add(new Range(cArray2[0]));
                    continue;
                }
                if (cArray2.length == 2) {
                    this.ranges.add(new Range(cArray2[0], cArray2[1]));
                    continue;
                }
                throw new IllegalArgumentException("Unexpected range len:" + cArray2.length);
            }
            return this;
        }

        public Builder addRanges(char[] cArray) {
            for (char c : cArray) {
                this.ranges.add(new Range(c));
            }
            return this;
        }

        public RangeSet build() {
            Collections.sort(this.ranges);
            List<Range> list = Builder.mergeRanges(this.ranges);
            return new RangeSet(list);
        }

        static List<Range> mergeRanges(List<Range> list) {
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Range> arrayList = new ArrayList<Range>();
            Iterator<Range> iterator = list.iterator();
            Range range = iterator.next();
            List<Range> list2 = Collections.singletonList(range);
            while (iterator.hasNext()) {
                while (list2.size() == 1 && iterator.hasNext()) {
                    range = list2.get(0);
                    Range range2 = iterator.next();
                    list2 = Builder.mergeRanges(range, range2);
                }
                if (list2.size() <= 1) continue;
                arrayList.addAll(list2.subList(0, list2.size() - 1));
                list2 = Collections.singletonList(list2.get(list2.size() - 1));
            }
            arrayList.addAll(list2);
            return arrayList;
        }

        static List<Range> mergeRanges(Range range, Range range2) {
            if (range.last + 1 >= range2.first) {
                int n = Math.max(range2.last, range.last);
                return Collections.singletonList(new Range(range.first, n));
            }
            ArrayList<Range> arrayList = new ArrayList<Range>(2);
            arrayList.add(range);
            arrayList.add(range2);
            return arrayList;
        }
    }

    private static class RangeContainsComparator
    implements Comparator<Range> {
        private RangeContainsComparator() {
        }

        @Override
        public int compare(Range range, Range range2) {
            if (range.last < range2.first) {
                return -1;
            }
            if (range2.last < range.first) {
                return 1;
            }
            return 0;
        }
    }

    public static final class Range
    implements Comparable<Range> {
        private final int first;
        private final int last;

        public Range(int n, int n2) {
            if (n > n2) {
                throw new IllegalArgumentException("Reversed " + n + "-" + n2);
            }
            this.first = n;
            this.last = n2;
        }

        public Range(int n) {
            this.first = n;
            this.last = n;
        }

        public Range(Range range, Range range2) {
            if (range.first > range2.first) {
                throw new IllegalArgumentException(range + " starts later than " + range2);
            }
            if (range2.first - range.last > 1) {
                throw new IllegalArgumentException("Disjunct " + range + " - " + range2);
            }
            this.first = range.first;
            this.last = range2.last;
        }

        public boolean contains(int n) {
            return this.first <= n && n <= this.last;
        }

        public boolean contains(Range range) {
            return this.first <= range.first && range.last <= this.last;
        }

        public String toString() {
            return "[" + Integer.toHexString(this.first).toUpperCase(Locale.ENGLISH) + "," + Integer.toHexString(this.last).toUpperCase(Locale.ENGLISH) + ']';
        }

        @Override
        public int compareTo(Range range) {
            if (this.first < range.first) {
                return -1;
            }
            if (this.first > range.first) {
                return 1;
            }
            if (this.last < range.last) {
                return -1;
            }
            if (this.last > range.last) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Range range = (Range)object;
            if (this.first != range.first) {
                return false;
            }
            return this.last == range.last;
        }

        public int hashCode() {
            return 31 * this.first + this.last;
        }
    }
}

