/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.ico;

import com.twelvemonkeys.imageio.plugins.ico.DIBHeader;
import com.twelvemonkeys.imageio.plugins.ico.DirectoryEntry;
import com.twelvemonkeys.lang.Validate;
import java.awt.image.BufferedImage;

abstract class BitmapDescriptor {
    protected final DirectoryEntry mEntry;
    protected final DIBHeader mHeader;
    protected BufferedImage mImage;

    public BitmapDescriptor(DirectoryEntry pEntry, DIBHeader pHeader) {
        Validate.notNull((Object)pEntry, (String)"entry");
        Validate.notNull((Object)pHeader, (String)"header");
        this.mEntry = pEntry;
        this.mHeader = pHeader;
    }

    public abstract BufferedImage getImage();

    public final int getWidth() {
        return this.mEntry.getWidth();
    }

    public final int getHeight() {
        return this.mEntry.getHeight();
    }

    protected final int getColorCount() {
        return this.mEntry.getColorCount() != 0 ? this.mEntry.getColorCount() : 1 << this.getBitCount();
    }

    protected final int getBitCount() {
        return this.mEntry.getBitCount() != 0 ? this.mEntry.getBitCount() : this.mHeader.getBitCount();
    }
}

