/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.ico;

import com.twelvemonkeys.imageio.plugins.ico.DirectoryEntry;
import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

class Directory {
    private final List<DirectoryEntry> mEntries;

    private Directory(int pImageCount) {
        this.mEntries = Arrays.asList(new DirectoryEntry[pImageCount]);
    }

    public static Directory read(int pType, int pImageCount, DataInput pStream) throws IOException {
        Directory directory = new Directory(pImageCount);
        directory.readEntries(pType, pStream);
        return directory;
    }

    private void readEntries(int pType, DataInput pStream) throws IOException {
        for (int i = 0; i < this.mEntries.size(); ++i) {
            this.mEntries.set(i, DirectoryEntry.read(pType, pStream));
        }
    }

    public DirectoryEntry getEntry(int pEntryIndex) {
        return this.mEntries.get(pEntryIndex);
    }

    public int count() {
        return this.mEntries.size();
    }

    public String toString() {
        return String.format("%s%s", this.getClass().getSimpleName(), this.mEntries);
    }
}

