/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.ico;

import java.awt.Point;
import java.io.DataInput;
import java.io.IOException;
import javax.imageio.IIOException;

abstract class DirectoryEntry {
    private int mWidth;
    private int mHeight;
    private int mColorCount;
    int mPlanes;
    int mBitCount;
    private int mSize;
    private int mOffset;

    private DirectoryEntry() {
    }

    public static DirectoryEntry read(int pType, DataInput pStream) throws IOException {
        DirectoryEntry entry = DirectoryEntry.createEntry(pType);
        entry.read(pStream);
        return entry;
    }

    private static DirectoryEntry createEntry(int pType) throws IIOException {
        switch (pType) {
            case 1: {
                return new ICOEntry();
            }
            case 2: {
                return new CUREntry();
            }
        }
        throw new IIOException(String.format("Unknown DIB type: %s, expected: %s (ICO) or %s (CUR)", pType, 1, 2));
    }

    protected void read(DataInput pStream) throws IOException {
        int w = pStream.readUnsignedByte();
        this.mWidth = w == 0 ? 256 : w;
        int h = pStream.readUnsignedByte();
        this.mHeight = h == 0 ? 256 : h;
        this.mColorCount = pStream.readUnsignedByte();
        pStream.readUnsignedByte();
        this.mPlanes = pStream.readUnsignedShort();
        this.mBitCount = pStream.readUnsignedShort();
        this.mSize = pStream.readInt();
        this.mOffset = pStream.readInt();
    }

    public String toString() {
        return String.format("%s: width: %d, height: %d, colors: %d, planes: %d, bit count: %d, size: %d, offset: %d", this.getClass().getSimpleName(), this.mWidth, this.mHeight, this.mColorCount, this.mPlanes, this.mBitCount, this.mSize, this.mOffset);
    }

    public int getBitCount() {
        return this.mBitCount;
    }

    public int getColorCount() {
        return this.mColorCount;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public int getPlanes() {
        return this.mPlanes;
    }

    public int getSize() {
        return this.mSize;
    }

    public int getWidth() {
        return this.mWidth;
    }

    static final class ICOEntry
    extends DirectoryEntry {
        ICOEntry() {
        }
    }

    static class CUREntry
    extends DirectoryEntry {
        private int mXHotspot;
        private int mYHotspot;

        CUREntry() {
        }

        protected void read(DataInput pStream) throws IOException {
            super.read(pStream);
            this.mXHotspot = this.mPlanes;
            this.mYHotspot = this.mBitCount;
            this.mPlanes = 1;
            this.mBitCount = 0;
        }

        public Point getHotspot() {
            return new Point(this.mXHotspot, this.mYHotspot);
        }
    }
}

