/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.ico;

import com.twelvemonkeys.imageio.plugins.ico.ICOImageReader;
import com.twelvemonkeys.imageio.spi.ProviderInfo;
import com.twelvemonkeys.imageio.util.IIOUtil;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class ICOImageReaderSpi
extends ImageReaderSpi {
    public ICOImageReaderSpi() {
        this(IIOUtil.getProviderInfo(ICOImageReaderSpi.class));
    }

    private ICOImageReaderSpi(ProviderInfo pProviderInfo) {
        super(pProviderInfo.getVendorName(), pProviderInfo.getVersion(), new String[]{"ico", "ICO"}, new String[]{"ico"}, new String[]{"image/vnd.microsoft.icon", "image/x-icon", "image/ico"}, "com.twelvemonkeys.imageio.plugins.ico.ICOImageReader", STANDARD_INPUT_TYPE, null, true, null, null, null, null, true, null, null, null, null);
    }

    public boolean canDecodeInput(Object pSource) throws IOException {
        return pSource instanceof ImageInputStream && ICOImageReaderSpi.canDecode((ImageInputStream)pSource, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean canDecode(ImageInputStream pInput, int pType) throws IOException {
        byte[] signature = new byte[4];
        try {
            pInput.mark();
            pInput.readFully(signature);
            int count = pInput.readByte() + (pInput.readByte() << 8);
            boolean bl = signature[0] == 0 && signature[1] == 0 && signature[2] == pType && signature[3] == 0 && count > 0;
            return bl;
        }
        finally {
            pInput.reset();
        }
    }

    public ImageReader createReaderInstance(Object pExtension) throws IOException {
        return new ICOImageReader(this);
    }

    public String getDescription(Locale pLocale) {
        return "Windows Icon Format (ICO) Reader";
    }
}

