/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.spyglass.backlinksummary.data;

import com.agilemind.commons.application.modules.io.searchengine.data.PopularityHistoryMap;
import com.agilemind.commons.application.modules.io.searchengine.data.api.ISearchEngineFactor;
import com.agilemind.commons.application.modules.widget.util.to.AnchorAltTextResult;
import com.agilemind.commons.application.modules.widget.util.to.AnchorUrlResult;
import com.agilemind.commons.application.modules.widget.util.to.analyze.CountryResult;
import com.agilemind.commons.application.modules.widget.util.to.analyze.DofollowNofollowDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.HomepageLinksDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.TLDResult;
import com.agilemind.commons.application.modules.widget.util.to.analyze.TextImageDistribution;
import com.agilemind.commons.io.utils.BinaryFile;
import com.agilemind.commons.util.DateUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.Util;
import com.agilemind.factors.SearchEngineFactorType;
import com.agilemind.factors.SearchEngineFactorsList;
import com.agilemind.factors.data.PageInfo;
import com.agilemind.spyglass.data.SpyGlassProject;
import com.agilemind.spyglass.data.util.StatisticsMode;
import com.agilemind.spyglass.util.SpyGlassStringKey;
import com.agilemind.spyglass.util.statistics.StatisticsService;
import com.agilemind.spyglass.util.statistics.StatisticsServiceFactoryImpl;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.NavigableMap;

public class BackLinksSummarySettings {
    public static final int CHART_RANGE_IN_DAYS = 180;
    private final SpyGlassProject a;
    private final File b;
    private final StatisticsService c;
    public static boolean d;

    public BackLinksSummarySettings(SpyGlassProject spyGlassProject, File file) {
        boolean bl = d;
        this.a = spyGlassProject;
        this.b = file;
        this.c = StatisticsServiceFactoryImpl.getStatisticsService(spyGlassProject, spyGlassProject.getStatisticsMode());
        if (bl) {
            SpyGlassStringKey.b = !SpyGlassStringKey.b;
        }
    }

    public boolean hasStatistics() {
        return this.c.hasStatistics();
    }

    public File getRootFolder() {
        return this.b;
    }

    public StatisticsMode getStatisticMode() {
        return this.a.getStatisticsMode();
    }

    public BinaryFile getFavicon() {
        return this.a.getDomainFavicon();
    }

    public UnicodeURL getProjectUrl() {
        return this.a.getProjectUrl();
    }

    public String getProjectTitle() {
        ISearchEngineFactor iSearchEngineFactor = this.getFactor(SearchEngineFactorsList.EXTRA_PAGE_INFO_FACTOR_TYPE);
        if (iSearchEngineFactor == null) {
            return null;
        }
        PageInfo pageInfo = (PageInfo)iSearchEngineFactor.getFactorValue();
        return pageInfo.getTitle();
    }

    public Date getReportDate() {
        return this.c.getRebuildDate();
    }

    public <T extends Comparable<T>> ISearchEngineFactor<T> getFactor(SearchEngineFactorType<T> searchEngineFactorType) {
        PopularityHistoryMap popularityHistoryMap = this.a.getPopularityHistoryMap();
        return popularityHistoryMap.getFactor(searchEngineFactorType);
    }

    public List<AnchorAltTextResult> getPagesTopAnchorTexts() {
        return this.c.getTopBacklinksAnchorTexts(false);
    }

    public List<TLDResult> getTopTLDs() {
        return this.c.getTopTLDs();
    }

    public HomepageLinksDistribution getToHomepageVsToOtherPagesBacklinks() {
        return this.c.getToHomepageVsToOtherPagesBacklinks();
    }

    public List<CountryResult> getTopCountries() {
        return this.c.getTopCountries();
    }

    public int getTotalBacklinksCount() {
        return this.c.getTotalBacklinksCount();
    }

    public int getTotalLinkingDomainsCount() {
        return this.c.getTotalLinkingDomainsCount();
    }

    public int getTotalIpsCount() {
        return this.c.getTotalIpsCount();
    }

    public TextImageDistribution getTextVsImageBacklinks() {
        return this.c.getTextVsImageBacklinks();
    }

    public double getDiversity() {
        return this.getTotalLinkingDomainsCount() == 0 ? 0.0 : (double)this.getTotalAnchorTexts() / (double)this.getTotalBacklinksCount();
    }

    public int getTotalAnchorTexts() {
        return this.c.getTotalAnchorTexts();
    }

    public int getTotalAnchorUrls() {
        return this.c.getTotalAnchorUrls();
    }

    public int getTotalCBlocksCount() {
        return this.c.getTotalCBlocksCount();
    }

    public List<AnchorAltTextResult> getTopBacklinksAnchorTexts() {
        return Util.subList(this.c.getTopBacklinksAnchorTexts(true), (int)5);
    }

    public List<AnchorAltTextResult> getTopBacklinksAnchorsIgnoreType() {
        return Util.subList(this.c.getTopBacklinksAnchorTexts(false), (int)50);
    }

    public List<AnchorUrlResult> getTopBacklinkAnchorUrls() {
        return Util.subList(this.c.getTopBacklinkAnchorUrls(), (int)5);
    }

    public int getTotalDofollowDomainsCount() {
        return this.c.getTotalDofollowDomainsCount();
    }

    public List<AnchorAltTextResult> getTopLinkingDomainsAnchorTexts() {
        return Util.subList(this.c.getTopLinkingDomainsAnchorTexts(), (int)5);
    }

    public DofollowNofollowDistribution getDofollowVsNofollowBacklinks() {
        return this.c.getDofollowVsNofollowBacklinks();
    }

    public List<AnchorUrlResult> getTopLinkingDomainsAnchorUrls() {
        return Util.subList(this.c.getTopLinkingDomainsAnchorUrls(), (int)5);
    }

    public NavigableMap<Date, Integer> getTotalBacklinksHistory() {
        return this.c.getTotalBacklinksHistory(DateUtil.moveDay((Date)this.getReportDate(), (int)-180), this.getReportDate());
    }

    public HomepageLinksDistribution getFromHomepageVsOtherPagesLinkingDomains() {
        return this.c.getFromHomepageVsFromOtherPagesLinkingDomains();
    }

    public NavigableMap<Date, Integer> getTotalLinkingDomainsHistory() {
        boolean bl = d;
        NavigableMap<Date, Integer> navigableMap = this.c.getTotalLinkingDomainsHistory(DateUtil.moveDay((Date)this.getReportDate(), (int)-180), this.getReportDate());
        if (SpyGlassStringKey.b) {
            d = !bl;
        }
        return navigableMap;
    }
}

