/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.spyglass.data.util;

import com.agilemind.commons.application.data.record.FactorStorage;
import com.agilemind.commons.application.modules.io.searchengine.data.api.ISearchEngineFactor;
import com.agilemind.commons.data.field.Age;
import com.agilemind.commons.io.searchengine.validator.ILinkInfo;
import com.agilemind.commons.io.searchengine.validator.scanstatus.ScanStatus;
import com.agilemind.commons.io.utils.FilterSiteWithResourcePages;
import com.agilemind.commons.io.utils.ip.data.IP;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLUtil;
import com.agilemind.factors.FactorType;
import com.agilemind.factors.IFactorParser;
import com.agilemind.factors.SearchEngineFactorType;
import com.agilemind.factors.SearchEngineFactorsList;
import com.agilemind.spyglass.data.api.LinkRiskSource;
import com.agilemind.spyglass.data.util.LinkRisk;
import com.agilemind.spyglass.data.util.LinkRiskCache;
import com.agilemind.spyglass.data.util.LinkRiskRule;
import com.agilemind.spyglass.data.util.StatisticsMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public class LinkRiskUtils {
    private static final String a;

    private LinkRiskUtils() {
    }

    public static LinkRisk getLinkRisk(LinkRiskSource linkRiskSource, LinkRiskCache linkRiskCache) {
        ScanStatus scanStatus = linkRiskSource.getScanStatus();
        if (scanStatus == ScanStatus.SCAN_STATUS_CHEATING_NOFOLLOW) {
            return new LinkRisk(Collections.singleton(LinkRiskRule.LINK_IS_NOFOLLOW));
        }
        if (scanStatus == null || !scanStatus.isOkStatus()) {
            return new LinkRisk(Collections.singleton(LinkRiskRule.NO_LINK_BACK));
        }
        return LinkRiskUtils.a(linkRiskSource, linkRiskCache, linkRiskCache.getSize());
    }

    private static LinkRisk a(LinkRiskSource linkRiskSource, LinkRiskCache linkRiskCache, int n2) {
        List<SearchEngineFactorType<?>> list = LinkRiskUtils.a(linkRiskSource);
        if (list.isEmpty()) {
            return LinkRiskUtils.b(linkRiskSource, linkRiskCache, n2);
        }
        LinkRisk linkRisk = LinkRisk.createNotCalculatedLinkRisk();
        linkRisk.setSearchEngineTypes(list);
        return linkRisk;
    }

    private static List<SearchEngineFactorType<?>> a(LinkRiskSource linkRiskSource) {
        ArrayList arrayList = new ArrayList();
        ScanStatus scanStatus = linkRiskSource.getScanStatus();
        if (scanStatus == ScanStatus.SCAN_STATUS_UNKNOWN) {
            arrayList.add(SearchEngineFactorsList.EXTRA_PAGE_INFO_FACTOR_TYPE);
        }
        LinkRiskUtils.a((FactorStorage)linkRiskSource, arrayList, SearchEngineFactorsList.TOTAL_LINKS_FACTOR_TYPE);
        LinkRiskUtils.a((FactorStorage)linkRiskSource, arrayList, SearchEngineFactorsList.EXTERNAL_LINKS_FACTOR_TYPE);
        LinkRiskUtils.a((FactorStorage)linkRiskSource, arrayList, SearchEngineFactorsList.DOMAIN_AGE_FACTOR_TYPE);
        LinkRiskUtils.a((FactorStorage)linkRiskSource, arrayList, SearchEngineFactorsList.DOMAIN_IP_FACTOR_TYPE);
        return arrayList;
    }

    private static void a(FactorStorage factorStorage, List<SearchEngineFactorType<?>> list, SearchEngineFactorType<?> searchEngineFactorType) {
        ISearchEngineFactor iSearchEngineFactor = factorStorage.getRankingFactor(searchEngineFactorType);
        if (iSearchEngineFactor == null) {
            list.add(searchEngineFactorType);
        }
    }

    private static LinkRisk b(LinkRiskSource linkRiskSource, LinkRiskCache linkRiskCache, int n2) {
        Integer n3 = (Integer)linkRiskSource.getRankingFactor((FactorType)SearchEngineFactorsList.EXTERNAL_LINKS_FACTOR_TYPE).getFactorValue();
        Integer n4 = (Integer)linkRiskSource.getRankingFactor((FactorType)SearchEngineFactorsList.TOTAL_LINKS_FACTOR_TYPE).getFactorValue();
        ArrayList<LinkRiskRule> arrayList = new ArrayList<LinkRiskRule>();
        int n5 = linkRiskSource.getBlexPageRank();
        if (n5 == -2 || n5 == 0) {
            arrayList.add(LinkRiskRule.BAD_PAGE_RANK);
        }
        boolean bl = false;
        int n6 = linkRiskSource.getBlexDomainRank();
        if (n6 == -2 || n6 == 0) {
            arrayList.add(LinkRiskRule.BAD_DOMAIN_RANK);
            bl = true;
        }
        if (n4 > 1000) {
            arrayList.add(LinkRiskRule.MASSIVE_NUMBER_OF_OUTGOING_LINKS);
        }
        if (bl && LinkRiskUtils.a(linkRiskSource, new Age(0, 6, 0))) {
            arrayList.add(LinkRiskRule.YOUNG_DOMAIN);
        }
        if (bl && LinkRiskUtils.b(linkRiskSource, new Age(0, 12, 0))) {
            arrayList.add(LinkRiskRule.OLD_NOT_PR_DOMAIN);
        }
        LinkRiskUtils.a(linkRiskSource, linkRiskCache, arrayList);
        LinkRiskUtils.a((FactorStorage)linkRiskSource, linkRiskCache, arrayList);
        ILinkInfo iLinkInfo = linkRiskSource.getLinkInfo();
        if (LinkRiskUtils.a(iLinkInfo)) {
            LinkRiskUtils.a(iLinkInfo, linkRiskCache, arrayList, n2);
        }
        String string = linkRiskSource.getPage().toUnicodeString().toLowerCase();
        LinkRiskUtils.a(string, arrayList);
        LinkRiskUtils.a(string, n3, arrayList);
        return new LinkRisk(arrayList);
    }

    private static boolean a(LinkRiskSource linkRiskSource, Age age) {
        Date date = (Date)linkRiskSource.getRankingFactor((FactorType)SearchEngineFactorsList.DOMAIN_AGE_FACTOR_TYPE).getFactorValue();
        if (!date.equals(IFactorParser.NA_DATE)) {
            Date date2 = age.getDate();
            return date2.before(date);
        }
        return false;
    }

    private static boolean b(LinkRiskSource linkRiskSource, Age age) {
        Date date = (Date)linkRiskSource.getRankingFactor((FactorType)SearchEngineFactorsList.DOMAIN_AGE_FACTOR_TYPE).getFactorValue();
        if (!date.equals(IFactorParser.NA_DATE)) {
            Date date2 = age.getDate();
            return date2.after(date);
        }
        return false;
    }

    private static void a(LinkRiskSource linkRiskSource, LinkRiskCache linkRiskCache, List<LinkRiskRule> list) {
        String string;
        Integer n2;
        UnicodeURL unicodeURL = linkRiskSource.getDomain();
        if (unicodeURL != null && (n2 = linkRiskCache.getSameDomains(string = UnicodeURLUtil.getHostWithoutWWW((UnicodeURL)unicodeURL))) != null && n2 > 1000) {
            list.add(LinkRiskRule.SITE_WIDE_LINK);
        }
    }

    private static void a(FactorStorage factorStorage, LinkRiskCache linkRiskCache, List<LinkRiskRule> list) {
        ISearchEngineFactor iSearchEngineFactor = factorStorage.getRankingFactor((FactorType)SearchEngineFactorsList.DOMAIN_IP_FACTOR_TYPE);
        if (iSearchEngineFactor != null) {
            String string;
            Set<String> set;
            IP iP = (IP)iSearchEngineFactor.getFactorValue();
            Set<String> set2 = linkRiskCache.getSameIPs(iP);
            if (set2 != null && set2.size() > 1) {
                list.add(LinkRiskRule.DUPLICATE_DOMAIN_IP);
            }
            if ((set = linkRiskCache.getSameClassC(string = LinkRiskUtils.a(iP))) != null && set.size() > 1) {
                list.add(LinkRiskRule.DUPLICATE_DOMAIN_IP_C_CLASS);
            }
        }
    }

    private static void a(ILinkInfo iLinkInfo, LinkRiskCache linkRiskCache, List<LinkRiskRule> list, int n2) {
        boolean bl = StatisticsMode.b;
        String string = iLinkInfo.getName().toLowerCase().trim();
        Integer n3 = linkRiskCache.getSameAnchorText(string);
        if (n3 != null && (double)n3.intValue() > (double)n2 * 0.05) {
            list.add(LinkRiskRule.MANY_SAME_ANCHORS);
        }
        Set set = StringUtil.KeywordUtil.getUniqueKeywords((String)string);
        for (String string2 : set) {
            Integer n4 = linkRiskCache.getSameAnchorKeywords(string2);
            if (n4 != null && (double)n4.intValue() > (double)n2 * 0.1) {
                list.add(LinkRiskRule.MANY_SAME_KEYWORD_IN_ANCHOR);
                if (!bl) break;
            }
            if (!bl) continue;
        }
    }

    static String a(IP iP) {
        int[] nArray = iP.getDigits();
        return String.valueOf(nArray[0]) + nArray[1] + nArray[2];
    }

    static boolean a(ILinkInfo iLinkInfo) {
        return iLinkInfo != null && iLinkInfo.isTextLink() && iLinkInfo.getBanner() == null && !StringUtil.isEmpty((String)iLinkInfo.getName());
    }

    private static void a(String string, List<LinkRiskRule> list) {
        boolean bl = StatisticsMode.b;
        for (String string2 : FilterSiteWithResourcePages.PAGE_NAMES) {
            if (!StringUtil.containsIgnoreCase((String)string, (String)string2)) continue;
            list.add(LinkRiskRule.LINK_DIRECTORY_LINK);
            return;
        }
    }

    private static void a(String string, Integer n2, List<LinkRiskRule> list) {
        if (n2 >= 60 && StringUtil.containsIgnoreCase((String)string, (String)a)) {
            list.add(LinkRiskRule.POTENTIAL_SPAM_FORUM);
        }
    }

    public static int calcSum(Collection<LinkRiskRule> collection) {
        if (collection.stream().filter(LinkRiskUtils::a).count() > 0L) {
            return 0;
        }
        double d2 = collection.stream().filter(LinkRiskRule::isCalcRule).mapToInt(LinkRiskRule::getRisk).sum();
        double d3 = Stream.of(LinkRiskRule.values()).filter(LinkRiskRule::isCalcRule).mapToInt(LinkRiskRule::getRisk).sum();
        return (int)Math.round(d2 * 100.0 / d3);
    }

    private static boolean a(LinkRiskRule linkRiskRule) {
        return !linkRiskRule.isCalcRule();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "AU{!L".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 39;
                            break;
                        }
                        case 1: {
                            n7 = 58;
                            break;
                        }
                        case 2: {
                            n7 = 9;
                            break;
                        }
                        case 3: {
                            n7 = 84;
                            break;
                        }
                        default: {
                            n7 = 33;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        a = new String(cArray).intern();
    }
}

