/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.spyglass.modules.comparision.summary.data;

import com.agilemind.spyglass.data.SpyGlassProject;
import com.agilemind.spyglass.data.api.BackLinksRecord;
import com.agilemind.spyglass.data.statistics.StatisticsRecord;
import com.agilemind.spyglass.modules.comparision.data.CompareFactor;
import com.agilemind.spyglass.modules.comparision.data.ICompareFactorsFactory;
import com.agilemind.spyglass.modules.comparision.data.factors.BlexDomainRankCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.project.DomainAgeProjectCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.project.DomainAlexaRankCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.project.DomainGooglePRAuthorityCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.project.DomainStrengthCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.project.KeywordsProjectCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.statistics.AnchorDiversityStatisticsCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.statistics.AnchorUrlsStatisticsCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.statistics.AnchorsStatisticsCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.statistics.BacklinkDomainsStatisticsCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.statistics.BacklinksStatisticsCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.statistics.CBlocksStatisticsCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.statistics.DofollowBacklinksStatisticsCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.statistics.HomepageLinkingDomainsStatisticsCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.statistics.IPStatisticsCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.statistics.TextLinksStatisticsCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.statistics.TopCountryStatisticsCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.factors.statistics.TopTLDStatisticsCompareFactor;
import com.agilemind.spyglass.modules.comparision.data.result.DomainStrengthCompareResult;
import com.agilemind.spyglass.modules.comparision.summary.data.CompareFactorType;
import com.agilemind.spyglass.util.BacklinkAnalyzeUtil;
import com.agilemind.spyglass.util.SpyGlassStringKey;
import java.util.List;
import java.util.stream.Collectors;

public class StatisticsCompareFactorsFactory
implements ICompareFactorsFactory {
    private final SpyGlassProject a;
    private final StatisticsRecord b;
    private final List<BackLinksRecord> c;
    private static final String d;

    public StatisticsCompareFactorsFactory(SpyGlassProject spyGlassProject) {
        boolean bl = CompareFactorType.e;
        this.a = spyGlassProject;
        this.b = spyGlassProject.getStatistics();
        this.c = BacklinkAnalyzeUtil.getAcceptedBacklinks(spyGlassProject).stream().collect(Collectors.toList());
        if (bl) {
            boolean bl2 = !SpyGlassStringKey.b;
            SpyGlassStringKey.b = bl2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CompareFactor getCompareFactor(CompareFactorType compareFactorType) {
        CompareFactor<DomainStrengthCompareResult> compareFactor;
        boolean bl = CompareFactorType.e;
        switch (compareFactorType) {
            case DOMAIN_STRENGTH: {
                compareFactor = new DomainStrengthCompareFactor(this.a);
                if (!bl) break;
            }
            case DOMAIN_GOOGLE_PR_AUTHORITY: {
                compareFactor = new DomainGooglePRAuthorityCompareFactor(this.a);
                if (!bl) break;
            }
            case BLEX_DOMAIN_RANK: {
                compareFactor = new BlexDomainRankCompareFactor(this.a);
                if (!bl) break;
            }
            case DOMAIN_ALEXA_RANK: {
                compareFactor = new DomainAlexaRankCompareFactor(this.a);
                if (!bl) break;
            }
            case DOMAIN_AGE: {
                compareFactor = new DomainAgeProjectCompareFactor(this.a);
                if (!bl) break;
            }
            case BACKLINKS: {
                compareFactor = new BacklinksStatisticsCompareFactor(this.b);
                if (!bl) break;
            }
            case BACKLINK_DOMAINS: {
                compareFactor = new BacklinkDomainsStatisticsCompareFactor(this.b);
                if (!bl) break;
            }
            case IPS: {
                compareFactor = new IPStatisticsCompareFactor(this.b);
                if (!bl) break;
            }
            case C_BLOCKS: {
                compareFactor = new CBlocksStatisticsCompareFactor(this.b);
                if (!bl) break;
            }
            case DOFOLLOW_BACKLINKS: {
                compareFactor = new DofollowBacklinksStatisticsCompareFactor(this.b);
                if (!bl) break;
            }
            case HOMEPAGE_LINKING_DOMAINS: {
                compareFactor = new HomepageLinkingDomainsStatisticsCompareFactor(this.b);
                if (!bl) break;
            }
            case TOP_TLD: {
                compareFactor = new TopTLDStatisticsCompareFactor(this.b);
                if (!bl) break;
            }
            case TOP_COUNTRY: {
                compareFactor = new TopCountryStatisticsCompareFactor(this.b);
                if (!bl) break;
            }
            case TEXT_LINKS: {
                compareFactor = new TextLinksStatisticsCompareFactor(this.b);
                if (!bl) break;
            }
            case ANCHORS: {
                compareFactor = new AnchorsStatisticsCompareFactor(this.b);
                if (!bl) break;
            }
            case ANCHOR_DIVERSITY: {
                compareFactor = new AnchorDiversityStatisticsCompareFactor(this.b);
                if (!bl) break;
            }
            case KEYWORDS: {
                compareFactor = new KeywordsProjectCompareFactor(this.c);
                if (!bl) break;
            }
            case ANCHOR_URLS: {
                compareFactor = new AnchorUrlsStatisticsCompareFactor(this.b);
                if (!bl) break;
            }
            default: {
                throw new IllegalArgumentException(d + (Object)((Object)compareFactorType));
            }
        }
        return compareFactor;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "[R\u0005\u0019\byRN4\bcL\u000f\u0005\u0002H]\r\u0003\b|h\u0017\u0007\u0002.".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 14;
                            break;
                        }
                        case 1: {
                            n7 = 60;
                            break;
                        }
                        case 2: {
                            n7 = 110;
                            break;
                        }
                        case 3: {
                            n7 = 119;
                            break;
                        }
                        default: {
                            n7 = 103;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        d = new String(cArray).intern();
    }
}

