/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.spyglass.util;

import com.agilemind.commons.application.data.IScanResult;
import com.agilemind.commons.application.modules.io.searchengine.data.api.ISearchEngineFactor;
import com.agilemind.commons.application.modules.widget.util.RecordAnalyzeUtil;
import com.agilemind.commons.application.modules.widget.util.to.AnchorAltTextResult;
import com.agilemind.commons.application.modules.widget.util.to.AnchorUrlResult;
import com.agilemind.commons.application.modules.widget.util.to.KeywordsResult;
import com.agilemind.commons.application.modules.widget.util.to.analyze.CountryResult;
import com.agilemind.commons.application.modules.widget.util.to.analyze.DofollowNofollowDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.HomepageLinksDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.PRDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.TLDResult;
import com.agilemind.commons.application.modules.widget.util.to.analyze.TextImageDistribution;
import com.agilemind.commons.io.searchengine.validator.ILinkInfo;
import com.agilemind.commons.io.searchengine.validator.scanstatus.ScanStatus;
import com.agilemind.commons.io.utils.ip.data.IP;
import com.agilemind.commons.localization.stringkey.Country;
import com.agilemind.commons.util.DateUtil;
import com.agilemind.commons.util.MathUtil;
import com.agilemind.commons.util.StringURLUtil;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLUtil;
import com.agilemind.factors.FactorType;
import com.agilemind.factors.SearchEngineFactorType;
import com.agilemind.factors.SearchEngineFactorsList;
import com.agilemind.spyglass.data.AnalyzeRecord;
import com.agilemind.spyglass.data.SpyGlassProject;
import com.agilemind.spyglass.data.api.BackLinksRecord;
import com.agilemind.spyglass.data.api.LinkRiskSource;
import com.agilemind.spyglass.data.service.SpyGlassProjectService;
import com.agilemind.spyglass.util.CollectBacklinksCompositeOperation;
import com.agilemind.spyglass.util.r;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class BacklinkAnalyzeUtil {
    public static final int NO_DATA = -1;
    private static final Pattern a;
    private static final String b;

    public static int getUniqueDomainsCount(List<? extends BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        ArrayList<UnicodeURL> arrayList = new ArrayList<UnicodeURL>();
        for (BackLinksRecord backLinksRecord : list) {
            arrayList.add(backLinksRecord.getPage());
            if (n2 == 0) continue;
        }
        return BacklinkAnalyzeUtil.getUniqueHomepagesCount(arrayList);
    }

    public static int getDofollowDomainsCount(List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        ArrayList<UnicodeURL> arrayList = new ArrayList<UnicodeURL>();
        for (BackLinksRecord backLinksRecord : list) {
            ScanStatus scanStatus = backLinksRecord.getScanStatus();
            if (scanStatus != ScanStatus.SCAN_STATUS_UNKNOWN && scanStatus.isOkStatus()) {
                arrayList.add(backLinksRecord.getPage());
            }
            if (n2 == 0) continue;
        }
        return BacklinkAnalyzeUtil.getUniqueHomepagesCount(arrayList);
    }

    public static int getHomepageLinkingDomainsCount(List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        ArrayList<UnicodeURL> arrayList = new ArrayList<UnicodeURL>();
        for (BackLinksRecord backLinksRecord : list) {
            UnicodeURL unicodeURL = backLinksRecord.getPage();
            boolean bl = UnicodeURLUtil.isHomePageIncludeIndex((UnicodeURL)unicodeURL);
            if (bl) {
                arrayList.add(unicodeURL);
            }
            if (n2 == 0) continue;
        }
        return BacklinkAnalyzeUtil.getUniqueHomepagesCount(arrayList);
    }

    public static int getToHomepageAnchorCount(List<BackLinksRecord> list, boolean bl) {
        int n2 = CollectBacklinksCompositeOperation.d;
        ArrayList<UnicodeURL> arrayList = new ArrayList<UnicodeURL>();
        for (BackLinksRecord backLinksRecord : list) {
            ILinkInfo iLinkInfo = backLinksRecord.getLinkInfo();
            if (iLinkInfo != null && bl != UnicodeURLUtil.isHomePageIncludeIndex((UnicodeURL)iLinkInfo.getDomain())) {
                arrayList.add(iLinkInfo.getDomain());
            }
            if (n2 == 0) continue;
        }
        return arrayList.size();
    }

    public static int getUniqueIPsCount(List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        if (list.isEmpty()) {
            return 0;
        }
        boolean bl = false;
        HashSet<IP> hashSet = new HashSet<IP>();
        for (BackLinksRecord backLinksRecord : list) {
            ISearchEngineFactor iSearchEngineFactor = backLinksRecord.getRankingFactor((FactorType)SearchEngineFactorsList.DOMAIN_IP_FACTOR_TYPE);
            if (iSearchEngineFactor == null && n2 == 0) continue;
            bl = true;
            IP iP = (IP)iSearchEngineFactor.getFactorValue();
            if (iP == null && n2 == 0) continue;
            hashSet.add(iP);
            if (n2 == 0) continue;
        }
        return bl ? hashSet.size() : -1;
    }

    public static int getUniqueCBlocksCount(List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        if (list.isEmpty()) {
            return 0;
        }
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>();
        for (BackLinksRecord backLinksRecord : list) {
            ISearchEngineFactor iSearchEngineFactor = backLinksRecord.getRankingFactor((FactorType)SearchEngineFactorsList.DOMAIN_IP_FACTOR_TYPE);
            if (iSearchEngineFactor == null && n2 == 0) continue;
            bl = true;
            IP iP = (IP)iSearchEngineFactor.getFactorValue();
            if (iP == null && n2 == 0) continue;
            StringBuilder stringBuilder = new StringBuilder();
            int[] nArray = iP.getDigits();
            for (int i2 = 0; i2 < nArray.length - 1; ++i2) {
                stringBuilder.append(nArray[i2]);
                if (n2 == 0) continue;
            }
            hashSet.add(stringBuilder.toString());
            if (n2 == 0) continue;
        }
        return bl ? hashSet.size() : -1;
    }

    public static int getUniqueAnchorsCount(List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (BackLinksRecord backLinksRecord : list) {
            block4: {
                String string;
                block3: {
                    ILinkInfo iLinkInfo = backLinksRecord.getLinkInfo();
                    if (iLinkInfo == null && n2 == 0) continue;
                    string = BacklinkAnalyzeUtil.a(iLinkInfo);
                    if (!iLinkInfo.isTextLink()) break block3;
                    hashSet.add(string);
                    if (n2 == 0) break block4;
                }
                hashSet2.add(string);
            }
            if (n2 == 0) continue;
        }
        return hashSet.size() + hashSet2.size();
    }

    public static int getUniqueKeywordsCount(List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        HashSet<String> hashSet = new HashSet<String>();
        for (BackLinksRecord backLinksRecord : list) {
            String string = backLinksRecord.getAnchorText();
            if (string != null) {
                Collection<String> collection = BacklinkAnalyzeUtil.getUniqueKeywords(string);
                hashSet.addAll(collection);
            }
            if (n2 == 0) continue;
        }
        return hashSet.size();
    }

    public static int getUniqueAnchorUrlsCount(List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        HashSet<String> hashSet = new HashSet<String>();
        for (BackLinksRecord backLinksRecord : list) {
            UnicodeURL unicodeURL = backLinksRecord.getAnchorUrl();
            if (unicodeURL != null) {
                hashSet.add(BacklinkAnalyzeUtil.a(unicodeURL).toLowerCase());
            }
            if (n2 == 0) continue;
        }
        return hashSet.size();
    }

    public static List<CountryResult> getCountryDistributions(List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        ArrayList<CountryResult> arrayList = new ArrayList<CountryResult>();
        Map<Country, List<UnicodeURL>> map = BacklinkAnalyzeUtil.a(list);
        int n3 = BacklinkAnalyzeUtil.getUniqueDomainsCount(list);
        for (Map.Entry<Country, List<UnicodeURL>> entry : map.entrySet()) {
            int n4 = BacklinkAnalyzeUtil.getUniqueHomepagesCount((Collection<UnicodeURL>)entry.getValue());
            double d2 = MathUtil.getPercent((double)n3, (double)n4);
            arrayList.add(new CountryResult(entry.getKey(), n4, d2));
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, BacklinkAnalyzeUtil::a);
        return arrayList;
    }

    private static Map<Country, List<UnicodeURL>> a(List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        HashMap<Country, List<UnicodeURL>> hashMap = new HashMap<Country, List<UnicodeURL>>();
        for (BackLinksRecord backLinksRecord : list) {
            Country country;
            IP iP;
            ISearchEngineFactor iSearchEngineFactor = backLinksRecord.getRankingFactor((FactorType)SearchEngineFactorsList.DOMAIN_IP_FACTOR_TYPE);
            if (iSearchEngineFactor == null && n2 == 0 || (iP = (IP)iSearchEngineFactor.getFactorValue()) == null && n2 == 0 || (country = iP.getCountry()).equals((Object)Country.UNKNOWN) && n2 == 0) continue;
            ArrayList<UnicodeURL> arrayList = (ArrayList<UnicodeURL>)hashMap.get(country);
            if (arrayList == null) {
                arrayList = new ArrayList<UnicodeURL>();
                hashMap.put(country, arrayList);
            }
            arrayList.add(backLinksRecord.getPage());
            if (n2 == 0) continue;
        }
        return hashMap;
    }

    public static List<TLDResult> getTLDDistribution(List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        ArrayList<TLDResult> arrayList = new ArrayList<TLDResult>();
        Map<String, List<UnicodeURL>> map = BacklinkAnalyzeUtil.b(list);
        int n3 = BacklinkAnalyzeUtil.getUniqueDomainsCount(list);
        for (Map.Entry<String, List<UnicodeURL>> entry : map.entrySet()) {
            int n4 = BacklinkAnalyzeUtil.getUniqueHomepagesCount((Collection<UnicodeURL>)entry.getValue());
            double d2 = MathUtil.getPercent100((double)n3, (double)n4);
            if (entry.getKey() != null) {
                arrayList.add(new TLDResult(entry.getKey(), n4, d2));
            }
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, BacklinkAnalyzeUtil::a);
        return arrayList;
    }

    private static Map<String, List<UnicodeURL>> b(List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        HashMap<String, List<UnicodeURL>> hashMap = new HashMap<String, List<UnicodeURL>>();
        for (BackLinksRecord backLinksRecord : list) {
            if (a.matcher(backLinksRecord.getPage().getUnicodeHost()).find() && n2 == 0) continue;
            String string = UnicodeURLUtil.getTld((UnicodeURL)backLinksRecord.getPage());
            if (!StringUtil.isEmpty((String)string)) {
                ArrayList<UnicodeURL> arrayList = (ArrayList<UnicodeURL>)hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<UnicodeURL>();
                    hashMap.put(string, arrayList);
                }
                arrayList.add(backLinksRecord.getPage());
            }
            if (n2 == 0) continue;
        }
        return hashMap;
    }

    public static List<AnchorAltTextResult> getPagesTopAnchorTexts(List<BackLinksRecord> list) {
        return BacklinkAnalyzeUtil.getPagesTopAnchorTexts(list, true);
    }

    public static List<AnchorAltTextResult> getPagesTopAnchorTexts(List<BackLinksRecord> list, boolean bl) {
        return RecordAnalyzeUtil.getPagesTopAnchorAltTexts(list, BackLinksRecord::getScanResult, LinkRiskSource::getPage, (boolean)bl);
    }

    public static List<AnchorAltTextResult> getDomainsTopAnchorTexts(List<BackLinksRecord> list) {
        return RecordAnalyzeUtil.getDomainsTopAnchorAltTexts(list, BackLinksRecord::getScanResult, LinkRiskSource::getPage, (boolean)true);
    }

    public static List<KeywordsResult> getPagesTopKeywords(List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        ArrayList<KeywordsResult> arrayList = new ArrayList<KeywordsResult>();
        Map<String, List<UnicodeURL>> map = BacklinkAnalyzeUtil.c(list);
        for (Map.Entry<String, List<UnicodeURL>> entry : map.entrySet()) {
            int n3 = entry.getValue().size();
            double d2 = MathUtil.getPercent100((double)list.size(), (double)n3);
            arrayList.add(new KeywordsResult(entry.getKey(), n3, d2));
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, new r(null));
        return arrayList;
    }

    public static List<KeywordsResult> getDomainsTopKeywords(List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        ArrayList<KeywordsResult> arrayList = new ArrayList<KeywordsResult>();
        Map<String, List<UnicodeURL>> map = BacklinkAnalyzeUtil.c(list);
        int n3 = BacklinkAnalyzeUtil.getUniqueDomainsCount(list);
        for (Map.Entry<String, List<UnicodeURL>> entry : map.entrySet()) {
            int n4 = BacklinkAnalyzeUtil.getUniqueHomepagesCount((Collection<UnicodeURL>)entry.getValue());
            double d2 = MathUtil.getPercent100((double)n3, (double)n4);
            arrayList.add(new KeywordsResult(entry.getKey(), n4, d2));
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, new r(null));
        return arrayList;
    }

    private static Map<String, List<UnicodeURL>> c(List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        HashMap<String, List<UnicodeURL>> hashMap = new HashMap<String, List<UnicodeURL>>();
        for (BackLinksRecord backLinksRecord : list) {
            String string = backLinksRecord.getAnchorText();
            if (string == null && n2 == 0) continue;
            Collection<String> collection = BacklinkAnalyzeUtil.getUniqueKeywords(string);
            for (String string2 : collection) {
                ArrayList<UnicodeURL> arrayList = (ArrayList<UnicodeURL>)hashMap.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList<UnicodeURL>();
                    hashMap.put(string2, arrayList);
                }
                arrayList.add(backLinksRecord.getPage());
                if (n2 == 0) continue;
            }
            if (n2 == 0) continue;
        }
        return hashMap;
    }

    public static List<AnchorUrlResult> getPagesTopAnchorUrls(List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        ArrayList<AnchorUrlResult> arrayList = new ArrayList<AnchorUrlResult>();
        Map<UnicodeURL, List<UnicodeURL>> map = BacklinkAnalyzeUtil.d(list);
        for (Map.Entry<UnicodeURL, List<UnicodeURL>> entry : map.entrySet()) {
            int n3 = entry.getValue().size();
            double d2 = MathUtil.getPercent100((double)list.size(), (double)n3);
            arrayList.add(new AnchorUrlResult(entry.getKey(), n3, d2));
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, BacklinkAnalyzeUtil::b);
        return arrayList;
    }

    public static List<AnchorUrlResult> getDomainsTopAnchorUrls(List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        ArrayList<AnchorUrlResult> arrayList = new ArrayList<AnchorUrlResult>();
        Map<UnicodeURL, List<UnicodeURL>> map = BacklinkAnalyzeUtil.d(list);
        int n3 = BacklinkAnalyzeUtil.getUniqueDomainsCount(list);
        for (Map.Entry<UnicodeURL, List<UnicodeURL>> entry : map.entrySet()) {
            int n4 = BacklinkAnalyzeUtil.getUniqueHomepagesCount((Collection<UnicodeURL>)entry.getValue());
            double d2 = MathUtil.getPercent((int)100, (double)n3, (double)n4);
            arrayList.add(new AnchorUrlResult(entry.getKey(), n4, d2));
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, BacklinkAnalyzeUtil::a);
        return arrayList;
    }

    private static Map<UnicodeURL, List<UnicodeURL>> d(List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        TreeMap<UnicodeURL, List<UnicodeURL>> treeMap = new TreeMap<UnicodeURL, List<UnicodeURL>>(BacklinkAnalyzeUtil::a);
        for (BackLinksRecord backLinksRecord : list) {
            UnicodeURL unicodeURL = backLinksRecord.getAnchorUrl();
            if (unicodeURL == null && n2 == 0) continue;
            ArrayList<UnicodeURL> arrayList = (ArrayList<UnicodeURL>)treeMap.get(unicodeURL);
            if (arrayList == null) {
                arrayList = new ArrayList<UnicodeURL>();
                treeMap.put(unicodeURL, arrayList);
            }
            arrayList.add(backLinksRecord.getPage());
            if (n2 == 0) continue;
        }
        return treeMap;
    }

    private static String a(UnicodeURL unicodeURL) {
        return StringURLUtil.removeTrailingSlash((String)StringURLUtil.removeWWW((String)UnicodeURLUtil.removeProtocol((UnicodeURL)unicodeURL)));
    }

    public static int getUniqueHomepagesCount(Collection<UnicodeURL> collection) {
        int n2 = CollectBacklinksCompositeOperation.d;
        HashSet<String> hashSet = new HashSet<String>();
        for (UnicodeURL unicodeURL : collection) {
            hashSet.add(UnicodeURLUtil.getHostWithoutWWW((UnicodeURL)unicodeURL).toLowerCase());
            if (n2 == 0) continue;
        }
        return hashSet.size();
    }

    private static String a(ILinkInfo iLinkInfo) {
        return StringUtil.removeBrakes((String)iLinkInfo.getName()).toLowerCase();
    }

    public static Collection<String> getUniqueKeywords(String string) {
        if ("".equals(string)) {
            return Collections.singletonList(string);
        }
        string = string.replaceAll(b, "");
        return StringUtil.KeywordUtil.getUniqueKeywords((String)string.toLowerCase());
    }

    public static DofollowNofollowDistribution getDofollowNofollowDistribution(List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (BackLinksRecord backLinksRecord : list) {
            block4: {
                block6: {
                    ScanStatus scanStatus;
                    block5: {
                        block3: {
                            IScanResult iScanResult = backLinksRecord.getScanResult();
                            scanStatus = iScanResult.getScanStatus();
                            if (scanStatus != ScanStatus.SCAN_STATUS_UNKNOWN) break block3;
                            ++n5;
                            if (n2 == 0) break block4;
                        }
                        if (!scanStatus.isOkStatus()) break block5;
                        ++n3;
                        if (n2 == 0) break block4;
                    }
                    if (scanStatus != ScanStatus.SCAN_STATUS_CHEATING_NOFOLLOW && scanStatus != ScanStatus.SCAN_STATUS_NOINDEX_ROBOTS) break block6;
                    ++n4;
                    if (n2 == 0) break block4;
                }
                ++n5;
            }
            if (n2 == 0) continue;
        }
        double d2 = MathUtil.getPercent((double)list.size(), (double)n3);
        double d3 = MathUtil.getPercent((double)list.size(), (double)n4);
        double d4 = MathUtil.getPercent((double)list.size(), (double)n5);
        return new DofollowNofollowDistribution(n3, d2, n4, d3, n5, d4);
    }

    public static TextImageDistribution getTextImageDistribution(List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (BackLinksRecord backLinksRecord : list) {
            block6: {
                block5: {
                    ILinkInfo iLinkInfo = backLinksRecord.getLinkInfo();
                    if (iLinkInfo == null) {
                        ++n5;
                        if (n2 == 0) continue;
                    }
                    if (!iLinkInfo.isTextLink()) break block5;
                    ++n3;
                    if (n2 == 0) break block6;
                }
                ++n4;
            }
            if (n2 == 0) continue;
        }
        double d2 = MathUtil.getPercent((double)list.size(), (double)n3);
        double d3 = MathUtil.getPercent((double)list.size(), (double)n4);
        double d4 = MathUtil.getPercent((double)list.size(), (double)n5);
        return new TextImageDistribution(n3, d2, n4, d3, n5, d4);
    }

    public static HomepageLinksDistribution getFromHomepageLinkingDomainsDistribution(List<BackLinksRecord> list) {
        int n2 = BacklinkAnalyzeUtil.getUniqueDomainsCount(list);
        int n3 = BacklinkAnalyzeUtil.getHomepageLinkingDomainsCount(list);
        int n4 = n2 - n3;
        return new HomepageLinksDistribution(n2, n3, n4);
    }

    public static HomepageLinksDistribution getToHomepageVsToOtherBacklinksDistribution(List<BackLinksRecord> list) {
        int n2 = list.size();
        int n3 = BacklinkAnalyzeUtil.getToHomepageAnchorCount(list, false);
        int n4 = BacklinkAnalyzeUtil.getToHomepageAnchorCount(list, true);
        return new HomepageLinksDistribution(n2, n3, n4);
    }

    public static List<AnalyzeRecord> getAcceptedBacklinks(SpyGlassProject spyGlassProject) {
        int n2 = CollectBacklinksCompositeOperation.d;
        ArrayList<AnalyzeRecord> arrayList = new ArrayList<AnalyzeRecord>();
        Iterator iterator = spyGlassProject.getBackLinks().iterator();
        while (iterator.hasNext()) {
            AnalyzeRecord analyzeRecord = (AnalyzeRecord)iterator.next();
            ScanStatus scanStatus = analyzeRecord.getScanStatus();
            if (scanStatus == ScanStatus.SCAN_STATUS_SITE_NOT_FOUND || scanStatus == ScanStatus.SCAN_STATUS_PAGE_NOT_FOUND || scanStatus == ScanStatus.SCAN_STATUS_LINK_NOT_FOUND || spyGlassProject.getDisavowFacade().isDisavow(analyzeRecord.getPage()) && n2 == 0) continue;
            arrayList.add(analyzeRecord);
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    public static List<BackLinksRecord> getAcceptedBacklinks(SpyGlassProjectService spyGlassProjectService) {
        int n2 = CollectBacklinksCompositeOperation.d;
        ArrayList<BackLinksRecord> arrayList = new ArrayList<BackLinksRecord>();
        for (BackLinksRecord backLinksRecord : spyGlassProjectService.getBacklinkService().getBacklinks()) {
            ScanStatus scanStatus = backLinksRecord.getScanStatus();
            if (scanStatus == ScanStatus.SCAN_STATUS_SITE_NOT_FOUND || scanStatus == ScanStatus.SCAN_STATUS_PAGE_NOT_FOUND || scanStatus == ScanStatus.SCAN_STATUS_LINK_NOT_FOUND || spyGlassProjectService.getDisavowFacade().isDisavow(backLinksRecord.getPage()) && n2 == 0) continue;
            arrayList.add(backLinksRecord);
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    public static List<PRDistribution> getPagesPRDistributions(List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        ArrayList<PRDistribution> arrayList = new ArrayList<PRDistribution>();
        Map<Integer, List<UnicodeURL>> map = BacklinkAnalyzeUtil.a((SearchEngineFactorType<Integer>)SearchEngineFactorsList.PAGE_GOOGLE_PR, list);
        if (map.isEmpty()) {
            return arrayList;
        }
        for (int i2 = -1; i2 <= 10; ++i2) {
            List<UnicodeURL> list2 = map.get(i2);
            if (list2 == null) {
                arrayList.add(new PRDistribution(i2));
                if (n2 == 0) continue;
            }
            double d2 = MathUtil.getPercent100((double)list.size(), (double)list2.size());
            arrayList.add(new PRDistribution(i2, list2.size(), d2));
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    public static List<PRDistribution> getDomainsPRDistributions(List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        ArrayList<PRDistribution> arrayList = new ArrayList<PRDistribution>();
        Map<Integer, List<UnicodeURL>> map = BacklinkAnalyzeUtil.a((SearchEngineFactorType<Integer>)SearchEngineFactorsList.DOMAIN_GOOGLE_PR, list);
        if (map.isEmpty()) {
            return arrayList;
        }
        int n3 = BacklinkAnalyzeUtil.getUniqueDomainsCount(list);
        for (int i2 = -1; i2 <= 10; ++i2) {
            List<UnicodeURL> list2 = map.get(i2);
            if (list2 == null) {
                arrayList.add(new PRDistribution(i2));
                if (n2 == 0) continue;
            }
            int n4 = BacklinkAnalyzeUtil.getUniqueHomepagesCount(list2);
            double d2 = MathUtil.getPercent100((double)n3, (double)n4);
            arrayList.add(new PRDistribution(i2, n4, d2));
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    private static Map<Integer, List<UnicodeURL>> a(SearchEngineFactorType<Integer> searchEngineFactorType, List<BackLinksRecord> list) {
        int n2 = CollectBacklinksCompositeOperation.d;
        HashMap<Integer, List<UnicodeURL>> hashMap = new HashMap<Integer, List<UnicodeURL>>();
        for (BackLinksRecord backLinksRecord : list) {
            ISearchEngineFactor iSearchEngineFactor = backLinksRecord.getRankingFactor((FactorType)searchEngineFactorType);
            if (iSearchEngineFactor == null && n2 == 0) continue;
            Integer n3 = (Integer)iSearchEngineFactor.getFactorValue();
            ArrayList<UnicodeURL> arrayList = (ArrayList<UnicodeURL>)hashMap.get(n3);
            if (arrayList == null) {
                arrayList = new ArrayList<UnicodeURL>();
                hashMap.put(n3, arrayList);
            }
            arrayList.add(backLinksRecord.getPage());
            if (n2 == 0) continue;
        }
        return hashMap;
    }

    public static NavigableMap<Date, Integer> getBacklinksIndexByDate(List<BackLinksRecord> list) {
        ImmutableListMultimap immutableListMultimap = FluentIterable.from(list).filter(BacklinkAnalyzeUtil::c).index(BacklinkAnalyzeUtil::b);
        return Maps.transformValues(new TreeMap(immutableListMultimap.asMap()), Collection::size);
    }

    public static NavigableMap<Date, Integer> getDomainsIndexByDate(List<BackLinksRecord> list) {
        Comparable<Date> comparable;
        int n2 = CollectBacklinksCompositeOperation.d;
        ImmutableMap immutableMap = Multimaps.index(list, BacklinkAnalyzeUtil::a).asMap();
        NavigableMap navigableMap = Maps.transformValues(new TreeMap(immutableMap), BacklinkAnalyzeUtil::b);
        TreeMap<Object, Date> treeMap = new TreeMap<Object, Date>();
        for (BackLinksRecord object : list) {
            Object object2 = UnicodeURLUtil.getHostWithoutWWW((UnicodeURL)object.getPage()).toLowerCase();
            comparable = (Date)treeMap.get(object2);
            Date date = DateUtil.getUtcStartDay((Date)object.getFirstFoundDate());
            if (date != null && (comparable == null || ((Date)comparable).getTime() > date.getTime())) {
                treeMap.put(object2, date);
            }
            if (n2 == 0) continue;
        }
        TreeMap treeMap2 = new TreeMap();
        for (Object object2 : navigableMap.values()) {
            comparable = (Integer)treeMap2.get(object2);
            if (comparable == null) {
                comparable = 0;
            }
            if (object2 != null) {
                treeMap2.put(object2, (Integer)comparable + 1);
            }
            if (n2 == 0) continue;
        }
        return treeMap2;
    }

    private static Date b(Collection collection) {
        Ordering ordering = Ordering.natural().nullsLast().onResultOf(BackLinksRecord::getFirstFoundDate);
        return DateUtil.getUtcStartDay((Date)((BackLinksRecord)Collections.min(collection, ordering)).getFirstFoundDate());
    }

    private static String a(BackLinksRecord backLinksRecord) {
        return UnicodeURLUtil.getHostWithoutWWW((UnicodeURL)backLinksRecord.getDomain()).toLowerCase();
    }

    private static Date b(BackLinksRecord backLinksRecord) {
        return DateUtil.getStartDay((Date)backLinksRecord.getFirstFoundDate());
    }

    private static boolean c(BackLinksRecord backLinksRecord) {
        return backLinksRecord.getFirstFoundDate() != null;
    }

    private static int a(UnicodeURL unicodeURL, UnicodeURL unicodeURL2) {
        return BacklinkAnalyzeUtil.a(unicodeURL).compareToIgnoreCase(BacklinkAnalyzeUtil.a(unicodeURL2));
    }

    private static int a(AnchorUrlResult anchorUrlResult, AnchorUrlResult anchorUrlResult2) {
        return anchorUrlResult2.getCount() - anchorUrlResult.getCount();
    }

    private static int b(AnchorUrlResult anchorUrlResult, AnchorUrlResult anchorUrlResult2) {
        return anchorUrlResult2.getCount() - anchorUrlResult.getCount();
    }

    private static int a(TLDResult tLDResult, TLDResult tLDResult2) {
        return tLDResult2.getDomainsCount() - tLDResult.getDomainsCount();
    }

    private static int a(CountryResult countryResult, CountryResult countryResult2) {
        return countryResult2.getDomainsCount() - countryResult.getDomainsCount();
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    static {
        v0 = "\"\u0001_!=";
        v1 = -1;
        block9: while (true) {
            v2 = v0.toCharArray();
            var0 = 0;
            v3 = v2.length;
            v4 = v2;
            v5 = v3;
            if (v3 > 1) ** GOTO lbl41
            do {
                v6 = v4;
                v7 = v4;
                v8 = var0;
                while (true) {
                    v9 = v6[v8];
                    switch (var0 % 5) {
                        case 0: {
                            v10 = 121;
                            break;
                        }
                        case 1: {
                            v10 = 32;
                            break;
                        }
                        case 2: {
                            v10 = 96;
                            break;
                        }
                        case 3: {
                            v10 = 13;
                            break;
                        }
                        default: {
                            v10 = 96;
                        }
                    }
                    v6[v8] = (char)(v9 ^ v10);
                    ++var0;
                    v4 = v7;
                    v5 = v5;
                    if (v5 != 0) break;
                    v7 = v4;
                    v11 = v5;
                    v8 = v5;
                    v6 = v4;
                }
lbl41:
                // 2 sources

                v12 = v4;
                v11 = v5;
            } while (v5 > var0);
            v13 = new String(v12);
            switch (v1) {
                default: {
                    BacklinkAnalyzeUtil.b = v13.intern();
                    v0 = "'\bHVPH}_Q\u0004%D_qR\"\u0010M9=%D\u001c?U\"\u0010M8=P|N$\u001bJ]HVPH}_Q\u0004%D_qR\"\u0010M9=%D\u001c?U\"\u0010M8=P\u0004";
                    v1 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        BacklinkAnalyzeUtil.a = Pattern.compile(v13.intern());
    }
}

