/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.spyglass.util.export;

import com.agilemind.backlinks.BackLinkQueryBuilder;
import com.agilemind.backlinks.BackLinkSourceList;
import com.agilemind.backlinks.BackLinkSourceType;
import com.agilemind.backlinks.IBackLinkSourceSettings;
import com.agilemind.spyglass.util.export.BacklinkExporter;
import com.agilemind.spyglass.util.export.BacklinkExporterFactory;
import com.agilemind.spyglass.util.export.BacklinkSourceExporter;
import com.agilemind.spyglass.util.export.BlexBacklinkExporter;
import com.agilemind.spyglass.util.export.GoogleSearchConsoleBacklinkExporter;
import com.agilemind.spyglass.util.export.convert.BacklinkToRecordsConvert;
import com.agilemind.spyglass.util.export.convert.BacklinkToRecordsConvertFactory;
import com.agilemind.spyglass.util.query.BackLinkQueryBuilderFactory;

public class DefaultBacklinkExporterFactory
implements BacklinkExporterFactory {
    private IBackLinkSourceSettings a;
    private BacklinkToRecordsConvertFactory b;
    private BackLinkQueryBuilderFactory c;

    public DefaultBacklinkExporterFactory(BackLinkQueryBuilderFactory backLinkQueryBuilderFactory, IBackLinkSourceSettings iBackLinkSourceSettings, BacklinkToRecordsConvertFactory backlinkToRecordsConvertFactory) {
        this.c = backLinkQueryBuilderFactory;
        this.a = iBackLinkSourceSettings;
        this.b = backlinkToRecordsConvertFactory;
    }

    @Override
    public BacklinkExporter createBackLinkExporter(BackLinkSourceType backLinkSourceType) {
        if (backLinkSourceType == BackLinkSourceList.WEBMEUP_BACKLINK_SOURCE_TYPE) {
            return new BlexBacklinkExporter();
        }
        if (backLinkSourceType == BackLinkSourceList.GOOGLE_SEARCH_CONSOLE_BACKLINK_SOURCE) {
            return new GoogleSearchConsoleBacklinkExporter(this.a.getGoogleSearchConsoleSettings());
        }
        BackLinkQueryBuilder backLinkQueryBuilder = this.c.getBackLinkQueryBuilder(backLinkSourceType);
        BacklinkToRecordsConvert backlinkToRecordsConvert = this.b.createBackLinkToRecordsConvert(backLinkSourceType);
        return new BacklinkSourceExporter(backLinkSourceType, backLinkQueryBuilder, this.a, backlinkToRecordsConvert);
    }
}

