/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.spyglass.util.statistics.blex;

import com.agilemind.commons.application.modules.widget.util.to.AnchorAltTextResult;
import com.agilemind.commons.application.modules.widget.util.to.AnchorUrlResult;
import com.agilemind.commons.application.modules.widget.util.to.analyze.CountryResult;
import com.agilemind.commons.application.modules.widget.util.to.analyze.DofollowNofollowDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.HomepageLinksDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.TLDResult;
import com.agilemind.commons.application.modules.widget.util.to.analyze.TextImageDistribution;
import com.agilemind.commons.localization.stringkey.Country;
import com.agilemind.commons.util.DateUtil;
import com.agilemind.commons.util.MathUtil;
import com.agilemind.spyglass.data.statistics.AnchorTextRecord;
import com.agilemind.spyglass.data.statistics.AnchorUrlRecord;
import com.agilemind.spyglass.data.statistics.CountryRecord;
import com.agilemind.spyglass.data.statistics.StatisticsRecord;
import com.agilemind.spyglass.data.statistics.TLDRecord;
import com.agilemind.spyglass.util.SpyGlassStringKey;
import com.agilemind.spyglass.util.statistics.StatisticsService;
import com.agilemind.spyglass.util.statistics.blex.a;
import com.agilemind.spyglass.util.statistics.blex.b;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class BlexStatisticsService
implements StatisticsService {
    private final StatisticsRecord a;
    public static boolean b;

    public BlexStatisticsService(StatisticsRecord statisticsRecord) {
        this.a = statisticsRecord;
    }

    @Override
    public boolean hasStatistics() {
        return this.a.getRebuildDate() != null;
    }

    @Override
    public Date getRebuildDate() {
        Date date = this.a.getRebuildDate();
        return date != null ? date : new Date();
    }

    @Override
    public int getTotalBacklinksCount() {
        return this.a.getTotalBacklinkCount();
    }

    @Override
    public int getTotalLinkingDomainsCount() {
        return this.a.getTotalLinkingDomainsCount();
    }

    @Override
    public int getTotalIpsCount() {
        return this.a.getTotalIpsCount();
    }

    @Override
    public int getTotalCBlocksCount() {
        return this.a.getTotalCBlocksCount();
    }

    @Override
    public DofollowNofollowDistribution getDofollowVsNofollowBacklinks() {
        boolean bl = b;
        int n2 = this.a.getTotalBacklinkCount();
        int n3 = this.a.getTotalDofollowBacklinksCount();
        int n4 = this.a.getTotalNofollowBacklinksCount();
        double d2 = MathUtil.getPercent((double)n2, (double)n3);
        double d3 = MathUtil.getPercent((double)n2, (double)n4);
        DofollowNofollowDistribution dofollowNofollowDistribution = new DofollowNofollowDistribution(n3, d2, n4, d3, 0, 0.0);
        if (bl) {
            SpyGlassStringKey.b = !SpyGlassStringKey.b;
        }
        return dofollowNofollowDistribution;
    }

    @Override
    public int getTotalDofollowDomainsCount() {
        return this.a.getTotalDofollowDomainsCount();
    }

    @Override
    public HomepageLinksDistribution getFromHomepageVsFromOtherPagesLinkingDomains() {
        int n2 = this.a.getTotalLinkingDomainsCount();
        int n3 = this.a.getTotalDomainsLinkingFromHomepage();
        int n4 = this.a.getTotalDomainsLinkingFromOtherPages();
        return new HomepageLinksDistribution(n2, n3, n4);
    }

    @Override
    public TextImageDistribution getTextVsImageBacklinks() {
        boolean bl = b;
        double d2 = this.a.getTotalBacklinkCount();
        int n2 = this.a.getTotalTextBacklinksCount();
        int n3 = this.a.getTotalImageBacklinksCount();
        TextImageDistribution textImageDistribution = new TextImageDistribution(n2, (double)n2 / d2, n3, (double)n3 / d2, 0, 0.0);
        if (SpyGlassStringKey.b) {
            b = !bl;
        }
        return textImageDistribution;
    }

    @Override
    public int getTotalAnchorTexts() {
        return this.a.getTotalAnchorTextsCount();
    }

    @Override
    public int getTotalAnchorUrls() {
        return this.a.getTotalAnchorUrlsCount();
    }

    @Override
    public HomepageLinksDistribution getToHomepageVsToOtherPagesBacklinks() {
        int n2 = this.a.getTotalBacklinkCount();
        int n3 = this.a.getTotalBacklinksToHomepage();
        int n4 = this.a.getTotalBacklinksToOtherPages();
        return new HomepageLinksDistribution(n2, n3, n4);
    }

    @Override
    public List<CountryResult> getTopCountries() {
        boolean bl = b;
        ArrayList<CountryResult> arrayList = new ArrayList<CountryResult>();
        double d2 = this.a.getTotalLinkingDomainsCount();
        for (CountryRecord countryRecord : this.a.getCountryRecords()) {
            arrayList.add(new CountryResult(Country.getCountry((String)countryRecord.getCode()), countryRecord.getCount(), (double)countryRecord.getCount() / d2));
            if (!bl) continue;
        }
        return arrayList;
    }

    @Override
    public List<TLDResult> getTopTLDs() {
        boolean bl = b;
        ArrayList<TLDResult> arrayList = new ArrayList<TLDResult>();
        double d2 = this.a.getTotalLinkingDomainsCount();
        for (TLDRecord tLDRecord : this.a.getTopTlds()) {
            arrayList.add(new TLDResult(tLDRecord.getTld(), tLDRecord.getCount(), 100.0 * (double)tLDRecord.getCount() / d2));
            if (!bl) continue;
        }
        return arrayList;
    }

    @Override
    public List<AnchorAltTextResult> getTopBacklinksAnchorTexts(boolean bl) {
        return bl ? this.b(this.a.getTopBacklinksAnchorTexts(), this.a.getTotalBacklinkCount()) : this.a(this.a.getTopBacklinksAnchorTexts(), this.a.getTotalBacklinkCount());
    }

    private List<AnchorAltTextResult> a(Iterable<AnchorTextRecord> iterable, int n2) {
        boolean bl = b;
        ImmutableListMultimap immutableListMultimap = Multimaps.index(iterable, AnchorTextRecord::getText);
        ArrayList<AnchorAltTextResult> arrayList = new ArrayList<AnchorAltTextResult>();
        Map map = Maps.transformValues((Map)immutableListMultimap.asMap(), (Function)new a(this));
        for (Map.Entry entry : map.entrySet()) {
            arrayList.add(new AnchorAltTextResult((String)entry.getKey(), null, ((Integer)entry.getValue()).intValue(), 100.0 * (double)((Integer)entry.getValue()).intValue() / (double)n2));
            if (!bl) continue;
        }
        Collections.sort(arrayList, new b(this));
        return arrayList;
    }

    @Override
    public List<AnchorAltTextResult> getTopLinkingDomainsAnchorTexts() {
        return this.b(this.a.getTopLinkingDomainsAnchorTexts(), this.a.getTotalLinkingDomainsCount());
    }

    private List<AnchorAltTextResult> b(Iterable<AnchorTextRecord> iterable, int n2) {
        boolean bl = b;
        ArrayList<AnchorAltTextResult> arrayList = new ArrayList<AnchorAltTextResult>();
        for (AnchorTextRecord anchorTextRecord : iterable) {
            arrayList.add(new AnchorAltTextResult(anchorTextRecord.getText(), anchorTextRecord.getAnchorType(), anchorTextRecord.getCount(), 100.0 * (double)anchorTextRecord.getCount() / (double)n2));
            if (!bl) continue;
        }
        return arrayList;
    }

    @Override
    public List<AnchorUrlResult> getTopBacklinkAnchorUrls() {
        return this.c(this.a.getTopBacklinksAnchorUrls(), this.a.getTotalBacklinkCount());
    }

    @Override
    public List<AnchorUrlResult> getTopLinkingDomainsAnchorUrls() {
        return this.c(this.a.getTopLinkingDomainsAnchorUrls(), this.a.getTotalLinkingDomainsCount());
    }

    private List<AnchorUrlResult> c(Iterable<AnchorUrlRecord> iterable, int n2) {
        boolean bl = b;
        ArrayList<AnchorUrlResult> arrayList = new ArrayList<AnchorUrlResult>();
        for (AnchorUrlRecord anchorUrlRecord : iterable) {
            arrayList.add(new AnchorUrlResult(anchorUrlRecord.getUrl(), anchorUrlRecord.getCount(), 100.0 * (double)anchorUrlRecord.getCount() / (double)n2));
            if (!bl) continue;
        }
        return arrayList;
    }

    @Override
    public NavigableMap<Date, Integer> getTotalBacklinksHistory(Date date, Date date2) {
        return this.a(date, date2, this.a.getTotalBacklinksHistory(), this.a.getTotalBacklinkCount());
    }

    @Override
    public NavigableMap<Date, Integer> getTotalLinkingDomainsHistory(Date date, Date date2) {
        return this.a(date, date2, this.a.getTotalLinkingDomainsHistory(), this.a.getTotalLinkingDomainsCount());
    }

    private NavigableMap<Date, Integer> a(Date date, Date date2, Map<Date, Integer> map, int n2) {
        TreeMap<Date, Integer> treeMap;
        boolean bl = b;
        date = DateUtil.getStartDay((Date)date);
        TreeMap<Date, Integer> treeMap2 = new TreeMap<Date, Integer>();
        if (map.isEmpty()) {
            return treeMap2;
        }
        Date date3 = (treeMap = new TreeMap<Date, Integer>(map)).ceilingKey(date);
        NavigableMap navigableMap = treeMap.subMap(date3 == null ? (Date)treeMap.firstKey() : date3, true, (Date)treeMap.lastKey(), true);
        int n3 = 0;
        for (Map.Entry object : navigableMap.entrySet()) {
            treeMap2.put((Date)object.getKey(), n3 += ((Integer)object.getValue()).intValue());
            if (!bl) continue;
        }
        treeMap2.put(date2, n3);
        int n4 = n2 - n3;
        for (Map.Entry entry : treeMap2.entrySet()) {
            entry.setValue((Integer)entry.getValue() + n4);
            if (!bl) continue;
        }
        if (date3 == null || !date.after(date3)) {
            treeMap2.put(date, n4);
        }
        return treeMap2;
    }
}

