/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.lexer;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.util.Vector;
import org.htmlparser.Node;
import org.htmlparser.NodeFactory;
import org.htmlparser.Remark;
import org.htmlparser.Tag;
import org.htmlparser.Text;
import org.htmlparser.http.ConnectionManager;
import org.htmlparser.lexer.Cursor;
import org.htmlparser.lexer.Page;
import org.htmlparser.lexer.PageAttribute;
import org.htmlparser.nodes.RemarkNode;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.util.ParserException;

public class Lexer
implements Serializable,
NodeFactory {
    public static final double VERSION_NUMBER = 2.0;
    public static final String VERSION_TYPE;
    public static final String VERSION_DATE;
    public static final String VERSION_STRING;
    public static boolean STRICT_REMARKS;
    protected Page mPage;
    protected Cursor mCursor;
    protected NodeFactory mFactory;
    protected static int mDebugLineTrigger;
    private static final String[] a;

    public static String getVersion() {
        return a[2];
    }

    public Lexer() {
        this(new Page(""));
    }

    public Lexer(Page page) {
        this.setPage(page);
        this.setCursor(new Cursor(page, 0));
        this.setNodeFactory(this);
    }

    public Lexer(String string) {
        this(new Page(string));
    }

    public Lexer(URLConnection uRLConnection) throws ParserException {
        this(new Page(uRLConnection));
    }

    public Page getPage() {
        return this.mPage;
    }

    public void setPage(Page page) {
        if (null == page) {
            throw new IllegalArgumentException(a[0]);
        }
        this.mPage = page;
    }

    public Cursor getCursor() {
        return this.mCursor;
    }

    public void setCursor(Cursor cursor) {
        if (null == cursor) {
            throw new IllegalArgumentException(a[1]);
        }
        this.mCursor = cursor;
    }

    public NodeFactory getNodeFactory() {
        return this.mFactory;
    }

    public void setNodeFactory(NodeFactory nodeFactory) {
        if (null == nodeFactory) {
            throw new IllegalArgumentException(a[4]);
        }
        this.mFactory = nodeFactory;
    }

    public int getPosition() {
        return this.getCursor().getPosition();
    }

    public void setPosition(int n) {
        this.getCursor().setPosition(n);
    }

    public int getCurrentLineNumber() {
        return this.getPage().row(this.getCursor());
    }

    public String getCurrentLine() {
        return this.getPage().getLine(this.getCursor());
    }

    public void reset() {
        this.getPage().reset();
        this.setCursor(new Cursor(this.getPage(), 0));
    }

    public Node nextNode() throws ParserException {
        return this.nextNode(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node nextNode(boolean bl) throws ParserException {
        Page page;
        int n;
        boolean bl2 = Page.b;
        if (-1 != mDebugLineTrigger && mDebugLineTrigger < (n = (page = this.getPage()).row(this.mCursor))) {
            mDebugLineTrigger = n + 1;
        }
        int n2 = this.mCursor.getPosition();
        char c2 = this.mPage.getCharacter(this.mCursor);
        switch (c2) {
            case '\uffff': {
                Node node = null;
                if (!bl2) return node;
            }
            case '<': {
                Node node;
                c2 = this.mPage.getCharacter(this.mCursor);
                if ('\uffff' == c2) {
                    node = this.makeString(n2, this.mCursor.getPosition());
                    if (!bl2) return node;
                }
                if ('%' == c2) {
                    this.mPage.ungetCharacter(this.mCursor);
                    node = this.parseJsp(n2);
                    if (!bl2) return node;
                }
                if ('?' == c2) {
                    this.mPage.ungetCharacter(this.mCursor);
                    node = this.parsePI(n2);
                    if (!bl2) return node;
                }
                if ('/' == c2 || Character.isLetter(c2)) {
                    this.mPage.ungetCharacter(this.mCursor);
                    node = this.parseTag(n2);
                    if (!bl2) return node;
                }
                if ('!' == c2) {
                    c2 = this.mPage.getCharacter(this.mCursor);
                    if ('\uffff' == c2) {
                        node = this.makeString(n2, this.mCursor.getPosition());
                        if (!bl2) return node;
                    }
                    if ('>' == c2) {
                        node = this.makeRemark(n2, this.mCursor.getPosition());
                        if (!bl2) return node;
                    }
                    this.mPage.ungetCharacter(this.mCursor);
                    if ('-' == c2) {
                        node = this.parseRemark(n2, bl);
                        if (!bl2) return node;
                    }
                    this.mPage.ungetCharacter(this.mCursor);
                    node = this.parseTag(n2);
                    if (!bl2) return node;
                }
                this.mPage.ungetCharacter(this.mCursor);
                node = this.parseString(n2, bl);
                if (!bl2) return node;
            }
            default: {
                this.mPage.ungetCharacter(this.mCursor);
                return this.parseString(n2, bl);
            }
        }
    }

    public Node parseCDATA() throws ParserException {
        return this.parseCDATA(false);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node parseCDATA(boolean var1_1) throws ParserException {
        var9_2 = Page.b;
        var2_3 = this.mCursor.getPosition();
        var3_4 = 0;
        var4_5 = false;
        var5_6 = '\u0000';
        var8_7 = false;
        block23: while (true) {
            if (var4_5) {
                var7_9 = this.mCursor.getPosition();
                return this.makeString(var2_3, var7_9);
            }
            var6_8 = this.mPage.getCharacter(this.mCursor);
            switch (var3_4) {
                case 0: {
                    switch (var6_8) {
                        case '\uffff': {
                            var4_5 = true;
                            if (!var9_2) continue block23;
                        }
                        case '\'': {
                            if (!var1_1 || var8_7) continue block23;
                            if ('\u0000' == var5_6) {
                                var5_6 = '\'';
                                if (!var9_2) continue block23;
                            }
                            if (39 != var5_6) continue block23;
                            var5_6 = '\u0000';
                            if (!var9_2) continue block23;
                        }
                        case '\"': {
                            if (!var1_1 || var8_7) continue block23;
                            if ('\u0000' == var5_6) {
                                var5_6 = '\"';
                                if (!var9_2) continue block23;
                            }
                            if (34 != var5_6) continue block23;
                            var5_6 = '\u0000';
                            if (!var9_2) continue block23;
                        }
                        case '\\': {
                            if (!var1_1 || false == var5_6) continue block23;
                            var6_8 = this.mPage.getCharacter(this.mCursor);
                            if ('\uffff' == var6_8) {
                                var4_5 = true;
                                if (!var9_2) continue block23;
                            }
                            if (var6_8 == '\\' || var6_8 == var5_6) continue block23;
                            this.mPage.ungetCharacter(this.mCursor);
                            if (!var9_2) continue block23;
                        }
                        case '/': {
                            if (!var1_1 || false != var5_6) continue block23;
                            var6_8 = this.mPage.getCharacter(this.mCursor);
                            if ('\uffff' == var6_8) {
                                var4_5 = true;
                                if (!var9_2) continue block23;
                            }
                            if ('/' == var6_8) {
                                var8_7 = true;
                                if (!var9_2) continue block23;
                            }
                            if ('*' == var6_8) {
                                while (true) {
                                    if ('\uffff' != (var6_8 = this.mPage.getCharacter(this.mCursor)) && '*' != var6_8) {
                                        continue;
                                    }
                                    var6_8 = this.mPage.getCharacter(this.mCursor);
                                    if (var6_8 == '*') {
                                        this.mPage.ungetCharacter(this.mCursor);
                                    }
                                    if ('\uffff' == var6_8 || '/' == var6_8) break;
                                }
                                continue block23;
                            }
                            this.mPage.ungetCharacter(this.mCursor);
                            if (!var9_2) continue block23;
                        }
                        case '\n': {
                            var8_7 = false;
                            if (!var9_2) continue block23;
                        }
                        case '<': {
                            if (var1_1) {
                                if (false != var5_6) continue block23;
                                var3_4 = 1;
                                if (!var9_2) continue block23;
                            }
                            var3_4 = 1;
                            if (!var9_2) ** break;
                            break;
                        }
                    }
                    if (!var9_2) continue block23;
                }
                case 1: {
                    switch (var6_8) {
                        case '\uffff': {
                            var4_5 = true;
                            if (!var9_2) continue block23;
                        }
                        case '/': {
                            var3_4 = 2;
                            if (!var9_2) continue block23;
                        }
                        case '!': {
                            var6_8 = this.mPage.getCharacter(this.mCursor);
                            if ('\uffff' == var6_8) {
                                var4_5 = true;
                                if (!var9_2) continue block23;
                            }
                            if ('-' == var6_8) {
                                var6_8 = this.mPage.getCharacter(this.mCursor);
                                if ('\uffff' == var6_8) {
                                    var4_5 = true;
                                    if (!var9_2) continue block23;
                                }
                                if ('-' == var6_8) {
                                    var3_4 = 3;
                                    if (!var9_2) continue block23;
                                }
                                var3_4 = 0;
                                if (!var9_2) continue block23;
                            }
                            var3_4 = 0;
                            if (!var9_2) ** break;
                            break;
                        }
                    }
                    var3_4 = 0;
                    if (!var9_2) continue block23;
                }
                case 2: {
                    var8_7 = false;
                    if ('\uffff' == var6_8) {
                        var4_5 = true;
                        if (!var9_2) continue block23;
                    }
                    if (Character.isLetter(var6_8)) {
                        var4_5 = true;
                        this.mPage.ungetCharacter(this.mCursor);
                        this.mPage.ungetCharacter(this.mCursor);
                        this.mPage.ungetCharacter(this.mCursor);
                        if (!var9_2) continue block23;
                    }
                    var3_4 = 0;
                    if (!var9_2) continue block23;
                }
                case 3: {
                    var8_7 = false;
                    if ('\uffff' == var6_8) {
                        var4_5 = true;
                        if (!var9_2) continue block23;
                    }
                    if ('-' != var6_8) continue block23;
                    var6_8 = this.mPage.getCharacter(this.mCursor);
                    if ('\uffff' == var6_8) {
                        var4_5 = true;
                        if (!var9_2) continue block23;
                    }
                    if ('-' == var6_8) {
                        var6_8 = this.mPage.getCharacter(this.mCursor);
                        if ('\uffff' == var6_8) {
                            var4_5 = true;
                            if (!var9_2) continue block23;
                        }
                        if ('>' == var6_8) {
                            var3_4 = 0;
                            if (!var9_2) continue block23;
                        }
                        this.mPage.ungetCharacter(this.mCursor);
                        this.mPage.ungetCharacter(this.mCursor);
                        if (!var9_2) continue block23;
                    }
                    this.mPage.ungetCharacter(this.mCursor);
                    if (var9_2) throw new IllegalStateException(Lexer.a[11] + var3_4);
                    continue block23;
                }
            }
            break;
        }
        throw new IllegalStateException(Lexer.a[11] + var3_4);
    }

    @Override
    public Text createStringNode(Page page, int n, int n2) {
        return new TextNode(page, n, n2);
    }

    @Override
    public Remark createRemarkNode(Page page, int n, int n2) {
        return new RemarkNode(page, n, n2);
    }

    @Override
    public Tag createTagNode(Page page, int n, int n2, Vector vector) {
        return new TagNode(page, n, n2, vector);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void scanJIS(Cursor cursor) throws ParserException {
        boolean bl = Page.b;
        boolean bl2 = false;
        int n = 0;
        block9: while (true) {
            if (bl2) {
                return;
            }
            char c2 = this.mPage.getCharacter(cursor);
            if ('\uffff' == c2) {
                bl2 = true;
                if (!bl) continue;
            }
            switch (n) {
                case 0: {
                    if ('\u001b' != c2) continue block9;
                    n = 1;
                    if (!bl) continue block9;
                }
                case 1: {
                    if ('(' == c2) {
                        n = 2;
                        if (!bl) continue block9;
                    }
                    n = 0;
                    if (!bl) continue block9;
                }
                case 2: {
                    if ('B' == c2 || 'J' == c2 || 'H' == c2 || 'I' == c2) {
                        bl2 = true;
                        if (!bl) continue block9;
                    }
                    n = 0;
                    if (bl) throw new IllegalStateException(a[5] + n);
                    continue block9;
                }
            }
            break;
        }
        throw new IllegalStateException(a[5] + n);
    }

    protected Node parseString(int n, boolean bl) throws ParserException {
        boolean bl2 = Page.b;
        boolean bl3 = false;
        char c2 = '\u0000';
        while (!bl3) {
            block51: {
                block50: {
                    char c3;
                    block49: {
                        block48: {
                            block47: {
                                block45: {
                                    block46: {
                                        c3 = this.mPage.getCharacter(this.mCursor);
                                        if ('\uffff' == c3) {
                                            bl3 = true;
                                            if (!bl2) continue;
                                        }
                                        if ('\u001b' == c3) {
                                            c3 = this.mPage.getCharacter(this.mCursor);
                                            if ('\uffff' == c3) {
                                                bl3 = true;
                                                if (!bl2) continue;
                                            }
                                            if ('$' == c3) {
                                                block44: {
                                                    c3 = this.mPage.getCharacter(this.mCursor);
                                                    if ('\uffff' == c3) {
                                                        bl3 = true;
                                                        if (!bl2) continue;
                                                    }
                                                    if ('@' != c3 && 'B' != c3) break block44;
                                                    this.scanJIS(this.mCursor);
                                                    if (!bl2) continue;
                                                }
                                                this.mPage.ungetCharacter(this.mCursor);
                                                this.mPage.ungetCharacter(this.mCursor);
                                                if (!bl2) continue;
                                            }
                                            this.mPage.ungetCharacter(this.mCursor);
                                            if (!bl2) continue;
                                        }
                                        if (!bl || false != c2) break block45;
                                        if ('\'' == c3) break block46;
                                        if ('\"' != c3) break block45;
                                    }
                                    c2 = c3;
                                    if (!bl2) continue;
                                }
                                if (!bl || false == c2) break block47;
                                if ('\\' != c3) break block47;
                                c3 = this.mPage.getCharacter(this.mCursor);
                                if ('\uffff' == c3 || '\\' == c3 || c3 == c2) continue;
                                this.mPage.ungetCharacter(this.mCursor);
                                if (!bl2) continue;
                            }
                            if (!bl || c3 != c2) break block48;
                            c2 = '\u0000';
                            if (!bl2) continue;
                        }
                        if (!bl || '\u0000' != c2) break block49;
                        if (c3 != '/') break block49;
                        c3 = this.mPage.getCharacter(this.mCursor);
                        if ('\uffff' == c3) {
                            bl3 = true;
                            if (!bl2) continue;
                        }
                        if ('/' == c3) {
                            while ('\uffff' != (c3 = this.mPage.getCharacter(this.mCursor)) && '\n' != c3) {
                            }
                            continue;
                        }
                        if ('*' == c3) {
                            while (true) {
                                if ('\uffff' != (c3 = this.mPage.getCharacter(this.mCursor)) && '*' != c3) {
                                    continue;
                                }
                                c3 = this.mPage.getCharacter(this.mCursor);
                                if (c3 == '*') {
                                    this.mPage.ungetCharacter(this.mCursor);
                                }
                                if ('\uffff' == c3 || '/' == c3) break;
                            }
                            continue;
                        }
                        this.mPage.ungetCharacter(this.mCursor);
                        if (!bl2) continue;
                    }
                    if ('\u0000' != c2 || '<' != c3) continue;
                    c3 = this.mPage.getCharacter(this.mCursor);
                    if ('\uffff' == c3) {
                        bl3 = true;
                        if (!bl2) continue;
                    }
                    if ('/' == c3 || Character.isLetter(c3)) break block50;
                    if ('!' == c3) break block50;
                    if ('%' == c3) break block50;
                    if ('?' != c3) break block51;
                }
                bl3 = true;
                this.mPage.ungetCharacter(this.mCursor);
                this.mPage.ungetCharacter(this.mCursor);
                if (!bl2) continue;
            }
            this.mPage.ungetCharacter(this.mCursor);
            if (!bl2) continue;
        }
        return this.makeString(n, this.mCursor.getPosition());
    }

    protected Node makeString(int n, int n2) throws ParserException {
        Text text;
        block3: {
            block2: {
                int n3 = n2 - n;
                if (0 == n3) break block2;
                text = this.getNodeFactory().createStringNode(this.getPage(), n, n2);
                if (!Page.b) break block3;
            }
            text = null;
        }
        return text;
    }

    private void a(Vector vector, int[] nArray) {
        if (nArray[1] > nArray[0]) {
            vector.addElement(new PageAttribute(this.mPage, -1, -1, nArray[0], nArray[1], '\u0000'));
        }
    }

    private void b(Vector vector, int[] nArray) {
        vector.addElement(new PageAttribute(this.mPage, nArray[1], nArray[2], -1, -1, '\u0000'));
    }

    private void c(Vector vector, int[] nArray) {
        vector.addElement(new PageAttribute(this.mPage, nArray[1], nArray[2], nArray[2] + 1, -1, '\u0000'));
    }

    private void d(Vector vector, int[] nArray) {
        vector.addElement(new PageAttribute(this.mPage, nArray[1], nArray[2], nArray[3], nArray[4], '\u0000'));
    }

    private void e(Vector vector, int[] nArray) {
        vector.addElement(new PageAttribute(this.mPage, nArray[1], nArray[2], nArray[4] + 1, nArray[5], '\''));
    }

    private void f(Vector vector, int[] nArray) {
        vector.addElement(new PageAttribute(this.mPage, nArray[1], nArray[2], nArray[5] + 1, nArray[6], '\"'));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Node parseTag(int n) throws ParserException {
        boolean bl = Page.b;
        boolean bl2 = false;
        Vector vector = new Vector();
        int n2 = 0;
        int[] nArray = new int[8];
        nArray[0] = this.mCursor.getPosition();
        block22: while (true) {
            if (bl2) {
                return this.makeTag(n, this.mCursor.getPosition(), vector);
            }
            nArray[n2 + 1] = this.mCursor.getPosition();
            char c2 = this.mPage.getCharacter(this.mCursor);
            switch (n2) {
                case 0: {
                    if ('\uffff' == c2 || '>' == c2 || '<' == c2) {
                        if ('<' == c2) {
                            this.mPage.ungetCharacter(this.mCursor);
                            nArray[n2 + 1] = this.mCursor.getPosition();
                        }
                        this.a(vector, nArray);
                        bl2 = true;
                        if (!bl) continue block22;
                    }
                    if (Character.isWhitespace(c2)) continue block22;
                    this.a(vector, nArray);
                    n2 = 1;
                    if (!bl) continue block22;
                }
                case 1: {
                    if ('\uffff' == c2 || '>' == c2 || '<' == c2) {
                        if ('<' == c2) {
                            this.mPage.ungetCharacter(this.mCursor);
                            nArray[n2 + 1] = this.mCursor.getPosition();
                        }
                        this.b(vector, nArray);
                        bl2 = true;
                        if (!bl) continue block22;
                    }
                    if (Character.isWhitespace(c2)) {
                        nArray[6] = nArray[2];
                        n2 = 6;
                        if (!bl) continue block22;
                    }
                    if ('=' != c2) continue block22;
                    n2 = 2;
                    if (!bl) continue block22;
                }
                case 2: {
                    if ('\uffff' == c2 || '>' == c2) {
                        this.c(vector, nArray);
                        bl2 = true;
                        if (!bl) continue block22;
                    }
                    if ('\'' == c2) {
                        n2 = 4;
                        nArray[4] = nArray[3];
                        if (!bl) continue block22;
                    }
                    if ('\"' == c2) {
                        n2 = 5;
                        nArray[5] = nArray[3];
                        if (!bl) continue block22;
                    }
                    if (Character.isWhitespace(c2)) continue block22;
                    n2 = 3;
                    if (!bl) continue block22;
                }
                case 3: {
                    if ('\uffff' == c2 || '>' == c2) {
                        this.d(vector, nArray);
                        bl2 = true;
                        if (!bl) continue block22;
                    }
                    if (!Character.isWhitespace(c2)) continue block22;
                    this.d(vector, nArray);
                    nArray[0] = nArray[4];
                    n2 = 0;
                    if (!bl) continue block22;
                }
                case 4: {
                    if ('\uffff' == c2) {
                        this.e(vector, nArray);
                        bl2 = true;
                        if (!bl) continue block22;
                    }
                    if ('\'' != c2) continue block22;
                    this.e(vector, nArray);
                    nArray[0] = nArray[5] + 1;
                    n2 = 0;
                    if (!bl) continue block22;
                }
                case 5: {
                    if ('\uffff' == c2) {
                        this.f(vector, nArray);
                        bl2 = true;
                        if (!bl) continue block22;
                    }
                    if ('\"' != c2) continue block22;
                    this.f(vector, nArray);
                    nArray[0] = nArray[6] + 1;
                    n2 = 0;
                    if (!bl) continue block22;
                }
                case 6: {
                    if ('\uffff' == c2) {
                        this.b(vector, nArray);
                        nArray[0] = nArray[6];
                        this.mPage.ungetCharacter(this.mCursor);
                        n2 = 0;
                        if (!bl) continue block22;
                    }
                    if (Character.isWhitespace(c2)) continue block22;
                    if ('=' == c2) {
                        nArray[2] = nArray[6];
                        nArray[3] = nArray[7];
                        n2 = 2;
                        if (!bl) continue block22;
                    }
                    this.b(vector, nArray);
                    nArray[0] = nArray[6];
                    this.mPage.ungetCharacter(this.mCursor);
                    n2 = 0;
                    if (bl) throw new IllegalStateException(a[8] + n2);
                    continue block22;
                }
            }
            break;
        }
        throw new IllegalStateException(a[8] + n2);
    }

    protected Node makeTag(int n, int n2, Vector vector) throws ParserException {
        Tag tag;
        block8: {
            block6: {
                block7: {
                    int n3 = n2 - n;
                    if (0 == n3) break block6;
                    if (2 <= n3) break block7;
                    return this.makeString(n, n2);
                }
                tag = this.getNodeFactory().createTagNode(this.getPage(), n, n2, vector);
                if (!Page.b) break block8;
            }
            tag = null;
        }
        return tag;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Node parseRemark(int n, boolean bl) throws ParserException {
        boolean bl2 = Page.b;
        boolean bl3 = false;
        int n2 = 0;
        block11: while (true) {
            if (bl3) {
                return this.makeRemark(n, this.mCursor.getPosition());
            }
            char c2 = this.mPage.getCharacter(this.mCursor);
            if ('\uffff' == c2) {
                bl3 = true;
                if (!bl2) continue;
            }
            switch (n2) {
                case 0: {
                    if ('>' == c2) {
                        bl3 = true;
                    }
                    if ('-' != c2) return this.parseString(n, bl);
                    n2 = 1;
                    if (!bl2) continue block11;
                    return this.parseString(n, bl);
                }
                case 1: {
                    if ('-' != c2) return this.parseString(n, bl);
                    c2 = this.mPage.getCharacter(this.mCursor);
                    if ('\uffff' == c2) {
                        bl3 = true;
                        if (!bl2) continue block11;
                    }
                    if ('>' == c2) {
                        bl3 = true;
                        if (!bl2) continue block11;
                    }
                    this.mPage.ungetCharacter(this.mCursor);
                    n2 = 2;
                    if (!bl2) continue block11;
                    return this.parseString(n, bl);
                }
                case 2: {
                    if ('-' == c2) {
                        n2 = 3;
                        if (!bl2) continue block11;
                    }
                    if ('\uffff' != c2) continue block11;
                    return this.parseString(n, bl);
                }
                case 3: {
                    if ('-' == c2) {
                        n2 = 4;
                        if (!bl2) continue block11;
                    }
                    n2 = 2;
                    if (!bl2) continue block11;
                }
                case 4: {
                    if ('>' == c2) {
                        bl3 = true;
                        if (!bl2) continue block11;
                    }
                    if (Character.isWhitespace(c2) || !STRICT_REMARKS && ('-' == c2 || '!' == c2)) continue block11;
                    n2 = 2;
                    if (bl2) throw new IllegalStateException(a[3] + n2);
                    continue block11;
                }
            }
            break;
        }
        throw new IllegalStateException(a[3] + n2);
    }

    protected Node makeRemark(int n, int n2) throws ParserException {
        Remark remark;
        block8: {
            block6: {
                block7: {
                    int n3 = n2 - n;
                    if (0 == n3) break block6;
                    if (2 <= n3) break block7;
                    return this.makeString(n, n2);
                }
                remark = this.getNodeFactory().createRemarkNode(this.getPage(), n, n2);
                if (!Page.b) break block8;
            }
            remark = null;
        }
        return remark;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Node parseJsp(int var1_1) throws ParserException {
        var7_2 = Page.b;
        var2_3 = false;
        var4_4 = 0;
        var6_5 = 0;
        var5_6 = new Vector<PageAttribute>();
        block37: while (!var2_3) {
            var3_7 = this.mPage.getCharacter(this.mCursor);
            switch (var4_4) {
                case 0: {
                    switch (var3_7) {
                        case '%': {
                            var4_4 = 1;
                            if (!var7_2) ** break;
                            break;
                        }
                    }
                    var2_3 = true;
                    if (!var7_2) continue block37;
                }
                case 1: {
                    switch (var3_7) {
                        case '>': 
                        case '\uffff': {
                            var2_3 = true;
                            if (!var7_2) continue block37;
                        }
                        case '=': 
                        case '@': {
                            var6_5 = this.mCursor.getPosition();
                            var5_6.addElement(new PageAttribute(this.mPage, var1_1 + 1, var6_5, -1, -1, '\u0000'));
                            var4_4 = 2;
                            if (!var7_2) ** break;
                            break;
                        }
                    }
                    var6_5 = this.mCursor.getPosition() - 1;
                    var5_6.addElement(new PageAttribute(this.mPage, var1_1 + 1, var6_5, -1, -1, '\u0000'));
                    var4_4 = 2;
                    if (!var7_2) continue block37;
                }
                case 2: {
                    switch (var3_7) {
                        case '>': 
                        case '\uffff': {
                            var2_3 = true;
                            if (!var7_2) continue block37;
                        }
                        case '\"': 
                        case '\'': {
                            var4_4 = var3_7;
                            if (!var7_2) continue block37;
                        }
                        case '%': {
                            var4_4 = 3;
                            if (!var7_2) continue block37;
                        }
                        case '/': {
                            var3_7 = this.mPage.getCharacter(this.mCursor);
                            if (var3_7 == '/') {
                                do {
                                    if ((var3_7 = this.mPage.getCharacter(this.mCursor)) == '\uffff') {
                                        var2_3 = true;
                                        if (!var7_2) continue block37;
                                    }
                                    if (var3_7 == '\n') continue block37;
                                } while (var3_7 != '\r');
                                if (!var7_2) continue block37;
                            }
                            if (var3_7 == '*') {
                                while (true) {
                                    if ('\uffff' != (var3_7 = this.mPage.getCharacter(this.mCursor)) && '*' != var3_7) {
                                        continue;
                                    }
                                    var3_7 = this.mPage.getCharacter(this.mCursor);
                                    if (var3_7 == '*') {
                                        this.mPage.ungetCharacter(this.mCursor);
                                    }
                                    if ('\uffff' == var3_7 || '/' == var3_7) break;
                                }
                                continue block37;
                            }
                            if (var3_7 == '\uffff') continue block37;
                            this.mPage.ungetCharacter(this.mCursor);
                            if (!var7_2) ** break;
                            break;
                        }
                    }
                    if (!var7_2) continue block37;
                }
                case 3: {
                    switch (var3_7) {
                        case '\uffff': {
                            var2_3 = true;
                            if (!var7_2) continue block37;
                        }
                        case '>': {
                            var4_4 = 4;
                            var2_3 = true;
                            if (!var7_2) ** break;
                            break;
                        }
                    }
                    var4_4 = 2;
                    if (!var7_2) continue block37;
                }
                case 34: {
                    switch (var3_7) {
                        case '\uffff': {
                            var2_3 = true;
                            if (!var7_2) continue block37;
                        }
                        case '\"': {
                            var4_4 = 2;
                            if (!var7_2) ** break;
                            break;
                        }
                    }
                    if (!var7_2) continue block37;
                }
                case 39: {
                    switch (var3_7) {
                        case '\uffff': {
                            var2_3 = true;
                            if (!var7_2) continue block37;
                        }
                        case '\'': {
                            var4_4 = 2;
                            if (!var7_2) ** break;
                            break;
                        }
                    }
                    if (!var7_2) ** break;
                    throw new IllegalStateException(Lexer.a[10] + var4_4);
                }
            }
            throw new IllegalStateException(Lexer.a[10] + var4_4);
        }
        if (4 != var4_4) {
            return this.parseString(var1_1, true);
        }
        if (false == var6_5) throw new IllegalStateException(Lexer.a[9]);
        var4_4 = this.mCursor.getPosition() - 2;
        var5_6.addElement(new PageAttribute(this.mPage, var6_5, var4_4, -1, -1, '\u0000'));
        var5_6.addElement(new PageAttribute(this.mPage, var4_4, var4_4 + 1, -1, -1, '\u0000'));
        if (var7_2) throw new IllegalStateException(Lexer.a[9]);
        return this.makeTag(var1_1, this.mCursor.getPosition(), var5_6);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Node parsePI(int var1_1) throws ParserException {
        var7_2 = Page.b;
        var2_3 = false;
        var4_4 = 0;
        var6_5 = 0;
        var5_6 = new Vector<PageAttribute>();
        block30: while (!var2_3) {
            var3_7 = this.mPage.getCharacter(this.mCursor);
            switch (var4_4) {
                case 0: {
                    switch (var3_7) {
                        case '?': {
                            var6_5 = this.mCursor.getPosition();
                            var5_6.addElement(new PageAttribute(this.mPage, var1_1 + 1, var6_5, -1, -1, '\u0000'));
                            var4_4 = 1;
                            if (!var7_2) ** break;
                            break;
                        }
                    }
                    var2_3 = true;
                    if (!var7_2) continue block30;
                }
                case 1: {
                    switch (var3_7) {
                        case '>': 
                        case '\uffff': {
                            var2_3 = true;
                            if (!var7_2) continue block30;
                        }
                        case '\"': 
                        case '\'': {
                            var4_4 = var3_7;
                            if (!var7_2) continue block30;
                        }
                        case '?': {
                            var4_4 = 2;
                            if (!var7_2) ** break;
                            break;
                        }
                    }
                    if (!var7_2) continue block30;
                }
                case 2: {
                    switch (var3_7) {
                        case '\uffff': {
                            var2_3 = true;
                            if (!var7_2) continue block30;
                        }
                        case '>': {
                            var4_4 = 3;
                            var2_3 = true;
                            if (!var7_2) ** break;
                            break;
                        }
                    }
                    var4_4 = 1;
                    if (!var7_2) continue block30;
                }
                case 34: {
                    switch (var3_7) {
                        case '\uffff': {
                            var2_3 = true;
                            if (!var7_2) continue block30;
                        }
                        case '\"': {
                            var4_4 = 1;
                            if (!var7_2) ** break;
                            break;
                        }
                    }
                    if (!var7_2) continue block30;
                }
                case 39: {
                    switch (var3_7) {
                        case '\uffff': {
                            var2_3 = true;
                            if (!var7_2) continue block30;
                        }
                        case '\'': {
                            var4_4 = 1;
                            if (!var7_2) ** break;
                            break;
                        }
                    }
                    if (!var7_2) ** break;
                    throw new IllegalStateException(Lexer.a[6] + var4_4);
                }
            }
            throw new IllegalStateException(Lexer.a[6] + var4_4);
        }
        if (3 != var4_4) {
            return this.parseString(var1_1, true);
        }
        if (false == var6_5) throw new IllegalStateException(Lexer.a[7]);
        var4_4 = this.mCursor.getPosition() - 2;
        var5_6.addElement(new PageAttribute(this.mPage, var6_5, var4_4, -1, -1, '\u0000'));
        var5_6.addElement(new PageAttribute(this.mPage, var4_4, var4_4 + 1, -1, -1, '\u0000'));
        if (var7_2) throw new IllegalStateException(Lexer.a[7]);
        return this.makeTag(var1_1, this.mCursor.getPosition(), var5_6);
    }

    public static void main(String[] stringArray) throws MalformedURLException, ParserException {
        block9: {
            boolean bl;
            block8: {
                bl = Page.b;
                if (0 < stringArray.length) break block8;
                System.out.println(a[13] + Lexer.getVersion() + "\n");
                System.out.println();
                System.out.println(a[12]);
                if (!bl) break block9;
            }
            try {
                Node node;
                ConnectionManager connectionManager = Page.getConnectionManager();
                Lexer lexer = new Lexer(connectionManager.openConnection(stringArray[0]));
                while (null != (node = lexer.nextNode(false))) {
                    System.out.println(node.toString());
                    if (!bl) continue;
                    break;
                }
            }
            catch (ParserException parserException) {
                System.out.println(parserException.getMessage());
                if (null != parserException.getThrowable()) {
                    System.out.println(parserException.getThrowable().getMessage());
                }
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[14];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\u0007u \u0015=&ul2)<|(";
        int n2 = 13;
        block24: while (true) {
            char[] cArray;
            block29: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block28: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block28;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block29;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 85;
                                break;
                            }
                            case 1: {
                                n8 = 16;
                                break;
                            }
                            case 2: {
                                n8 = 76;
                                break;
                            }
                            case 3: {
                                n8 = 112;
                                break;
                            }
                            default: {
                                n8 = 92;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                case 13: {
                    VERSION_TYPE = string.intern();
                    string2 = "g>|Pt\u0007u \u0015=&ul2)<|(P\u000f0`lAky0~@lc9";
                    n2 = 14;
                    continue block24;
                }
                case 14: {
                    VERSION_STRING = string.intern();
                    string2 = "\u0006u<Pmb<lBle&";
                    n2 = 15;
                    continue block24;
                }
                case 15: {
                    VERSION_DATE = string.intern();
                    string2 = "%q+\u0015|6q\"\u001e3!0.\u0015|;e \u001c";
                    n2 = -1;
                    continue block24;
                }
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "6e>\u00033'0/\u00112;\u007f8P>00\"\u000509";
                    n2 = 0;
                    continue block24;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "g>|Pt\u0007u \u0015=&ul2)<|(P\u000f0`lAky0~@lc9";
                    n2 = 1;
                    continue block24;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\u0006\u007f!\u00154:gl\u001d=;q+\u00158ud#P;0dl\u00192!\u007fl\u00192#q \u00198uc8\u0011(00l";
                    n2 = 2;
                    continue block24;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = ";\u007f(\u0015|3q/\u00043'il\u0013=;~#\u0004|7ul\u001e)9|";
                    n2 = 3;
                    continue block24;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "&d-\u00049u";
                    n2 = 4;
                    continue block24;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "\u0006\u007f!\u00154:gl\u001d=;q+\u00158ud#P;0dl\u00192!\u007fl\u00192#q \u00198uc8\u0011(00l";
                    n2 = 5;
                    continue block24;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "%b#\u00139&c%\u001e;uy\"\u0003('e/\u00045:~l\u00075!xl\u001e3us#\u001e(0~8";
                    n2 = 6;
                    continue block24;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "\u0006\u007f!\u00154:gl\u001d=;q+\u00158ud#P;0dl\u00192!\u007fl\u00192#q \u00198uc8\u0011(00l";
                    n2 = 7;
                    continue block24;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "?c<P+<d$P2:0/\u001f801";
                    n2 = 8;
                    continue block24;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "\u0006\u007f!\u00154:gl\u001d=;q+\u00158ud#P;0dl\u00192!\u007fl\u00192#q \u00198uc8\u0011(00l";
                    n2 = 9;
                    continue block24;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "\u0006\u007f!\u00154:gl\u001d=;q+\u00158ud#P;0dl\u00192!\u007fl\u00192#q \u00198uc8\u0011(00l";
                    n2 = 10;
                    continue block24;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = " c-\u00179o0&\u0011*40a\u001a='0$\u000419|)\b9'>&\u0011.u,9\u00020k";
                    n2 = 11;
                    continue block24;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = "\u001dD\u0001<|\u0019u4\u0015.uf";
                    n2 = 12;
                    continue block24;
                }
                case 12: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        a = stringArray3;
        STRICT_REMARKS = false;
        mDebugLineTrigger = -1;
    }
}

