/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.lexer;

import java.io.Serializable;
import org.htmlparser.lexer.Cursor;
import org.htmlparser.lexer.Page;
import org.htmlparser.util.sort.Ordered;
import org.htmlparser.util.sort.Sort;
import org.htmlparser.util.sort.Sortable;

public class PageIndex
implements Serializable,
Sortable {
    protected static final int mStartIncrement = 100;
    protected int mIncrement;
    protected int mCount;
    protected int[] mIndices;
    protected Page mPage;
    private static final String[] a;

    public PageIndex(Page page) {
        this.mIncrement = 100;
        this.mPage = page;
        this.mIndices = new int[this.mIncrement];
        this.mCount = 0;
        this.mIncrement *= 2;
    }

    public PageIndex(Page page, int n) {
        this(page);
        this.mIndices[0] = n;
        this.mCount = 1;
    }

    public PageIndex(Page page, int[] nArray) {
        this.mPage = page;
        this.mIndices = nArray;
        this.mCount = nArray.length;
    }

    public Page getPage() {
        return this.mPage;
    }

    public int size() {
        return this.mCount;
    }

    public int capacity() {
        return this.mIndices.length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int add(Cursor cursor) {
        int n;
        int n2;
        boolean bl = Page.b;
        int n3 = cursor.getPosition();
        if (0 == this.mCount) {
            n2 = 0;
            this.insertElementAt(n3, n2);
            if (!bl) return n2;
        }
        if (n3 == (n = this.mIndices[this.mCount - 1])) {
            n2 = this.mCount - 1;
            if (!bl) return n2;
        }
        if (n3 > n) {
            n2 = this.mCount;
            this.insertElementAt(n3, n2);
            if (!bl) return n2;
        }
        if ((n2 = Sort.bsearch(this, (Ordered)cursor)) < this.size()) {
            if (n3 == this.mIndices[n2]) return n2;
        }
        this.insertElementAt(n3, n2);
        return n2;
    }

    public int add(int n) {
        return this.add(new Cursor(this.getPage(), n));
    }

    public void remove(Cursor cursor) {
        block4: {
            int n = Sort.bsearch(this, (Ordered)cursor);
            if (n >= this.size() || cursor.getPosition() != this.mIndices[n]) break block4;
            this.removeElementAt(n);
        }
    }

    public void remove(int n) {
        this.remove(new Cursor(this.getPage(), n));
    }

    public int elementAt(int n) {
        if (n >= this.mCount) {
            throw new IndexOutOfBoundsException(a[0] + n + a[1]);
        }
        return this.mIndices[n];
    }

    public int row(Cursor cursor) {
        int n;
        block4: {
            n = Sort.bsearch(this, (Ordered)cursor);
            if (n >= this.mCount || cursor.getPosition() != this.mIndices[n]) break block4;
            ++n;
        }
        return n;
    }

    public int row(int n) {
        return this.row(new Cursor(this.getPage(), n));
    }

    public int column(Cursor cursor) {
        int n;
        block3: {
            block2: {
                int n2 = this.row(cursor);
                if (0 == n2) break block2;
                n = this.elementAt(n2 - 1);
                if (!Page.b) break block3;
            }
            n = 0;
        }
        return cursor.getPosition() - n;
    }

    public int column(int n) {
        return this.column(new Cursor(this.getPage(), n));
    }

    public int[] get() {
        int[] nArray = new int[this.size()];
        System.arraycopy(this.mIndices, 0, nArray, 0, this.size());
        return nArray;
    }

    protected int bsearch(int n) {
        return Sort.bsearch(this, (Ordered)new Cursor(this.getPage(), n));
    }

    protected int bsearch(int n, int n2, int n3) {
        return Sort.bsearch(this, (Ordered)new Cursor(this.getPage(), n), n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void insertElementAt(int n, int n2) {
        block15: {
            block12: {
                int[] nArray;
                boolean bl;
                block14: {
                    block13: {
                        bl = Page.b;
                        if (n2 < this.capacity() && this.size() != this.capacity()) break block12;
                        nArray = new int[Math.max(this.capacity() + this.mIncrement, n2 + 1)];
                        this.mIncrement *= 2;
                        if (n2 >= this.capacity()) break block13;
                        System.arraycopy(this.mIndices, 0, nArray, 0, n2);
                        System.arraycopy(this.mIndices, n2, nArray, n2 + 1, this.capacity() - n2);
                        if (!bl) break block14;
                    }
                    System.arraycopy(this.mIndices, 0, nArray, 0, this.capacity());
                }
                this.mIndices = nArray;
                if (!bl) break block15;
            }
            if (n2 < this.size()) {
                System.arraycopy(this.mIndices, n2, this.mIndices, n2 + 1, this.capacity() - (n2 + 1));
            }
        }
        this.mIndices[n2] = n;
        ++this.mCount;
    }

    protected void removeElementAt(int n) {
        System.arraycopy(this.mIndices, n + 1, this.mIndices, n, this.capacity() - (n + 1));
        this.mIndices[this.capacity() - 1] = 0;
        --this.mCount;
    }

    @Override
    public int first() {
        return 0;
    }

    @Override
    public int last() {
        return this.mCount - 1;
    }

    @Override
    public Ordered fetch(int n, Ordered ordered) {
        Cursor cursor;
        block3: {
            block2: {
                if (null == ordered) break block2;
                cursor = (Cursor)ordered;
                cursor.mPosition = this.mIndices[n];
                cursor.mPage = this.getPage();
                if (!Page.b) break block3;
            }
            cursor = new Cursor(this.getPage(), this.mIndices[n]);
        }
        return cursor;
    }

    @Override
    public void swap(int n, int n2) {
        int n3 = this.mIndices[n];
        this.mIndices[n] = this.mIndices[n2];
        this.mIndices[n2] = n3;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "+\u0006'~+b";
        int n2 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block13;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 66;
                                break;
                            }
                            case 1: {
                                n8 = 104;
                                break;
                            }
                            case 2: {
                                n8 = 67;
                                break;
                            }
                            case 3: {
                                n8 = 27;
                                break;
                            }
                            default: {
                                n8 = 83;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "b\n&b<,\fcx&0\u001a&u'b\u0004*v:6";
                    n2 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        a = stringArray3;
    }
}

