/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import javax.imageio.stream.ImageInputStreamImpl;

public final class ByteArrayImageInputStream
extends ImageInputStreamImpl {
    private final byte[] mData;

    public ByteArrayImageInputStream(byte[] pData) {
        Validate.notNull((Object)pData, (String)"data");
        this.mData = pData;
    }

    public int read() throws IOException {
        if (this.streamPos >= (long)this.mData.length) {
            return -1;
        }
        this.bitOffset = 0;
        return this.mData[(int)this.streamPos++] & 0xFF;
    }

    public int read(byte[] pBuffer, int pOffset, int pLength) throws IOException {
        if (this.streamPos >= (long)this.mData.length) {
            return -1;
        }
        int length = (int)Math.min((long)this.mData.length - this.streamPos, (long)pLength);
        this.bitOffset = 0;
        System.arraycopy(this.mData, (int)this.streamPos, pBuffer, pOffset, length);
        this.streamPos += (long)length;
        return length;
    }

    public long length() {
        return this.mData.length;
    }

    public boolean isCached() {
        return true;
    }

    public boolean isCachedMemory() {
        return true;
    }
}

