/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;

class IIOInputStreamAdapter
extends InputStream {
    private ImageInputStream mInput;
    private final boolean mHasLength;
    private long mLeft;
    private long mMarkPosition;

    public IIOInputStreamAdapter(ImageInputStream pInput) {
        this(pInput, -1L, false);
    }

    public IIOInputStreamAdapter(ImageInputStream pInput, long pLength) {
        this(pInput, pLength, true);
    }

    private IIOInputStreamAdapter(ImageInputStream pInput, long pLength, boolean pHasLength) {
        if (pInput == null) {
            throw new IllegalArgumentException("stream == null");
        }
        if (pHasLength && pLength < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        this.mInput = pInput;
        this.mHasLength = pHasLength;
        this.mLeft = pLength;
    }

    public void close() throws IOException {
        if (this.mHasLength) {
            this.mInput.seek(this.mInput.getStreamPosition() + this.mLeft);
        }
        this.mLeft = 0L;
        this.mInput = null;
    }

    public int available() throws IOException {
        if (this.mHasLength) {
            return this.mLeft > 0L ? (int)Math.min(Integer.MAX_VALUE, this.mLeft) : 0;
        }
        return 0;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int pReadLimit) {
        try {
            this.mMarkPosition = this.mInput.getStreamPosition();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read stream position: " + e.getMessage(), e);
        }
    }

    public void reset() throws IOException {
        long diff = this.mInput.getStreamPosition() - this.mMarkPosition;
        this.mInput.seek(this.mMarkPosition);
        this.mLeft += diff;
    }

    public int read() throws IOException {
        if (this.mHasLength && this.mLeft-- <= 0L) {
            this.mLeft = 0L;
            return -1;
        }
        return this.mInput.read();
    }

    public final int read(byte[] pBytes) throws IOException {
        return this.read(pBytes, 0, pBytes.length);
    }

    public int read(byte[] pBytes, int pOffset, int pLength) throws IOException {
        if (this.mHasLength && this.mLeft <= 0L) {
            return -1;
        }
        int read = this.mInput.read(pBytes, pOffset, (int)this.findMaxLen(pLength));
        if (this.mHasLength) {
            this.mLeft = read < 0 ? 0L : this.mLeft - (long)read;
        }
        return read;
    }

    private long findMaxLen(long pLength) {
        if (this.mHasLength && this.mLeft < pLength) {
            return Math.max(this.mLeft, 0L);
        }
        return Math.max(pLength, 0L);
    }

    public long skip(long pLength) throws IOException {
        long skipped = this.mInput.skipBytes(this.findMaxLen(pLength));
        this.mLeft -= skipped;
        return skipped;
    }
}

