function drawDonut(selector) {
    var element = d3.select(selector);

    var oLabel = $(selector).data("label");
    var data = $(selector).data("values");

    var colors = $(selector).data("colors") ? $(selector).data("colors") : null;

    var width = $(selector).data("size") ? $(selector).data("size") : element[0][0].clientWidth;
    var height = $(selector).data("size") ? $(selector).data("size") : element[0][0].clientHeight;


    var radius = Math.min(width, height) / 2;

    var colorCategory20 = d3.scale.category20();

    function getColor(d, i) {
        if (colors && colors[i])
            return colors[i];
        return colorCategory20(i);
    }

    var pie = d3.layout.pie()
            .sort(null);

    var arc = d3.svg.arc()
            .innerRadius(radius * 0.85)
            .outerRadius(radius);

    var svg = element.append("svg")
            .attr("width", width)
            .attr("height", height)
            .append("g")
            .attr("transform", "translate(" + width / 2 + "," + height / 2 + ")");

    var path = svg.selectAll("path")
            .data(pie(data))
            .enter().append("path")
            .attr("fill", getColor)
            .attr("d", arc);

    if (oLabel) {
        svg.append("text")
                .attr("x", function () {
                    return 0;
                })
                .attr("y", -20)
                .style('font-size', '11px')
                .style('font-family', 'Arial')
                .attr("dy", ".35em")
                .style('fill', '#909090')
                .style("text-anchor", "middle")
                .text(oLabel);

        svg.append("line")
                .attr("x1", -15)
                .attr("y1", -5)
                .attr("x2", 15)
                .attr("y2", -5)
                .style("stroke", "#dbdbdb");
    }


    if (oLabel && data.length === 2) {
        svg.append("text")
                .attr("x", function () {
                    return 0;
                })
                .attr("y", 18)
                .attr("dy", ".18em")
                .style('font-size', '28px')
                .style('font-weight', 'bold')
                .style('font-family', 'Arial')
                .style('fill', getColor)
                .style("text-anchor", "middle")
                .text(function () {
                    return (data[0] / (data[0] + data[1]) * 100).toFixed(1) + '%';
                });

        svg.append("text")
                .attr("x", function () {
                    return 0;
                })
                .attr("y", 40)
                .style('font-size', '12px')
                .style('font-family', 'Arial')
                .attr("dy", ".35em")
                .style('fill', '#4a4a4a')
                .style("text-anchor", "middle")
                .text(data[0].toLocaleString('en-En'));
    }
}

function drawRegionsMap(selector) {
    var element = selector[0];

    var valueName = selector.attr("back-name");
    var data = new google.visualization.DataTable();
    data.addColumn('string', 'Country');
    data.addColumn('number', valueName);
    data.addColumn('string', 'CountryName');
    data.addRows(selector.data("country"));

    var formatter = new google.visualization.PatternFormat('{0}');
    formatter.format(data, [0, 1], 0);
    var formatter = new google.visualization.PatternFormat('{2}');
    formatter.format(data, [0, 1, 2], 0);

    var view = new google.visualization.DataView(data);
    view.setColumns([0, 1]);
    var geoChart = new google.visualization.GeoChart(element);
    geoChart.draw(view, {
        colorAxis: {
            colors: ['#d3decc', '#bed5b0', '#a8cb95', '#93c279', '#7eb85d']
        },
        datalessRegionColor: '#e8e8e8',
        legend: 'none',
        tooltip: {
            textStyle: {
                color: '#4a4a4a'
            }
        }
    });
}

function convertDate(element, index, array) {
    array[index] = [new Date(element[0]), element[1]];
}

var lineAnimation = true;
function drawLineChart(selector) {
    var element = selector[0];
    var valueName = selector.attr("value-name");
    var data = new google.visualization.DataTable();
    data.addColumn('date', 'Day');
    data.addColumn('number', valueName);
    var values = selector.data("data");
    values.forEach(convertDate);
    data.addRows(values);


    var color = selector.attr("chart-color");
    var startDate;
    var endDate;
    if (values.length == 0) {
        startDate = new Date();
        endDate = new Date();
    } else {
        startDate = new Date(values[0][0]);
        endDate = new Date(values[values.length - 1][0]);
    }
    if (values.length == 1) {
        startDate.setMonth(values[0][0].getMonth() - 1);
        endDate.setMonth(values[values.length - 1][0].getMonth() + 1);
    }
    var from = selector.attr("from");
    if (from) {
        startDate = new Date(from)
    }
    var to = selector.attr("to");
    if (to) {
        endDate = new Date(to);
    }

    var lineChartOptions = {
        legend: 'none',
        colors: [color ? color : '#7ab658'],
        vAxis: {
            format: 'short',
            gridlines: {color: '#ebebeb'},
            textStyle: {color: '#cfcfcf', fontSize: 11},
            baselineColor: '#ebebeb',
            viewWindow:{
                min: 0
            }
        },
        hAxis: {
            format: 'MM.yy',
            gridlines: {color: '#ebebeb'},
            textStyle: {color: '#cfcfcf', fontSize: 11},
            viewWindow: {
                min: startDate,
                max: endDate
            }

        },
        tooltip: {
            textStyle: {
                color: '#4a4a4a',
                fontSize: 14
            }
        },
        chartArea: {
            left: 40,
            top: 10,
            bottom: 40,
            width: 1110,
            height: 350
        },
        animation: {
            startup: lineAnimation,
            easing: 'out',
            duration: lineAnimation ? 1200 : 0
        }

    };


    var lineChart = new google.visualization.AreaChart(element);

    lineChart.draw(data, lineChartOptions);
}


$(window).load(function () {

    google.charts.load('current', {
        'packages': ['corechart', 'geochart']
    });
    google.charts.setOnLoadCallback(draw);

    function draw() {
        if (typeof isLineAnimation === 'function')
            lineAnimation = isLineAnimation();

        $("div.donut-chart").each(function () {
            drawDonut(this);

        });

        $("div.progress-graph").each(function () {
            drawLineChart($(this));

        });

        $("div.regions-map").each(function () {
            drawRegionsMap($(this));
        });
        if (typeof afterDraw === 'function')
            afterDraw();
    }

});
