$(document).ready(function () {

    $(".container-wrapper").sortable({
        connectWith: ".container-wrapper",
        items: ".widget-wrapper:not(.static-widget)",
        handle: ".dd-area",
        placeholder: "widget-place",
        start: function (event, ui) {
            $(".widget-edit", ui.item).addClass("active");
            $(".widget-content", ui.item).hide();

        },
        stop: function (event, ui) {
            $(".widget-edit", ui.item).removeClass("active");
            $(".widget-content", ui.item).show();

            $(".dd-area", ui.item).empty();
        },
        cancel: ".static-widget",
        scroll: true,
        update: function (event, ui) {
            var arrayWidgets = $(".widget-wrapper").map(function () {
                return this.id;
            }).get();
            var toStringWidgets = arrayWidgets.join(',');
            updateWidgetsOrder(toStringWidgets);
        }
    });

    $(".widget-wrapper").map(function () {
        var self = this;
        $(".widget-edit .edit-link", self).click(function() {
            editWidget(self.id);
        })
    });

    $(".widget-wrapper").map(function () {
        var self = this;
        $(".widget-edit .delete-link", self).click(function() {
            deleteWidget(self.id);
        })
    });

    $(".widget-wrapper")
        .mouseenter(function () {
            $(".widget-edit", this).css("display", "flex");
            $(".widget-header", this).css("display", "none");

            var currentTitle = $(".widget-header", this).html();
            if (currentTitle) {
                $(".dd-area", this).append("<span class='active-title'>" + currentTitle + "</span>");
            }
            else {
                $(".dd-area", this).append("<span class='active-title'></span>");
            }
        })
        .mouseleave(function () {
            $(".widget-edit", this).css("display", "none");
            $(".widget-header", this).css("display", "block");

            $(".dd-area", this).empty();
        });

});