/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.Progressable;

public class DistributedFileSystem
extends FileSystem {
    private Path workingDir;
    private URI uri;
    DFSClient dfs;
    private boolean verifyChecksum = true;

    public DistributedFileSystem() {
    }

    public DistributedFileSystem(InetSocketAddress namenode, Configuration conf) throws IOException {
        this.initialize(NameNode.getUri(namenode), conf);
    }

    @Override
    public String getName() {
        return this.uri.getAuthority();
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
        String host = uri.getHost();
        if (host == null) {
            throw new IOException("Incomplete HDFS URI, no host: " + uri);
        }
        InetSocketAddress namenode = NameNode.getAddress(uri.getAuthority());
        this.dfs = new DFSClient(namenode, conf, this.statistics);
        this.uri = NameNode.getUri(namenode);
        this.workingDir = this.getHomeDirectory();
    }

    @Override
    protected void checkPath(Path path) {
        URI thisUri = this.getUri();
        URI thatUri = path.toUri();
        String thatAuthority = thatUri.getAuthority();
        if (thatUri.getScheme() != null && thatUri.getScheme().equalsIgnoreCase(thisUri.getScheme()) && thatUri.getPort() == 8020 && thisUri.getPort() == -1 && thatAuthority.substring(0, thatAuthority.indexOf(":")).equalsIgnoreCase(thisUri.getAuthority())) {
            return;
        }
        super.checkPath(path);
    }

    @Override
    public Path makeQualified(Path path) {
        URI thisUri = this.getUri();
        URI thatUri = path.toUri();
        String thatAuthority = thatUri.getAuthority();
        if (thatUri.getScheme() != null && thatUri.getScheme().equalsIgnoreCase(thisUri.getScheme()) && thatUri.getPort() == 8020 && thisUri.getPort() == -1 && thatAuthority.substring(0, thatAuthority.indexOf(":")).equalsIgnoreCase(thisUri.getAuthority())) {
            path = new Path(thisUri.getScheme(), thisUri.getAuthority(), thatUri.getPath());
        }
        return super.makeQualified(path);
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public long getDefaultBlockSize() {
        return this.dfs.getDefaultBlockSize();
    }

    @Override
    public short getDefaultReplication() {
        return this.dfs.getDefaultReplication();
    }

    private Path makeAbsolute(Path f) {
        if (f.isAbsolute()) {
            return f;
        }
        return new Path(this.workingDir, f);
    }

    @Override
    public void setWorkingDirectory(Path dir) {
        String result = this.makeAbsolute(dir).toUri().getPath();
        if (!DFSUtil.isValidName(result)) {
            throw new IllegalArgumentException("Invalid DFS directory name " + result);
        }
        this.workingDir = this.makeAbsolute(dir);
    }

    @Override
    public Path getHomeDirectory() {
        return new Path("/user/" + this.dfs.ugi.getUserName()).makeQualified(this);
    }

    private String getPathName(Path file) {
        this.checkPath(file);
        String result = this.makeAbsolute(file).toUri().getPath();
        if (!DFSUtil.isValidName(result)) {
            throw new IllegalArgumentException("Pathname " + result + " from " + file + " is not a valid DFS filename.");
        }
        return result;
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (file == null) {
            return null;
        }
        return this.dfs.getBlockLocations(this.getPathName(file.getPath()), start, len);
    }

    @Override
    public void setVerifyChecksum(boolean verifyChecksum) {
        this.verifyChecksum = verifyChecksum;
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return new DFSClient.DFSDataInputStream(this.dfs.open(this.getPathName(f), bufferSize, this.verifyChecksum, this.statistics));
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        DFSClient.DFSOutputStream op = (DFSClient.DFSOutputStream)this.dfs.append(this.getPathName(f), bufferSize, progress);
        return new FSDataOutputStream(op, this.statistics, op.getInitialLen());
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return new FSDataOutputStream(this.dfs.create(this.getPathName(f), permission, overwrite, replication, blockSize, progress, bufferSize), this.statistics);
    }

    @Override
    public boolean setReplication(Path src, short replication) throws IOException {
        return this.dfs.setReplication(this.getPathName(src), replication);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        return this.dfs.rename(this.getPathName(src), this.getPathName(dst));
    }

    @Override
    @Deprecated
    public boolean delete(Path f) throws IOException {
        return this.dfs.delete(this.getPathName(f));
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.dfs.delete(this.getPathName(f), recursive);
    }

    @Override
    public ContentSummary getContentSummary(Path f) throws IOException {
        return this.dfs.getContentSummary(this.getPathName(f));
    }

    public void setQuota(Path src, long namespaceQuota, long diskspaceQuota) throws IOException {
        this.dfs.setQuota(this.getPathName(src), namespaceQuota, diskspaceQuota);
    }

    private FileStatus makeQualified(FileStatus f) {
        return new FileStatus(f.getLen(), f.isDir(), f.getReplication(), f.getBlockSize(), f.getModificationTime(), f.getAccessTime(), f.getPermission(), f.getOwner(), f.getGroup(), f.getPath().makeQualified(this));
    }

    @Override
    public FileStatus[] listStatus(Path p) throws IOException {
        FileStatus[] infos = this.dfs.listPaths(this.getPathName(p));
        if (infos == null) {
            return null;
        }
        FileStatus[] stats = new FileStatus[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            stats[i] = this.makeQualified(infos[i]);
        }
        return stats;
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.dfs.mkdirs(this.getPathName(f), permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            super.processDeleteOnExit();
            this.dfs.close();
        }
        finally {
            super.close();
        }
    }

    public String toString() {
        return "DFS[" + this.dfs + "]";
    }

    public DFSClient getClient() {
        return this.dfs;
    }

    public DiskStatus getDiskStatus() throws IOException {
        return this.dfs.getDiskStatus();
    }

    public long getRawCapacity() throws IOException {
        return this.dfs.totalRawCapacity();
    }

    public long getRawUsed() throws IOException {
        return this.dfs.totalRawUsed();
    }

    public long getMissingBlocksCount() throws IOException {
        return this.dfs.getMissingBlocksCount();
    }

    public long getUnderReplicatedBlocksCount() throws IOException {
        return this.dfs.getUnderReplicatedBlocksCount();
    }

    public long getCorruptBlocksCount() throws IOException {
        return this.dfs.getCorruptBlocksCount();
    }

    public DatanodeInfo[] getDataNodeStats() throws IOException {
        return this.dfs.datanodeReport(FSConstants.DatanodeReportType.ALL);
    }

    public boolean setSafeMode(FSConstants.SafeModeAction action) throws IOException {
        return this.dfs.setSafeMode(action);
    }

    public void saveNamespace() throws AccessControlException, IOException {
        this.dfs.saveNamespace();
    }

    public void refreshNodes() throws IOException {
        this.dfs.refreshNodes();
    }

    public void finalizeUpgrade() throws IOException {
        this.dfs.finalizeUpgrade();
    }

    public UpgradeStatusReport distributedUpgradeProgress(FSConstants.UpgradeAction action) throws IOException {
        return this.dfs.distributedUpgradeProgress(action);
    }

    public void metaSave(String pathname) throws IOException {
        this.dfs.metaSave(pathname);
    }

    public boolean reportChecksumFailure(Path f, FSDataInputStream in, long inPos, FSDataInputStream sums, long sumsPos) {
        LocatedBlock[] lblocks = new LocatedBlock[2];
        DFSClient.DFSDataInputStream dfsIn = (DFSClient.DFSDataInputStream)in;
        Block dataBlock = dfsIn.getCurrentBlock();
        if (dataBlock == null) {
            LOG.error("Error: Current block in data stream is null! ");
            return false;
        }
        DatanodeInfo[] dataNode = new DatanodeInfo[]{dfsIn.getCurrentDatanode()};
        lblocks[0] = new LocatedBlock(dataBlock, dataNode);
        LOG.info("Found checksum error in data stream at block=" + dataBlock + " on datanode=" + dataNode[0].getName());
        DFSClient.DFSDataInputStream dfsSums = (DFSClient.DFSDataInputStream)sums;
        Block sumsBlock = dfsSums.getCurrentBlock();
        if (sumsBlock == null) {
            LOG.error("Error: Current block in checksum stream is null! ");
            return false;
        }
        DatanodeInfo[] sumsNode = new DatanodeInfo[]{dfsSums.getCurrentDatanode()};
        lblocks[1] = new LocatedBlock(sumsBlock, sumsNode);
        LOG.info("Found checksum error in checksum stream at block=" + sumsBlock + " on datanode=" + sumsNode[0].getName());
        this.dfs.reportChecksumFailure(f.toString(), lblocks);
        return true;
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        FileStatus fi = this.dfs.getFileInfo(this.getPathName(f));
        if (fi != null) {
            return this.makeQualified(fi);
        }
        throw new FileNotFoundException("File does not exist: " + f);
    }

    @Override
    public MD5MD5CRC32FileChecksum getFileChecksum(Path f) throws IOException {
        return this.dfs.getFileChecksum(this.getPathName(f));
    }

    @Override
    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.dfs.setPermission(this.getPathName(p), permission);
    }

    @Override
    public void setOwner(Path p, String username, String groupname) throws IOException {
        if (username == null && groupname == null) {
            throw new IOException("username == null && groupname == null");
        }
        this.dfs.setOwner(this.getPathName(p), username, groupname);
    }

    @Override
    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.dfs.setTimes(this.getPathName(p), mtime, atime);
    }

    static {
        Configuration.addDefaultResource("hdfs-default.xml");
        Configuration.addDefaultResource("hdfs-site.xml");
    }

    public static class DiskStatus {
        private long capacity;
        private long dfsUsed;
        private long remaining;

        public DiskStatus(long capacity, long dfsUsed, long remaining) {
            this.capacity = capacity;
            this.dfsUsed = dfsUsed;
            this.remaining = remaining;
        }

        public long getCapacity() {
            return this.capacity;
        }

        public long getDfsUsed() {
            return this.dfsUsed;
        }

        public long getRemaining() {
            return this.remaining;
        }
    }
}

