/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.BlockReceiver;
import org.apache.hadoop.hdfs.server.datanode.BlockSender;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataXceiverServer;
import org.apache.hadoop.hdfs.server.datanode.FSDatasetInterface;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.StringUtils;

class DataXceiver
implements Runnable,
FSConstants {
    public static final Log LOG = DataNode.LOG;
    static final Log ClientTraceLog = DataNode.ClientTraceLog;
    Socket s;
    final String remoteAddress;
    final String localAddress;
    DataNode datanode;
    DataXceiverServer dataXceiverServer;

    public DataXceiver(Socket s, DataNode datanode, DataXceiverServer dataXceiverServer) {
        this.s = s;
        this.datanode = datanode;
        this.dataXceiverServer = dataXceiverServer;
        dataXceiverServer.childSockets.put(s, s);
        this.remoteAddress = s.getRemoteSocketAddress().toString();
        this.localAddress = s.getLocalSocketAddress().toString();
        LOG.debug("Number of active connections is: " + datanode.getXceiverCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        DataInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(NetUtils.getInputStream(this.s), SMALL_BUFFER_SIZE));
            short version = in.readShort();
            if (version != 14) {
                throw new IOException("Version Mismatch");
            }
            boolean local = this.s.getInetAddress().equals(this.s.getLocalAddress());
            byte op = in.readByte();
            int curXceiverCount = this.datanode.getXceiverCount();
            if (curXceiverCount > this.dataXceiverServer.maxXceiverCount) {
                throw new IOException("xceiverCount " + curXceiverCount + " exceeds the limit of concurrent xcievers " + this.dataXceiverServer.maxXceiverCount);
            }
            long startTime = DataNode.now();
            switch (op) {
                case 81: {
                    this.readBlock(in);
                    this.datanode.myMetrics.readBlockOp.inc(DataNode.now() - startTime);
                    if (local) {
                        this.datanode.myMetrics.readsFromLocalClient.inc();
                        return;
                    } else {
                        this.datanode.myMetrics.readsFromRemoteClient.inc();
                        return;
                    }
                }
                case 80: {
                    this.writeBlock(in);
                    this.datanode.myMetrics.writeBlockOp.inc(DataNode.now() - startTime);
                    if (local) {
                        this.datanode.myMetrics.writesFromLocalClient.inc();
                        return;
                    } else {
                        this.datanode.myMetrics.writesFromRemoteClient.inc();
                        return;
                    }
                }
                case 82: {
                    this.readMetadata(in);
                    this.datanode.myMetrics.readMetadataOp.inc(DataNode.now() - startTime);
                    return;
                }
                case 83: {
                    this.replaceBlock(in);
                    this.datanode.myMetrics.replaceBlockOp.inc(DataNode.now() - startTime);
                    return;
                }
                case 84: {
                    this.copyBlock(in);
                    this.datanode.myMetrics.copyBlockOp.inc(DataNode.now() - startTime);
                    return;
                }
                case 85: {
                    this.getBlockChecksum(in);
                    this.datanode.myMetrics.blockChecksumOp.inc(DataNode.now() - startTime);
                    return;
                }
                default: {
                    throw new IOException("Unknown opcode " + op + " in data stream");
                }
            }
        }
        catch (Throwable t) {
            LOG.error(this.datanode.dnRegistration + ":DataXceiver", t);
            return;
        }
        finally {
            LOG.debug(this.datanode.dnRegistration + ":Number of active connections is: " + this.datanode.getXceiverCount());
            IOUtils.closeStream(in);
            IOUtils.closeSocket(this.s);
            this.dataXceiverServer.childSockets.remove(this.s);
        }
    }

    /*
     * Loose catch block
     */
    private void readBlock(DataInputStream in) throws IOException {
        block13: {
            long blockId = in.readLong();
            Block block = new Block(blockId, 0L, in.readLong());
            long startOffset = in.readLong();
            long length = in.readLong();
            String clientName = Text.readString(in);
            OutputStream baseStream = NetUtils.getOutputStream(this.s, this.datanode.socketWriteTimeout);
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(baseStream, SMALL_BUFFER_SIZE));
            BlockSender blockSender = null;
            String clientTraceFmt = clientName.length() > 0 && ClientTraceLog.isInfoEnabled() ? String.format("src: %s, dest: %s, bytes: %s, op: %s, cliID: %s, srvID: %s, blockid: %s", this.localAddress, this.remoteAddress, "%d", "HDFS_READ", clientName, this.datanode.dnRegistration.getStorageID(), block) : this.datanode.dnRegistration + " Served block " + block + " to " + this.s.getInetAddress();
            try {
                try {
                    blockSender = new BlockSender(block, startOffset, length, true, true, false, this.datanode, clientTraceFmt);
                }
                catch (IOException e) {
                    out.writeShort(1);
                    throw e;
                }
                out.writeShort(0);
                long read = blockSender.sendBlock(out, baseStream, null);
                if (blockSender.isBlockReadFully()) {
                    try {
                        if (in.readShort() == 5 && this.datanode.blockScanner != null) {
                            this.datanode.blockScanner.verifiedByClient(block);
                        }
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
                this.datanode.myMetrics.bytesRead.inc((int)read);
                this.datanode.myMetrics.blocksRead.inc();
                IOUtils.closeStream(out);
            }
            catch (SocketException ignored) {
                this.datanode.myMetrics.blocksRead.inc();
                break block13;
            }
            catch (IOException ioe) {
                LOG.warn(this.datanode.dnRegistration + ":Got exception while serving " + block + " to " + this.s.getInetAddress() + ":\n" + StringUtils.stringifyException(ioe));
                throw ioe;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeStream(out);
                IOUtils.closeStream(blockSender);
            }
            IOUtils.closeStream(blockSender);
        }
    }

    private void writeBlock(DataInputStream in) throws IOException {
        int numTargets;
        DatanodeInfo srcDataNode = null;
        LOG.debug("writeBlock receive buf size " + this.s.getReceiveBufferSize() + " tcp no delay " + this.s.getTcpNoDelay());
        Block block = new Block(in.readLong(), this.dataXceiverServer.estimateBlockSize, in.readLong());
        LOG.info("Receiving block " + block + " src: " + this.remoteAddress + " dest: " + this.localAddress);
        int pipelineSize = in.readInt();
        boolean isRecovery = in.readBoolean();
        String client = Text.readString(in);
        boolean hasSrcDataNode = in.readBoolean();
        if (hasSrcDataNode) {
            srcDataNode = new DatanodeInfo();
            srcDataNode.readFields(in);
        }
        if ((numTargets = in.readInt()) < 0) {
            throw new IOException("Mislabelled incoming datastream.");
        }
        DatanodeInfo[] targets = new DatanodeInfo[numTargets];
        for (int i = 0; i < targets.length; ++i) {
            DatanodeInfo tmp = new DatanodeInfo();
            tmp.readFields(in);
            targets[i] = tmp;
        }
        DataOutputStream mirrorOut = null;
        DataInputStream mirrorIn = null;
        DataOutputStream replyOut = null;
        Socket mirrorSock = null;
        BlockReceiver blockReceiver = null;
        String mirrorNode = null;
        String firstBadLink = "";
        try {
            blockReceiver = new BlockReceiver(block, in, this.s.getRemoteSocketAddress().toString(), this.s.getLocalSocketAddress().toString(), isRecovery, client, srcDataNode, this.datanode);
            replyOut = new DataOutputStream(NetUtils.getOutputStream(this.s, this.datanode.socketWriteTimeout));
            if (targets.length > 0) {
                InetSocketAddress mirrorTarget = null;
                mirrorNode = targets[0].getName();
                mirrorTarget = NetUtils.createSocketAddr(mirrorNode);
                mirrorSock = this.datanode.newSocket();
                try {
                    int timeoutValue = numTargets * this.datanode.socketTimeout;
                    int writeTimeout = this.datanode.socketWriteTimeout + 5000 * numTargets;
                    NetUtils.connect(mirrorSock, mirrorTarget, timeoutValue);
                    mirrorSock.setSoTimeout(timeoutValue);
                    mirrorSock.setSendBufferSize(131072);
                    mirrorOut = new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream(mirrorSock, writeTimeout), SMALL_BUFFER_SIZE));
                    mirrorIn = new DataInputStream(NetUtils.getInputStream(mirrorSock));
                    mirrorOut.writeShort(14);
                    mirrorOut.write(80);
                    mirrorOut.writeLong(block.getBlockId());
                    mirrorOut.writeLong(block.getGenerationStamp());
                    mirrorOut.writeInt(pipelineSize);
                    mirrorOut.writeBoolean(isRecovery);
                    Text.writeString(mirrorOut, client);
                    mirrorOut.writeBoolean(hasSrcDataNode);
                    if (hasSrcDataNode) {
                        srcDataNode.write(mirrorOut);
                    }
                    mirrorOut.writeInt(targets.length - 1);
                    for (int i = 1; i < targets.length; ++i) {
                        targets[i].write(mirrorOut);
                    }
                    blockReceiver.writeChecksumHeader(mirrorOut);
                    mirrorOut.flush();
                    if (client.length() != 0) {
                        firstBadLink = Text.readString(mirrorIn);
                        if (LOG.isDebugEnabled() || firstBadLink.length() > 0) {
                            LOG.info("Datanode " + targets.length + " got response for connect ack " + " from downstream datanode with firstbadlink as " + firstBadLink);
                        }
                    }
                }
                catch (IOException e) {
                    if (client.length() != 0) {
                        Text.writeString(replyOut, mirrorNode);
                        replyOut.flush();
                    }
                    IOUtils.closeStream(mirrorOut);
                    mirrorOut = null;
                    IOUtils.closeStream(mirrorIn);
                    mirrorIn = null;
                    IOUtils.closeSocket(mirrorSock);
                    mirrorSock = null;
                    if (client.length() > 0) {
                        throw e;
                    }
                    LOG.info(this.datanode.dnRegistration + ":Exception transfering block " + block + " to mirror " + mirrorNode + ". continuing without the mirror.\n" + StringUtils.stringifyException(e));
                }
            }
            if (client.length() != 0) {
                if (LOG.isDebugEnabled() || firstBadLink.length() > 0) {
                    LOG.info("Datanode " + targets.length + " forwarding connect ack to upstream firstbadlink is " + firstBadLink);
                }
                Text.writeString(replyOut, firstBadLink);
                replyOut.flush();
            }
            String mirrorAddr = mirrorSock == null ? null : mirrorNode;
            blockReceiver.receiveBlock(mirrorOut, mirrorIn, replyOut, mirrorAddr, null, targets.length);
            if (client.length() == 0) {
                this.datanode.notifyNamenodeReceivedBlock(block, "");
                LOG.info("Received block " + block + " src: " + this.remoteAddress + " dest: " + this.localAddress + " of size " + block.getNumBytes());
            }
            if (this.datanode.blockScanner != null) {
                this.datanode.blockScanner.addBlock(block);
            }
        }
        catch (IOException ioe) {
            try {
                LOG.info("writeBlock " + block + " received exception " + ioe);
                throw ioe;
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(mirrorOut);
                IOUtils.closeStream(mirrorIn);
                IOUtils.closeStream(replyOut);
                IOUtils.closeSocket(mirrorSock);
                IOUtils.closeStream(blockReceiver);
                throw throwable;
            }
        }
        IOUtils.closeStream(mirrorOut);
        IOUtils.closeStream(mirrorIn);
        IOUtils.closeStream(replyOut);
        IOUtils.closeSocket(mirrorSock);
        IOUtils.closeStream(blockReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readMetadata(DataInputStream in) throws IOException {
        Block block = new Block(in.readLong(), 0L, in.readLong());
        FSDatasetInterface.MetaDataInputStream checksumIn = null;
        DataOutputStream out = null;
        try {
            checksumIn = this.datanode.data.getMetaDataInputStream(block);
            long fileSize = checksumIn.getLength();
            if (fileSize >= 0x80000000L || fileSize <= 0L) {
                throw new IOException("Unexpected size for checksumFile of block" + block);
            }
            byte[] buf = new byte[(int)fileSize];
            IOUtils.readFully(checksumIn, buf, 0, buf.length);
            out = new DataOutputStream(NetUtils.getOutputStream(this.s, this.datanode.socketWriteTimeout));
            out.writeByte(0);
            out.writeInt(buf.length);
            out.write(buf);
            out.writeInt(0);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(out);
            IOUtils.closeStream(checksumIn);
            throw throwable;
        }
        IOUtils.closeStream(out);
        IOUtils.closeStream(checksumIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getBlockChecksum(DataInputStream in) throws IOException {
        Block block = new Block(in.readLong(), 0L, in.readLong());
        DataOutputStream out = null;
        FSDatasetInterface.MetaDataInputStream metadataIn = this.datanode.data.getMetaDataInputStream(block);
        DataInputStream checksumIn = new DataInputStream(new BufferedInputStream(metadataIn, BUFFER_SIZE));
        try {
            BlockMetadataHeader header = BlockMetadataHeader.readHeader(checksumIn);
            DataChecksum checksum = header.getChecksum();
            int bytesPerCRC = checksum.getBytesPerChecksum();
            long crcPerBlock = (metadataIn.getLength() - (long)BlockMetadataHeader.getHeaderSize()) / (long)checksum.getChecksumSize();
            MD5Hash md5 = MD5Hash.digest(checksumIn);
            if (LOG.isDebugEnabled()) {
                LOG.debug("block=" + block + ", bytesPerCRC=" + bytesPerCRC + ", crcPerBlock=" + crcPerBlock + ", md5=" + md5);
            }
            out = new DataOutputStream(NetUtils.getOutputStream(this.s, this.datanode.socketWriteTimeout));
            out.writeShort(0);
            out.writeInt(bytesPerCRC);
            out.writeLong(crcPerBlock);
            md5.write(out);
            out.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(out);
            IOUtils.closeStream(checksumIn);
            IOUtils.closeStream(metadataIn);
            throw throwable;
        }
        IOUtils.closeStream(out);
        IOUtils.closeStream(checksumIn);
        IOUtils.closeStream(metadataIn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyBlock(DataInputStream in) throws IOException {
        DataOutputStream reply;
        BlockSender blockSender;
        block10: {
            long blockId = in.readLong();
            Block block = new Block(blockId, 0L, in.readLong());
            if (!this.dataXceiverServer.balanceThrottler.acquire()) {
                LOG.info("Not able to copy block " + blockId + " to " + this.s.getRemoteSocketAddress() + " because threads quota is exceeded.");
                return;
            }
            blockSender = null;
            reply = null;
            boolean isOpSuccess = true;
            try {
                blockSender = new BlockSender(block, 0L, -1L, false, false, false, this.datanode);
                OutputStream baseStream = NetUtils.getOutputStream(this.s, this.datanode.socketWriteTimeout);
                reply = new DataOutputStream(new BufferedOutputStream(baseStream, SMALL_BUFFER_SIZE));
                long read = blockSender.sendBlock(reply, baseStream, this.dataXceiverServer.balanceThrottler);
                this.datanode.myMetrics.bytesRead.inc((int)read);
                this.datanode.myMetrics.blocksRead.inc();
                LOG.info("Copied block " + block + " to " + this.s.getRemoteSocketAddress());
                this.dataXceiverServer.balanceThrottler.release();
                if (!isOpSuccess) break block10;
            }
            catch (IOException ioe) {
                try {
                    isOpSuccess = false;
                    throw ioe;
                }
                catch (Throwable throwable) {
                    this.dataXceiverServer.balanceThrottler.release();
                    if (isOpSuccess) {
                        try {
                            reply.writeChar(100);
                        }
                        catch (IOException ignored) {
                            // empty catch block
                        }
                    }
                    IOUtils.closeStream(reply);
                    IOUtils.closeStream(blockSender);
                    throw throwable;
                }
            }
            try {
                reply.writeChar(100);
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        IOUtils.closeStream(reply);
        IOUtils.closeStream(blockSender);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replaceBlock(DataInputStream in) throws IOException {
        DataInputStream proxyReply;
        BlockReceiver blockReceiver;
        short opStatus;
        DataOutputStream proxyOut;
        block14: {
            long blockId = in.readLong();
            Block block = new Block(blockId, this.dataXceiverServer.estimateBlockSize, in.readLong());
            String sourceID = Text.readString(in);
            DatanodeInfo proxySource = new DatanodeInfo();
            proxySource.readFields(in);
            if (!this.dataXceiverServer.balanceThrottler.acquire()) {
                LOG.warn("Not able to receive block " + blockId + " from " + this.s.getRemoteSocketAddress() + " because threads quota is exceeded.");
                this.sendResponse(this.s, (short)1, this.datanode.socketWriteTimeout);
                return;
            }
            Socket proxySock = null;
            proxyOut = null;
            opStatus = 0;
            blockReceiver = null;
            proxyReply = null;
            try {
                InetSocketAddress proxyAddr = NetUtils.createSocketAddr(proxySource.getName());
                proxySock = this.datanode.newSocket();
                NetUtils.connect(proxySock, proxyAddr, this.datanode.socketTimeout);
                proxySock.setSoTimeout(this.datanode.socketTimeout);
                OutputStream baseStream = NetUtils.getOutputStream(proxySock, this.datanode.socketWriteTimeout);
                proxyOut = new DataOutputStream(new BufferedOutputStream(baseStream, SMALL_BUFFER_SIZE));
                proxyOut.writeShort(14);
                proxyOut.writeByte(84);
                proxyOut.writeLong(block.getBlockId());
                proxyOut.writeLong(block.getGenerationStamp());
                proxyOut.flush();
                proxyReply = new DataInputStream(new BufferedInputStream(NetUtils.getInputStream(proxySock), BUFFER_SIZE));
                blockReceiver = new BlockReceiver(block, proxyReply, proxySock.getRemoteSocketAddress().toString(), proxySock.getLocalSocketAddress().toString(), false, "", null, this.datanode);
                blockReceiver.receiveBlock(null, null, null, null, this.dataXceiverServer.balanceThrottler, -1);
                this.datanode.notifyNamenodeReceivedBlock(block, sourceID);
                LOG.info("Moved block " + block + " from " + this.s.getRemoteSocketAddress());
                if (opStatus != 0) break block14;
            }
            catch (IOException ioe) {
                try {
                    opStatus = 1;
                    throw ioe;
                }
                catch (Throwable throwable) {
                    if (opStatus == 0) {
                        try {
                            proxyReply.readChar();
                        }
                        catch (IOException ignored) {
                            // empty catch block
                        }
                    }
                    this.dataXceiverServer.balanceThrottler.release();
                    try {
                        this.sendResponse(this.s, opStatus, this.datanode.socketWriteTimeout);
                    }
                    catch (IOException ioe2) {
                        LOG.warn("Error writing reply back to " + this.s.getRemoteSocketAddress());
                    }
                    IOUtils.closeStream(proxyOut);
                    IOUtils.closeStream(blockReceiver);
                    IOUtils.closeStream(proxyReply);
                    throw throwable;
                }
            }
            try {
                proxyReply.readChar();
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        this.dataXceiverServer.balanceThrottler.release();
        try {
            this.sendResponse(this.s, opStatus, this.datanode.socketWriteTimeout);
        }
        catch (IOException ioe) {
            LOG.warn("Error writing reply back to " + this.s.getRemoteSocketAddress());
        }
        IOUtils.closeStream(proxyOut);
        IOUtils.closeStream(blockReceiver);
        IOUtils.closeStream(proxyReply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(Socket s, short opStatus, long timeout) throws IOException {
        DataOutputStream reply = new DataOutputStream(NetUtils.getOutputStream(s, timeout));
        try {
            reply.writeShort(opStatus);
            reply.flush();
        }
        finally {
            IOUtils.closeStream(reply);
        }
    }
}

