/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.lib.KeyFieldHelper;

public class KeyFieldBasedPartitioner<K2, V2>
implements Partitioner<K2, V2> {
    private static final Log LOG = LogFactory.getLog(KeyFieldBasedPartitioner.class.getName());
    private int numOfPartitionFields;
    private KeyFieldHelper keyFieldHelper = new KeyFieldHelper();

    @Override
    public void configure(JobConf job) {
        String keyFieldSeparator = job.get("map.output.key.field.separator", "\t");
        this.keyFieldHelper.setKeyFieldSeparator(keyFieldSeparator);
        if (job.get("num.key.fields.for.partition") != null) {
            LOG.warn("Using deprecated num.key.fields.for.partition. Use mapred.text.key.partitioner.options instead");
            this.numOfPartitionFields = job.getInt("num.key.fields.for.partition", 0);
            this.keyFieldHelper.setKeyFieldSpec(1, this.numOfPartitionFields);
        } else {
            String option = job.getKeyFieldPartitionerOption();
            this.keyFieldHelper.parseOption(option);
        }
    }

    @Override
    public int getPartition(K2 key, V2 value, int numReduceTasks) {
        byte[] keyBytes;
        List<KeyFieldHelper.KeyDescription> allKeySpecs = this.keyFieldHelper.keySpecs();
        if (allKeySpecs.size() == 0) {
            return this.getPartition(key.toString().hashCode(), numReduceTasks);
        }
        try {
            keyBytes = key.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("The current system does not support UTF-8 encoding!", e);
        }
        if (keyBytes.length == 0) {
            return 0;
        }
        int[] lengthIndicesFirst = this.keyFieldHelper.getWordLengths(keyBytes, 0, keyBytes.length);
        int currentHash = 0;
        for (KeyFieldHelper.KeyDescription keySpec : allKeySpecs) {
            int startChar = this.keyFieldHelper.getStartOffset(keyBytes, 0, keyBytes.length, lengthIndicesFirst, keySpec);
            if (startChar < 0) continue;
            int endChar = this.keyFieldHelper.getEndOffset(keyBytes, 0, keyBytes.length, lengthIndicesFirst, keySpec);
            currentHash = this.hashCode(keyBytes, startChar, endChar, currentHash);
        }
        return this.getPartition(currentHash, numReduceTasks);
    }

    protected int hashCode(byte[] b, int start, int end, int currentHash) {
        for (int i = start; i <= end; ++i) {
            currentHash = 31 * currentHash + b[i];
        }
        return currentHash;
    }

    protected int getPartition(int hash, int numReduceTasks) {
        return (hash & Integer.MAX_VALUE) % numReduceTasks;
    }
}

