/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.MemoryCalculatorPlugin;

public class LinuxMemoryCalculatorPlugin
extends MemoryCalculatorPlugin {
    private static final Log LOG = LogFactory.getLog(LinuxMemoryCalculatorPlugin.class);
    private static final String PROCFS_MEMFILE = "/proc/meminfo";
    private static final Pattern PROCFS_MEMFILE_FORMAT = Pattern.compile("^([a-zA-Z]*):[ \t]*([0-9]*)[ \t]kB");
    private static final String MEMTOTAL_STRING = "MemTotal";
    private static final String SWAPTOTAL_STRING = "SwapTotal";
    private long ramSize = 0L;
    private long swapSize = 0L;
    boolean readMemInfoFile = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProcMemInfoFile() {
        if (this.readMemInfoFile) {
            return;
        }
        BufferedReader in = null;
        FileReader fReader = null;
        try {
            fReader = new FileReader(PROCFS_MEMFILE);
            in = new BufferedReader(fReader);
        }
        catch (FileNotFoundException f) {
            return;
        }
        Matcher mat = null;
        try {
            String str = in.readLine();
            while (str != null) {
                mat = PROCFS_MEMFILE_FORMAT.matcher(str);
                if (mat.find()) {
                    if (mat.group(1).equals(MEMTOTAL_STRING)) {
                        this.ramSize = Long.parseLong(mat.group(2));
                    } else if (mat.group(1).equals(SWAPTOTAL_STRING)) {
                        this.swapSize = Long.parseLong(mat.group(2));
                    }
                }
                str = in.readLine();
            }
        }
        catch (IOException io) {
            LOG.warn("Error reading the stream " + io);
        }
        finally {
            try {
                fReader.close();
                try {
                    in.close();
                }
                catch (IOException i) {
                    LOG.warn("Error closing the stream " + in);
                }
            }
            catch (IOException i) {
                LOG.warn("Error closing the stream " + fReader);
            }
        }
        this.readMemInfoFile = true;
    }

    @Override
    public long getPhysicalMemorySize() {
        this.readProcMemInfoFile();
        return this.ramSize * 1024L;
    }

    @Override
    public long getVirtualMemorySize() {
        this.readProcMemInfoFile();
        return (this.ramSize + this.swapSize) * 1024L;
    }

    public static void main(String[] args) {
        LinuxMemoryCalculatorPlugin plugin = new LinuxMemoryCalculatorPlugin();
        System.out.println("Physical memory Size(bytes) : " + plugin.getPhysicalMemorySize());
        System.out.println("Total Virtual memory Size(bytes) : " + plugin.getVirtualMemorySize());
    }
}

