/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountFilter;

public final class LimitTokenCountAnalyzer
extends AnalyzerWrapper {
    private final Analyzer delegate;
    private final int maxTokenCount;

    public LimitTokenCountAnalyzer(Analyzer delegate, int maxTokenCount) {
        this.delegate = delegate;
        this.maxTokenCount = maxTokenCount;
    }

    @Override
    protected Analyzer getWrappedAnalyzer(String fieldName) {
        return this.delegate;
    }

    @Override
    protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
        return new Analyzer.TokenStreamComponents(components.getTokenizer(), new LimitTokenCountFilter(components.getTokenStream(), this.maxTokenCount));
    }

    public String toString() {
        return "LimitTokenCountAnalyzer(" + this.delegate.toString() + ", maxTokenCount=" + this.maxTokenCount + ")";
    }
}

