/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.TermsConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FieldsEnum;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.Terms;

public abstract class FieldsConsumer
implements Closeable {
    public abstract TermsConsumer addField(FieldInfo var1) throws IOException;

    @Override
    public abstract void close() throws IOException;

    public void merge(MergeState mergeState, Fields fields) throws IOException {
        String field;
        FieldsEnum fieldsEnum = fields.iterator();
        assert (fieldsEnum != null);
        while ((field = fieldsEnum.next()) != null) {
            mergeState.fieldInfo = mergeState.fieldInfos.fieldInfo(field);
            assert (mergeState.fieldInfo != null) : "FieldInfo for field is null: " + field;
            Terms terms = fieldsEnum.terms();
            if (terms == null) continue;
            TermsConsumer termsConsumer = this.addField(mergeState.fieldInfo);
            termsConsumer.merge(mergeState, terms.iterator(null));
        }
    }
}

